/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.impl.Util;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import edu.stanford.smi.protege.model.BrowserSlotPattern;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.DefaultKnowledgeBase;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameFactory;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.FrameNameValidator;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.Model;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.SystemFrames;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.FrameStoreManager;
import edu.stanford.smi.protege.model.framestore.MergingNarrowFrameStore;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.widget.WidgetMapper;
import edu.stanford.smi.protegex.owl.jena.graph.JenaModelFactory;
import edu.stanford.smi.protegex.owl.model.DefaultTaskManager;
import edu.stanford.smi.protegex.owl.model.NamespaceManager;
import edu.stanford.smi.protegex.owl.model.NamespaceManagerListener;
import edu.stanford.smi.protegex.owl.model.OWLAllDifferent;
import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLCardinality;
import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLEnumeratedClass;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLMaxCardinality;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLNames;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.ProtegeNames;
import edu.stanford.smi.protegex.owl.model.RDFExternalResource;
import edu.stanford.smi.protegex.owl.model.RDFIndividual;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFNames;
import edu.stanford.smi.protegex.owl.model.RDFObject;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSDatatypeFactory;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFSNames;
import edu.stanford.smi.protegex.owl.model.RDFUntypedResource;
import edu.stanford.smi.protegex.owl.model.TaskManager;
import edu.stanford.smi.protegex.owl.model.classdisplay.OWLClassDisplay;
import edu.stanford.smi.protegex.owl.model.classdisplay.OWLClassDisplayFactory;
import edu.stanford.smi.protegex.owl.model.classparser.OWLClassParser;
import edu.stanford.smi.protegex.owl.model.event.ClassAdapter;
import edu.stanford.smi.protegex.owl.model.event.ClassListener;
import edu.stanford.smi.protegex.owl.model.event.ModelAdapter;
import edu.stanford.smi.protegex.owl.model.event.ModelListener;
import edu.stanford.smi.protegex.owl.model.event.PropertyAdapter;
import edu.stanford.smi.protegex.owl.model.event.PropertyListener;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueAdapter;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueListener;
import edu.stanford.smi.protegex.owl.model.event.ResourceAdapter;
import edu.stanford.smi.protegex.owl.model.event.ResourceListener;
import edu.stanford.smi.protegex.owl.model.factory.OWLJavaFactory;
import edu.stanford.smi.protegex.owl.model.framestore.OWLFrameStore;
import edu.stanford.smi.protegex.owl.model.framestore.OWLFrameStoreManager;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLNamedClass;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFProperty;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFSDatatypeFactory;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFSLiteral;
import edu.stanford.smi.protegex.owl.model.impl.NoopProgressDisplay;
import edu.stanford.smi.protegex.owl.model.impl.XMLSchemaDatatypes;
import edu.stanford.smi.protegex.owl.model.project.DefaultOWLProject;
import edu.stanford.smi.protegex.owl.model.project.OWLProject;
import edu.stanford.smi.protegex.owl.model.project.SettingsMap;
import edu.stanford.smi.protegex.owl.model.query.QueryResults;
import edu.stanford.smi.protegex.owl.model.query.SPARQLQueryResults;
import edu.stanford.smi.protegex.owl.model.triplestore.Triple;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.DefaultTriple;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.DefaultTuple;
import edu.stanford.smi.protegex.owl.model.validator.DefaultPropertyValueValidator;
import edu.stanford.smi.protegex.owl.model.validator.PropertyValueValidator;
import edu.stanford.smi.protegex.owl.repository.RepositoryManager;
import edu.stanford.smi.protegex.owl.repository.util.RepositoryFileManager;
import edu.stanford.smi.protegex.owl.testing.OWLTest;
import edu.stanford.smi.protegex.owl.testing.OWLTestLibrary;
import edu.stanford.smi.protegex.owl.ui.widget.OWLFormWidget;
import edu.stanford.smi.protegex.owl.ui.widget.OWLWidgetMapper;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.Assert;

public abstract class AbstractOWLModel
extends DefaultKnowledgeBase
implements NamespaceManagerListener,
OWLModel {
    private static transient Logger log = Log.getLogger(AbstractOWLModel.class);
    private Cls owlAllDifferentClass;
    private Cls owlAnnotationPropertyClass;
    private Cls owlDeprecatedClassClass;
    private Cls owlDeprecatedPropertyClass;
    private Cls owlFunctionalPropertyClass;
    private Cls owlInverseFunctionalPropertyClass;
    private Cls owlSymmetricPropertyClass;
    private Cls owlTransitivePropertyClass;
    private Cls owlAllValuesFromClass;
    private Cls anonymousClassMetaCls;
    private Cls anonymousRootCls;
    private Cls owlDataRangeClass;
    private Cls owlEnumeratedClassClass;
    private Cls rdfExternalResourceClass;
    private Cls rdfListClass;
    private Cls owlOntologyClass;
    private Cls owlClassMetaCls;
    private Cls owlRestrictionClass;
    private Cls owlSomeValuesFromClass;
    private Cls owlHasValueClass;
    private Cls owlMinCardinalityClass;
    private Cls owlMaxCardinalityClass;
    private Cls owlCardinalityClass;
    private Cls owlLogicalClassClass;
    private Cls owlIntersectionClassClass;
    private Cls rdfStatementClass;
    private Cls rdfAltClass;
    private Cls rdfBagClass;
    private Cls rdfsNamedClassClass;
    private Cls rdfsContainerClass;
    private Cls rdfsDatatypeClass;
    private Cls rdfSeqClass;
    private Cls owlUnionClassClass;
    private Cls owlComplementClassClass;
    private Cls owlNamedClassClass;
    private Cls owlNothingClass;
    private Cls rdfsLiteralClass;
    private Cls rdfPropertyClass;
    private Cls owlDatatypePropertyClass;
    private Cls owlObjectPropertyClass;
    private Slot owlAllValuesFromProperty;
    private Slot owlBackwardCompatibleWithProperty;
    private Slot owlCardinalityProperty;
    private Slot owlComplementOfProperty;
    private Slot owlDisjointWithProperty;
    private Slot owlEquivalentClassProperty;
    private Slot owlValuesFromProperty;
    private Slot rdfsDomainProperty;
    private Slot rdfsRangeProperty;
    private Slot rdfsSubClassOfProperty;
    private Slot rdfsSubPropertyOfProperty;
    private Slot protegeClassificationStatusProperty;
    private Slot rdfsCommentProperty;
    private Slot owlDifferentFromProperty;
    private Slot owlDistinctMembersProperty;
    private Slot owlEquivalentPropertyProperty;
    private Slot owlHasValueProperty;
    private Slot owlIncompatibleWithProperty;
    private Slot owlInverseOfProperty;
    private Slot protegeInferredTypeProperty;
    private Slot protegeInferredSubclassesProperty;
    private Slot protegeInferredSuperclassesProperty;
    private Slot owlIntersectionOfProperty;
    private Slot rdfsIsDefinedByProperty;
    private Slot rdfsLabelProperty;
    private Slot owlLogicalOperandsProperty;
    private Slot owlMaxCardinalityProperty;
    private Slot owlMinCardinalityProperty;
    private Slot nameSlot;
    private Slot owlOnPropertyProperty;
    private Slot owlImportsProperty;
    private Slot owlOntologyPrefixesProperty;
    private Slot owlOneOfProperty;
    private Slot owlUnionOfProperty;
    private Slot owlPriorVersionProperty;
    private Slot rdfFirstProperty;
    private Slot rdfObjectProperty;
    private Slot rdfPredicateProperty;
    private Slot rdfRestSlot;
    private Slot rdfSubjectProperty;
    private Slot rdfTypeProperty;
    private Slot rdfValueProperty;
    private Slot rdfsMemberProperty;
    private Slot owlResourceURIProperty;
    private Slot owlSameAsProperty;
    private Slot rdfsSeeAlsoProperty;
    private Slot owlSomeValuesFromProperty;
    private Slot owlVersionInfoProperty;
    private Slot protegeSubclassesDisjointProperty;
    private RDFSDatatype xsdBoolean;
    private RDFSDatatype xsdDouble;
    private RDFSDatatype xsdFloat;
    private RDFSDatatype xsdLong;
    private RDFSDatatype xsdInt;
    private RDFSDatatype xsdShort;
    private RDFSDatatype xsdByte;
    private RDFSDatatype xsdString;
    private RDFSDatatype xsdBase64Binary;
    private RDFSDatatype xsdDate;
    private RDFSDatatype xsdTime;
    private RDFSDatatype xsdDateTime;
    private RDFSDatatype xsdDuration;
    private RDFSDatatype xsdAnyURI;
    private RDFSDatatype xsdDecimal;
    private RDFSDatatype xsdInteger;
    private RDFSDatatype xmlLiteralType;
    private Set floatDatatypes = new HashSet();
    private Set integerDatatypes = new HashSet();
    private int systemID = 9001;
    private boolean inInit = true;
    private Model jenaModel;
    public static final String ANONYMOUS_BASE = "@";
    private boolean bootstrapped = false;
    private OWLClassDisplay owlClassRenderer = OWLClassDisplayFactory.getDefaultDisplay();
    private OWLFrameStore owlFrameStore;
    private OWLProject owlProject;
    private PropertyValueValidator propertyValueValidator = new DefaultPropertyValueValidator();
    public static final String DEFAULT_TODO_PREFIX = "TODO";
    public static final String[] DEFAULT_USED_LANGUAGES = new String[]{"de", "en", "es", "fr", "it", "nl", "pt", "ru"};
    private boolean loadDefaults = true;
    private NamespaceManager namespaceManager;
    private Instance rdfNilIndividual;
    private OWLNamedClass owlThingClass;
    private static final String SEARCH_SYNONYMS_KEY = "OWL-SEARCH-SYNONYMS-SLOTS";
    private static final String SEARCH_SYNONYMS_SEPARATOR = ",";
    private static final String VALID_SYMBOLS = "-.";
    private Set defaultAnonymousTypes = new HashSet();
    public static final String DEFAULT_ANNOTATION_PROPERTY_NAME = "annotationProperty";
    public static final String DEFAULT_CLASS_NAME = "Class";
    public static final String DEFAULT_DATATYPE_PROPERTY_NAME = "datatypeProperty";
    public static final String DEFAULT_INDIVIDUAL_NAME = "Individual";
    public static final String DEFAULT_OBJECT_PROPERTY_NAME = "objectProperty";
    public static final String DEFAULT_PROPERTY_NAME = "property";
    private RDFSDatatypeFactory rdfsDatatypeFactory = new DefaultRDFSDatatypeFactory(this);
    private TaskManager taskManager;
    private RepositoryManager repositoryManager;
    private int anonCount = 1;
    private static final String AUTO_REPAIR_ENABLED = "TestAutoRepairEnabled";
    private static final String TEST_LIST_NAME = "DisabledTest";
    private static final String TESTGROUP_LIST_NAME = "DisabledTestGroups";
    private int lastGen = 1;

    public AbstractOWLModel(KnowledgeBaseFactory knowledgeBaseFactory) {
        super(knowledgeBaseFactory);
        this.resetSystemFrames();
    }

    public AbstractOWLModel(KnowledgeBaseFactory knowledgeBaseFactory, NamespaceManager namespaceManager) {
        super(knowledgeBaseFactory);
        this.resetSystemFrames();
        this.initialize(namespaceManager);
    }

    private void resetSystemFrames() {
        MergingNarrowFrameStore mergingNarrowFrameStore = MergingNarrowFrameStore.get((KnowledgeBase)this);
        if (mergingNarrowFrameStore == null) {
            this.adjustThing();
            this.initOWLFrameFactoryInvocationHandler();
            String string = this.getRootCls().getDirectType().getName();
            if (string.equals(":STANDARD-CLASS")) {
                this.bootstrap();
            }
        } else {
            NarrowFrameStore narrowFrameStore = mergingNarrowFrameStore.getSystemFrameStore();
            NarrowFrameStore narrowFrameStore2 = mergingNarrowFrameStore.setActiveFrameStore(narrowFrameStore);
            this.adjustThing();
            this.initOWLFrameFactoryInvocationHandler();
            this.bootstrap();
            mergingNarrowFrameStore.setActiveFrameStore(narrowFrameStore2);
        }
    }

    public void initialize(NamespaceManager namespaceManager) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Phase 2 initialization of OWL Model starts");
        }
        this.namespaceManager = namespaceManager;
        namespaceManager.addNamespaceManagerListener(this);
        this.setGenerateDeletingFrameEventsEnabled(true);
        this.inInit = false;
        namespaceManager.init(this);
        this.createDefaultOWLOntology();
        namespaceManager.setModifiable("owl", false);
        namespaceManager.setModifiable("rdf", false);
        namespaceManager.setModifiable("rdfs", false);
        namespaceManager.setModifiable("xsd", false);
        this.setDefaultClsMetaCls(this.owlNamedClassClass);
        this.setDefaultSlotMetaCls(this.owlDatatypePropertyClass);
        this.setFrameNameValidator(new FrameNameValidator(){

            public String getErrorMessage(String string, Frame frame) {
                if (frame instanceof RDFUntypedResource) {
                    return "The name \"" + string + "\" is not a valid URI.";
                }
                String string2 = AbstractOWLModel.this.getValidNamespaceFrameName(string);
                return "The name \"" + string + "\" is not a valid OWL identifier.\n" + "You might want to use \"" + string2 + "\" instead.";
            }

            public boolean isValid(String string, Frame frame) {
                if (frame != null && !frame.isEditable()) {
                    return true;
                }
                if (frame instanceof RDFUntypedResource) {
                    if (string.equals(string.trim()) && string.length() > 4) {
                        try {
                            new URI(string);
                            return true;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return false;
                }
                NamespaceManager namespaceManager = AbstractOWLModel.this.getNamespaceManager();
                return AbstractOWLModel.isValidOWLFrameName(namespaceManager, string);
            }
        });
        this.initOWLFrameStore();
        this.defaultAnonymousTypes.add(this.rdfListClass);
        this.defaultAnonymousTypes.add(this.owlAllValuesFromClass);
        this.defaultAnonymousTypes.add(this.owlSomeValuesFromClass);
        this.defaultAnonymousTypes.add(this.owlHasValueClass);
        this.defaultAnonymousTypes.add(this.owlMinCardinalityClass);
        this.defaultAnonymousTypes.add(this.owlMaxCardinalityClass);
        this.defaultAnonymousTypes.add(this.owlCardinalityClass);
        this.defaultAnonymousTypes.add(this.owlComplementClassClass);
        this.defaultAnonymousTypes.add(this.owlIntersectionClassClass);
        this.defaultAnonymousTypes.add(this.owlUnionClassClass);
        this.defaultAnonymousTypes.add(this.owlEnumeratedClassClass);
        this.defaultAnonymousTypes.add(this.owlAllDifferentClass);
        this.defaultAnonymousTypes.add(this.owlDataRangeClass);
        this.bootstrapped = true;
        this.taskManager = new DefaultTaskManager();
        this.taskManager.setProgressDisplay(new NoopProgressDisplay());
        if (super.getProject() != null) {
            this.setProject(super.getProject());
        }
    }

    public void addClassListener(ClassListener classListener) {
        if (!(classListener instanceof ClassAdapter)) {
            throw new IllegalArgumentException("Listener must be a ClassAdapter");
        }
        this.addClsListener(classListener);
    }

    public void addModelListener(ModelListener modelListener) {
        if (!(modelListener instanceof ModelAdapter)) {
            throw new IllegalArgumentException("Listener must be a ModelAdapter");
        }
        this.addKnowledgeBaseListener(modelListener);
    }

    public void addPropertyListener(PropertyListener propertyListener) {
        if (!(propertyListener instanceof PropertyAdapter)) {
            throw new IllegalArgumentException("Listener must be a PropertyAdapter");
        }
        this.addSlotListener(propertyListener);
    }

    public void addPropertyValueListener(PropertyValueListener propertyValueListener) {
        if (!(propertyValueListener instanceof PropertyValueAdapter)) {
            throw new IllegalArgumentException("Listener must be a PropertyValueAdapter");
        }
        this.addFrameListener(propertyValueListener);
    }

    public RDFSLiteral asRDFSLiteral(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof RDFSLiteral) {
            return (RDFSLiteral)object;
        }
        return this.createRDFSLiteral(object);
    }

    public RDFObject asRDFObject(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof RDFExternalResource) {
            return null;
        }
        if (object instanceof RDFResource) {
            return (RDFObject)object;
        }
        return this.createRDFSLiteral(object);
    }

    public List asRDFSLiterals(Collection collection) {
        LinkedList<RDFSLiteral> linkedList = new LinkedList<RDFSLiteral>();
        for (Object e : collection) {
            if (e instanceof String) {
                String string = (String)e;
                if (DefaultRDFSLiteral.isRawValue(string)) {
                    linkedList.add(new DefaultRDFSLiteral(this, string));
                    continue;
                }
                linkedList.add(this.createRDFSLiteral(e));
                continue;
            }
            linkedList.add((RDFSLiteral)e);
        }
        return linkedList;
    }

    public void addResourceListener(ResourceListener resourceListener) {
        if (!(resourceListener instanceof ResourceAdapter)) {
            throw new IllegalArgumentException("Listener must be a ResourceAdapter");
        }
        this.addInstanceListener(resourceListener);
    }

    public void adjustSystemClasses() {
        Slot[] slotArray = new Slot[]{this.nameSlot, this.rdfsLabelProperty, this.rdfsIsDefinedByProperty, this.rdfsSeeAlsoProperty, this.owlVersionInfoProperty, this.owlDifferentFromProperty, this.owlSameAsProperty, this.rdfValueProperty, this.rdfsMemberProperty, this.protegeInferredTypeProperty};
        for (int i = 0; i < slotArray.length; ++i) {
            Slot slot = slotArray[i];
            Collection collection = slot.getDirectDomain();
            if (collection.size() == 1 && collection.contains(this.owlThingClass)) continue;
            for (Cls cls : new ArrayList(collection)) {
                cls.removeDirectTemplateSlot(slot);
            }
            this.owlThingClass.addDirectTemplateSlot(slot);
        }
    }

    public void adjustThing() {
        this.getRootCls().setName("owl:Thing");
    }

    public abstract void initOWLFrameFactoryInvocationHandler();

    protected void initOWLFrameStore() {
        if (!(this.getFrameStores().get(0) instanceof OWLFrameStore)) {
            this.owlFrameStore = new OWLFrameStore(this);
            this.insertFrameStore((FrameStore)this.owlFrameStore);
        }
    }

    private Cls createSystemCls(String string, Cls cls) {
        return this.createSystemCls(string, Collections.singleton(cls), cls.getDirectType());
    }

    private Cls createSystemCls(String string, Collection collection, Cls cls) {
        return this.createCls(FrameID.createSystem((int)this.systemID++), string, collection, Collections.singleton(cls), false);
    }

    protected SystemFrames createSystemFrames() {
        SystemFrames systemFrames = super.createSystemFrames();
        systemFrames.replaceFrame((Frame)new DefaultRDFProperty(this, Model.SlotID.DIRECT_SUPERSLOTS));
        return systemFrames;
    }

    public void bootstrap() {
        this.nameSlot = this.getSlot(":NAME");
        Cls cls = this.getCls(":STANDARD-CLASS");
        this.anonymousRootCls = this.createSystemCls(":OWL-ANONYMOUS-ROOT", this.getCls(":SYSTEM-CLASS"));
        this.owlClassMetaCls = this.createSystemCls(":OWL-CLASS", this.getCls(":CLASS"));
        this.owlClassMetaCls.setAbstract(true);
        this.rdfsNamedClassClass = this.createSystemCls("rdfs:Class", Arrays.asList(this.getRootCls(), this.owlClassMetaCls, cls), cls);
        this.rdfsNamedClassClass.setDirectType(this.rdfsNamedClassClass);
        this.owlClassMetaCls.setDirectType(this.rdfsNamedClassClass);
        this.owlNamedClassClass = this.createSystemCls("owl:Class", this.rdfsNamedClassClass);
        this.owlNamedClassClass.setDirectType(this.owlNamedClassClass);
        this.owlNamedClassClass = this.getCls("owl:Class");
        this.rdfsNamedClassClass.setDirectType(this.owlNamedClassClass);
        this.rdfsNamedClassClass = this.getCls("rdfs:Class");
        this.getRootCls().setDirectType(this.owlNamedClassClass);
        this.anonymousRootCls.setDirectType(this.rdfsNamedClassClass);
        this.anonymousClassMetaCls = this.createSystemCls("owl:AnonymousClass", Collections.singleton(this.owlClassMetaCls), this.rdfsNamedClassClass);
        this.anonymousClassMetaCls.setAbstract(true);
        this.owlEnumeratedClassClass = this.createSystemCls("owl:EnumeratedClass", this.anonymousClassMetaCls);
        List<Cls> list = Arrays.asList(this.getRootCls(), this.getCls(":STANDARD-SLOT"));
        this.rdfPropertyClass = this.createSystemCls("rdf:Property", list, this.owlNamedClassClass);
        this.rdfPropertyClass = this.getCls("rdf:Property");
        this.owlDatatypePropertyClass = this.createSystemCls("owl:DatatypeProperty", this.rdfPropertyClass);
        this.owlObjectPropertyClass = this.createSystemCls("owl:ObjectProperty", this.rdfPropertyClass);
        this.rdfsDomainProperty = this.createSystemSlot("rdfs:domain", this.rdfPropertyClass);
        this.rdfsDomainProperty.setValueType(ValueType.INSTANCE);
        this.rdfsRangeProperty = this.createSystemSlot("rdfs:range", this.rdfPropertyClass);
        this.rdfsRangeProperty.setValueType(ValueType.INSTANCE);
        this.rdfPropertyClass.addDirectTemplateSlot(this.rdfsDomainProperty);
        this.rdfPropertyClass.addDirectTemplateSlot(this.rdfsRangeProperty);
        this.owlInverseOfProperty = this.getSlot(":SLOT-INVERSE");
        this.owlInverseOfProperty.setDirectType(this.rdfPropertyClass);
        this.owlInverseOfProperty = this.getSlot(":SLOT-INVERSE");
        this.owlInverseOfProperty.setName("owl:inverseOf");
        this.owlInverseOfProperty.setValueType(ValueType.INSTANCE);
        this.owlInverseOfProperty.setAllowedClses(Collections.singleton(this.owlObjectPropertyClass));
        this.rdfsDatatypeClass = this.createSystemCls("rdfs:Datatype", Collections.singleton(this.owlThingClass), this.rdfsNamedClassClass);
        this.initRDFDatatypes();
        this.owlAnnotationPropertyClass = this.createSystemCls("owl:AnnotationProperty", Collections.singleton(this.rdfPropertyClass), this.rdfsNamedClassClass);
        this.initInferredSlots();
        this.initRestrictionMetaclasses();
        this.owlLogicalClassClass = this.createSystemCls("owl:LogicalClass", this.anonymousClassMetaCls);
        this.owlComplementClassClass = this.createSystemCls("owl:ComplementClass", this.owlLogicalClassClass);
        this.owlIntersectionClassClass = this.createSystemCls("owl:IntersectionClass", this.owlLogicalClassClass);
        this.owlUnionClassClass = this.createSystemCls("owl:UnionClass", this.owlLogicalClassClass);
        this.owlDifferentFromProperty = this.createInstanceSlot("owl:differentFrom", this.rdfPropertyClass, this.getRootCls());
        this.owlDifferentFromProperty.setAllowsMultipleValues(true);
        this.owlDifferentFromProperty.addOwnSlotValue(this.rdfsRangeProperty, (Object)this.getRootCls());
        this.owlSameAsProperty = this.createInstanceSlot("owl:sameAs", this.rdfPropertyClass, this.getRootCls());
        this.owlSameAsProperty.setAllowsMultipleValues(true);
        this.owlSameAsProperty.addOwnSlotValue(this.rdfsRangeProperty, (Object)this.getRootCls());
        this.owlDisjointWithProperty = this.createInstanceSlot("owl:disjointWith", this.rdfPropertyClass, this.rdfsNamedClassClass);
        this.owlDisjointWithProperty.setAllowsMultipleValues(true);
        this.owlClassMetaCls.addDirectTemplateSlot(this.owlDisjointWithProperty);
        this.owlComplementOfProperty = this.createInstanceSlot("owl:complementOf", this.rdfPropertyClass, this.owlClassMetaCls);
        this.owlComplementClassClass.addDirectTemplateSlot(this.owlComplementOfProperty);
        this.owlIntersectionOfProperty = this.createInstanceSlot("owl:intersectionOf", this.rdfPropertyClass, this.rdfListClass);
        this.owlIntersectionClassClass.addDirectTemplateSlot(this.owlIntersectionOfProperty);
        this.owlUnionOfProperty = this.createInstanceSlot("owl:unionOf", this.rdfPropertyClass, this.rdfListClass);
        this.owlUnionClassClass.addDirectTemplateSlot(this.owlUnionOfProperty);
        this.owlEquivalentPropertyProperty = this.createInstanceSlot("owl:equivalentProperty", this.rdfPropertyClass, this.rdfPropertyClass);
        this.owlEquivalentPropertyProperty.setAllowsMultipleValues(true);
        this.rdfPropertyClass.addDirectTemplateSlot(this.owlEquivalentPropertyProperty);
        this.owlDatatypePropertyClass.setTemplateSlotAllowedClses(this.owlEquivalentPropertyProperty, Collections.singleton(this.owlDatatypePropertyClass));
        this.owlObjectPropertyClass.setTemplateSlotAllowedClses(this.owlEquivalentPropertyProperty, Collections.singleton(this.owlObjectPropertyClass));
        this.rdfsSubClassOfProperty = this.createInstanceSlot("rdfs:subClassOf", this.rdfPropertyClass, this.owlClassMetaCls);
        this.rdfsSubClassOfProperty.setAllowsMultipleValues(true);
        this.rdfsSubClassOfProperty.setAllowedClses(Collections.singleton(this.rdfsNamedClassClass));
        this.rdfsSubClassOfProperty.setOwnSlotValue(this.rdfsRangeProperty, (Object)this.rdfsNamedClassClass);
        this.rdfsNamedClassClass.addDirectTemplateSlot(this.rdfsSubClassOfProperty);
        this.rdfsSubPropertyOfProperty = this.getSlot(":DIRECT-SUPERSLOTS");
        this.rdfsSubPropertyOfProperty.setName("rdfs:subPropertyOf");
        this.rdfsSubPropertyOfProperty.setDirectType(this.rdfPropertyClass);
        this.rdfsSubPropertyOfProperty = (RDFProperty)this.getSlot("rdfs:subPropertyOf");
        this.owlEquivalentClassProperty = this.createInstanceSlot("owl:equivalentClass", this.rdfPropertyClass, this.owlClassMetaCls);
        this.owlEquivalentClassProperty.setAllowsMultipleValues(true);
        this.rdfsNamedClassClass.addDirectTemplateSlot(this.owlEquivalentClassProperty);
        this.rdfsLabelProperty = this.createAnnotationOWLDatatypeProperty("rdfs:label");
        this.setStringRange(this.rdfsLabelProperty);
        this.rdfsIsDefinedByProperty = this.createAnnotationOWLObjectProperty("rdfs:isDefinedBy");
        this.rdfsSeeAlsoProperty = this.createAnnotationOWLObjectProperty("rdfs:seeAlso");
        this.owlVersionInfoProperty = this.createAnnotationOWLDatatypeProperty("owl:versionInfo");
        this.setStringRange(this.owlVersionInfoProperty);
        this.rdfsCommentProperty = this.createAnnotationOWLDatatypeProperty("rdfs:comment");
        this.setStringRange(this.rdfsCommentProperty);
        this.rdfValueProperty = this.createSystemSlot("rdf:value", this.rdfPropertyClass);
        this.rdfValueProperty.setAllowsMultipleValues(true);
        this.rdfValueProperty.setValueType(ValueType.ANY);
        this.rdfsMemberProperty = this.createSystemSlot("rdfs:member", this.rdfPropertyClass);
        this.rdfsMemberProperty.setValueType(ValueType.INSTANCE);
        this.owlThingClass.addDirectTemplateSlot(this.rdfsMemberProperty);
        this.adjustSystemClasses();
        Cls cls2 = this.getCls(":DIRECTED-BINARY-RELATION");
        cls2.addDirectSuperclass(this.getRootCls());
        cls2.setDirectType(this.owlNamedClassClass);
        this.initOntologyMetaclass();
        this.rdfPropertyClass = this.getCls("rdf:Property");
        this.owlFunctionalPropertyClass = this.createSystemCls("owl:FunctionalProperty", Collections.singleton(this.rdfPropertyClass), this.rdfsNamedClassClass);
        this.owlInverseFunctionalPropertyClass = this.createSystemCls("owl:InverseFunctionalProperty", Collections.singleton(this.rdfPropertyClass), this.rdfsNamedClassClass);
        this.owlSymmetricPropertyClass = this.createSystemCls("owl:SymmetricProperty", Collections.singleton(this.rdfPropertyClass), this.rdfsNamedClassClass);
        this.owlTransitivePropertyClass = this.createSystemCls("owl:TransitiveProperty", Collections.singleton(this.rdfPropertyClass), this.rdfsNamedClassClass);
        this.rdfExternalResourceClass = this.createSystemCls("protege:ExternalResource", Collections.singleton(this.getRootCls()), this.rdfsNamedClassClass);
        this.owlResourceURIProperty = this.createSystemSlot(":OWL-RESOURCE-URI", this.rdfPropertyClass);
        this.owlResourceURIProperty.setValueType(ValueType.STRING);
        this.owlResourceURIProperty.setAllowsMultipleValues(false);
        this.rdfExternalResourceClass.addDirectTemplateSlot(this.owlResourceURIProperty);
        this.owlNothingClass = this.createSystemCls("owl:Nothing", this.getRootClses(), this.owlNamedClassClass);
        this.rdfListClass = this.createSystemCls("rdf:List", this.getRootClses(), this.owlNamedClassClass);
        this.rdfFirstProperty = this.createSystemSlot("rdf:first", this.rdfPropertyClass);
        this.rdfFirstProperty.setValueType(ValueType.ANY);
        this.rdfFirstProperty.setAllowsMultipleValues(false);
        this.rdfRestSlot = this.createSystemSlot("rdf:rest", this.rdfPropertyClass);
        this.rdfRestSlot.setAllowsMultipleValues(false);
        this.rdfRestSlot.setValueType(ValueType.INSTANCE);
        this.rdfRestSlot.setAllowedClses(Collections.singleton(this.rdfListClass));
        this.rdfListClass.addDirectTemplateSlot(this.rdfFirstProperty);
        this.rdfListClass.addDirectTemplateSlot(this.rdfRestSlot);
        this.rdfNilIndividual = this.createSystemInstance("rdf:nil", this.rdfListClass);
        this.owlAllDifferentClass = this.createSystemCls("owl:AllDifferent", Collections.singleton(this.owlThingClass), this.rdfsNamedClassClass);
        this.owlDistinctMembersProperty = this.createSystemSlot("owl:distinctMembers", this.rdfPropertyClass);
        this.owlDistinctMembersProperty.setValueType(ValueType.INSTANCE);
        this.owlDistinctMembersProperty.setAllowedClses(Collections.singleton(this.rdfListClass));
        this.owlAllDifferentClass.addDirectTemplateSlot(this.owlDistinctMembersProperty);
        this.rdfsLiteralClass = this.createSystemCls("rdfs:Literal", this.getRootClses(), this.owlNamedClassClass);
        this.rdfsContainerClass = this.createSystemCls("rdfs:Container", this.getRootClses(), this.rdfsNamedClassClass);
        this.rdfAltClass = this.createSystemCls("rdf:Alt", this.rdfsContainerClass);
        this.rdfBagClass = this.createSystemCls("rdf:Bag", this.rdfsContainerClass);
        this.rdfSeqClass = this.createSystemCls("rdf:Seq", this.rdfsContainerClass);
        this.rdfObjectProperty = this.createSystemSlot("rdf:object", this.rdfPropertyClass);
        this.rdfObjectProperty.setValueType(ValueType.INSTANCE);
        this.rdfPredicateProperty = this.createSystemSlot("rdf:predicate", this.rdfPropertyClass);
        this.rdfPredicateProperty.setValueType(ValueType.INSTANCE);
        this.rdfSubjectProperty = this.createSystemSlot("rdf:subject", this.rdfPropertyClass);
        this.rdfSubjectProperty.setValueType(ValueType.INSTANCE);
        this.rdfTypeProperty = this.createSystemSlot("rdf:type", this.rdfPropertyClass);
        this.rdfTypeProperty.setValueType(ValueType.CLS);
        this.owlThingClass.addDirectTemplateSlot(this.rdfTypeProperty);
        this.rdfStatementClass = this.createSystemCls("rdf:Statement", this.getRootClses(), this.rdfsNamedClassClass);
        this.rdfStatementClass.addDirectTemplateSlot(this.rdfObjectProperty);
        this.rdfStatementClass.addDirectTemplateSlot(this.rdfPredicateProperty);
        this.rdfStatementClass.addDirectTemplateSlot(this.rdfSubjectProperty);
        this.owlDeprecatedClassClass = this.createSystemCls("owl:DeprecatedClass", Collections.singleton(this.rdfsNamedClassClass), this.rdfsNamedClassClass);
        this.owlDeprecatedPropertyClass = this.createSystemCls("owl:DeprecatedProperty", Collections.singleton(this.rdfPropertyClass), this.rdfsNamedClassClass);
        this.owlDataRangeClass = this.createSystemCls("owl:DataRange", this.getRootClses(), this.rdfsNamedClassClass);
        this.owlOneOfProperty = this.createSystemSlot("owl:oneOf", this.rdfPropertyClass);
        this.owlOneOfProperty.setValueType(ValueType.INSTANCE);
        this.owlOneOfProperty.setAllowedClses(Collections.singleton(this.rdfListClass));
        this.owlDataRangeClass.addDirectTemplateSlot(this.owlOneOfProperty);
        this.owlEnumeratedClassClass.addDirectTemplateSlot(this.owlOneOfProperty);
        this.setAbstract(this.owlThingClass, false);
        this.owlThingClass.addOwnSlotValue(this.rdfTypeProperty, this.owlNamedClassClass);
        this.adjustProtegeSystemFrames();
        if (!(OWLNames.ClsID.THING.equals((Object)this.owlThingClass.getFrameID()) && RDFSNames.ClsID.NAMED_CLASS.equals((Object)this.rdfsNamedClassClass.getFrameID()) && RDFNames.ClsID.PROPERTY.equals((Object)this.rdfPropertyClass.getFrameID()))) {
            throw new RuntimeException("Fatal Metaclass Error: FrameIDs mismatch.  Perhaps a database rebuild required?");
        }
    }

    private Slot createSystemSlot(String string, Cls cls) {
        return this.createSlot(FrameID.createSystem((int)this.systemID++), string, Collections.singleton(cls), Collections.EMPTY_LIST, false);
    }

    private void adjustProtegeSystemFrames() {
        this.getCls(":DIRECTED-BINARY-RELATION").setDirectType(this.owlNamedClassClass);
        Slot slot = this.getSlot(":FROM");
        Slot slot2 = this.getSlot(":TO");
        slot2.setDirectType(this.owlObjectPropertyClass);
        slot.setDirectType(this.owlObjectPropertyClass);
        Cls cls = this.getCls(":PAL-CONSTRAINT");
        cls.setDirectType(this.rdfsNamedClassClass);
        this.getSlot(":PAL-DESCRIPTION").setDirectType(this.owlDatatypePropertyClass);
        this.getSlot(":PAL-NAME").setDirectType(this.owlDatatypePropertyClass);
        this.getSlot(":PAL-RANGE").setDirectType(this.owlDatatypePropertyClass);
        this.getSlot(":PAL-STATEMENT").setDirectType(this.owlDatatypePropertyClass);
        this.getSlot(":SLOT-CONSTRAINTS").setDirectType(this.owlObjectPropertyClass);
    }

    private void setStringRange(Slot slot) {
        Frame frame = this.getFrame("xsd:string");
        slot.setDirectOwnSlotValue(this.rdfsRangeProperty, (Object)frame);
        slot.setValueType(ValueType.STRING);
    }

    private void initRDFDatatypes() {
        TypeMapper typeMapper = TypeMapper.getInstance();
        Iterator iterator = typeMapper.listTypes();
        while (iterator.hasNext()) {
            RDFDatatype rDFDatatype = (RDFDatatype)iterator.next();
            String string = rDFDatatype.getURI();
            if (!string.startsWith("http://www.w3.org/2001/XMLSchema")) continue;
            String string2 = "xsd:" + string.substring("http://www.w3.org/2001/XMLSchema".length() + 1);
            this.createSystemInstance(string2, this.rdfsDatatypeClass);
        }
        this.createSystemInstance("rdf:XMLLiteral", this.rdfsDatatypeClass);
        this.fillDatatypeSet(XMLSchemaDatatypes.floatTypes, this.floatDatatypes);
        this.fillDatatypeSet(XMLSchemaDatatypes.integerTypes, this.integerDatatypes);
    }

    private void fillDatatypeSet(XSDDatatype[] xSDDatatypeArray, Set set) {
        for (int i = 0; i < xSDDatatypeArray.length; ++i) {
            XSDDatatype xSDDatatype = xSDDatatypeArray[i];
            String string = "xsd:" + xSDDatatype.getURI().substring("http://www.w3.org/2001/XMLSchema".length() + 1);
            set.add(this.getFrame(string));
        }
    }

    private Instance createSystemInstance(String string, Cls cls) {
        return this.createInstance(FrameID.createSystem((int)this.systemID++), string, cls, false);
    }

    public TaskManager getTaskManager() {
        if (this.taskManager == null) {
            this.taskManager = new DefaultTaskManager();
        }
        return this.taskManager;
    }

    private void initOntologyMetaclass() {
        this.owlOntologyClass = this.createSystemCls("owl:Ontology", Collections.singleton(this.owlThingClass), this.owlNamedClassClass);
        this.owlOntologyPrefixesProperty = this.createSystemSlot(":OWL-ONTOLOGY-PREFIXES", this.rdfPropertyClass);
        this.owlOntologyPrefixesProperty.setAllowsMultipleValues(true);
        this.owlOntologyPrefixesProperty.setValueType(ValueType.STRING);
        this.owlOntologyClass.addDirectTemplateSlot(this.owlOntologyPrefixesProperty);
        this.owlImportsProperty = this.createSystemSlot("owl:imports", this.rdfPropertyClass);
        this.owlImportsProperty.setAllowsMultipleValues(true);
        this.owlOntologyClass.addDirectTemplateSlot(this.owlImportsProperty);
        this.owlBackwardCompatibleWithProperty = this.createAnnotationOWLObjectProperty("owl:backwardCompatibleWith");
        this.owlBackwardCompatibleWithProperty.setAllowedClses((Collection)Collections.EMPTY_LIST);
        this.owlOntologyClass.addDirectTemplateSlot(this.owlBackwardCompatibleWithProperty);
        this.owlIncompatibleWithProperty = this.createAnnotationOWLObjectProperty("owl:incompatibleWith");
        this.owlIncompatibleWithProperty.setAllowedClses((Collection)Collections.EMPTY_LIST);
        this.owlOntologyClass.addDirectTemplateSlot(this.owlIncompatibleWithProperty);
        this.owlPriorVersionProperty = this.createAnnotationOWLObjectProperty("owl:priorVersion");
        this.owlPriorVersionProperty.setAllowedClses((Collection)Collections.EMPTY_LIST);
        this.owlOntologyClass.addDirectTemplateSlot(this.owlPriorVersionProperty);
    }

    private void initRestrictionMetaclasses() {
        this.owlOnPropertyProperty = this.createSystemSlot("owl:onProperty", this.rdfPropertyClass);
        this.owlOnPropertyProperty.setValueType(ValueType.INSTANCE);
        this.owlOnPropertyProperty.setAllowedClses(Collections.singleton(this.rdfPropertyClass));
        this.owlRestrictionClass = this.createSystemCls("owl:Restriction", this.anonymousClassMetaCls);
        this.owlRestrictionClass.addDirectTemplateSlot(this.owlOnPropertyProperty);
        Cls cls = this.rdfsNamedClassClass;
        this.owlAllValuesFromProperty = this.createSystemSlot("owl:allValuesFrom", this.rdfPropertyClass);
        this.owlAllValuesFromClass = this.createSystemCls("owl:AllValuesFromRestriction", Collections.singleton(this.owlRestrictionClass), cls);
        this.owlAllValuesFromClass.addDirectTemplateSlot(this.owlAllValuesFromProperty);
        this.owlHasValueProperty = this.createSystemSlot("owl:hasValue", this.rdfPropertyClass);
        this.owlHasValueProperty.setAllowsMultipleValues(false);
        this.owlHasValueClass = this.createSystemCls("owl:HasValueRestriction", Collections.singleton(this.owlRestrictionClass), cls);
        this.owlHasValueClass.addDirectTemplateSlot(this.owlHasValueProperty);
        RDFSDatatype rDFSDatatype = this.getXSDint();
        this.owlMaxCardinalityProperty = this.createSystemSlot("owl:maxCardinality", this.rdfPropertyClass);
        this.owlMaxCardinalityProperty.setAllowsMultipleValues(false);
        this.owlMaxCardinalityProperty.setValueType(ValueType.INTEGER);
        this.owlMaxCardinalityProperty.setDirectOwnSlotValue(this.rdfsRangeProperty, (Object)rDFSDatatype);
        this.owlMaxCardinalityClass = this.createSystemCls("owl:MaxCardinalityRestriction", Collections.singleton(this.owlRestrictionClass), cls);
        this.owlMaxCardinalityClass.addDirectTemplateSlot(this.owlMaxCardinalityProperty);
        this.owlMinCardinalityProperty = this.createSystemSlot("owl:minCardinality", this.rdfPropertyClass);
        this.owlMinCardinalityProperty.setAllowsMultipleValues(false);
        this.owlMinCardinalityProperty.setValueType(ValueType.INTEGER);
        this.owlMinCardinalityProperty.setDirectOwnSlotValue(this.rdfsRangeProperty, (Object)rDFSDatatype);
        this.owlMinCardinalityClass = this.createSystemCls("owl:MinCardinalityRestriction", Collections.singleton(this.owlRestrictionClass), cls);
        this.owlMinCardinalityClass.addDirectTemplateSlot(this.owlMinCardinalityProperty);
        this.owlCardinalityProperty = this.createSystemSlot("owl:cardinality", this.rdfPropertyClass);
        this.owlCardinalityProperty.setAllowsMultipleValues(false);
        this.owlCardinalityProperty.setValueType(ValueType.INTEGER);
        this.owlCardinalityProperty.setDirectOwnSlotValue(this.rdfsRangeProperty, (Object)rDFSDatatype);
        this.owlCardinalityClass = this.createSystemCls("owl:CardinalityRestriction", Collections.singleton(this.owlRestrictionClass), cls);
        this.owlCardinalityClass.addDirectTemplateSlot(this.owlCardinalityProperty);
        this.owlValuesFromProperty = this.createSystemSlot("owl:valuesFrom", this.rdfPropertyClass);
        this.owlValuesFromProperty.setAllowsMultipleValues(false);
        this.owlValuesFromProperty.setValueType(ValueType.INSTANCE);
        this.owlMaxCardinalityClass.addDirectTemplateSlot(this.owlValuesFromProperty);
        this.owlMinCardinalityClass.addDirectTemplateSlot(this.owlValuesFromProperty);
        this.owlCardinalityClass.addDirectTemplateSlot(this.owlValuesFromProperty);
        this.owlSomeValuesFromProperty = this.createSystemSlot("owl:someValuesFrom", this.rdfPropertyClass);
        this.owlSomeValuesFromClass = this.createSystemCls("owl:SomeValuesFromRestriction", Collections.singleton(this.owlRestrictionClass), cls);
        this.owlSomeValuesFromClass.addDirectTemplateSlot(this.owlSomeValuesFromProperty);
    }

    private void initInferredSlots() {
        this.protegeClassificationStatusProperty = this.createSystemSlot("protege:classificationStatus", this.rdfPropertyClass);
        this.protegeClassificationStatusProperty.setAllowsMultipleValues(false);
        this.protegeClassificationStatusProperty.setValueType(ValueType.BOOLEAN);
        this.rdfsNamedClassClass.addDirectTemplateSlot(this.protegeClassificationStatusProperty);
        Cls cls = this.getCls(":OWL-CLASS");
        this.protegeInferredSubclassesProperty = this.createInstanceSlot("protege:inferredSuperclassOf", this.rdfPropertyClass, cls);
        this.protegeInferredSubclassesProperty.setAllowsMultipleValues(true);
        this.protegeInferredSuperclassesProperty = this.createInstanceSlot("protege:inferredSubclassOf", this.rdfPropertyClass, cls);
        this.protegeInferredSuperclassesProperty.setAllowsMultipleValues(true);
        this.rdfsNamedClassClass.addDirectTemplateSlot(this.protegeInferredSubclassesProperty);
        this.rdfsNamedClassClass.addDirectTemplateSlot(this.protegeInferredSuperclassesProperty);
        this.protegeInferredTypeProperty = this.createInstanceSlot("protege:inferredType", this.rdfPropertyClass, cls);
        this.protegeInferredTypeProperty.setAllowsMultipleValues(true);
    }

    public void removeClassListener(ClassListener classListener) {
        this.removeClsListener(classListener);
    }

    public void removeModelListener(ModelListener modelListener) {
        this.removeKnowledgeBaseListener(modelListener);
    }

    public void removePropertyListener(PropertyListener propertyListener) {
        this.removeSlotListener(propertyListener);
    }

    public void removePropertyValueListener(PropertyValueListener propertyValueListener) {
        this.removeFrameListener(propertyValueListener);
    }

    public void removeResourceListener(ResourceListener resourceListener) {
        this.removeInstanceListener(resourceListener);
    }

    public void setOWLClassDisplay(OWLClassDisplay oWLClassDisplay) {
        assert (oWLClassDisplay != null);
        this.owlClassRenderer = oWLClassDisplay;
    }

    public OWLJavaFactory getOWLJavaFactory() {
        return (OWLJavaFactory)super.getFrameFactory();
    }

    public void setOWLJavaFactory(OWLJavaFactory oWLJavaFactory) {
        super.setFrameFactory((FrameFactory)oWLJavaFactory);
    }

    public void setOWLProject(OWLProject oWLProject) {
        this.owlProject = oWLProject;
    }

    public PropertyValueValidator getPropertyValueValidator() {
        return this.propertyValueValidator;
    }

    public boolean isValidPropertyValue(RDFResource rDFResource, RDFProperty rDFProperty, Object object) {
        if (this.getPropertyValueValidator() == null) {
            return true;
        }
        return this.getPropertyValueValidator().isValidPropertyValue(rDFResource, rDFProperty, object);
    }

    public void setPropertyValueValidator(PropertyValueValidator propertyValueValidator) {
        this.propertyValueValidator = propertyValueValidator;
    }

    public void copyFacetValuesIntoNamedClses() {
        if (this.owlFrameStore != null) {
            this.owlFrameStore.copyFacetValuesIntoNamedClses();
        }
    }

    public String createNewResourceName(String string) {
        String string2;
        String string3;
        if (this.getTripleStoreModel().getActiveTripleStore() != this.getTripleStoreModel().getTopTripleStore() && (string3 = this.getTripleStoreModel().getActiveTripleStore().getDefaultNamespace()) != null && (string2 = this.getNamespaceManager().getPrefix(string3)) != null && string2.length() > 0) {
            return this.getUniqueFrameName(string2 + ":" + string);
        }
        return this.getUniqueFrameName(string);
    }

    public OWLAllDifferent createOWLAllDifferent() {
        return (OWLAllDifferent)this.createInstance(null, this.owlAllDifferentClass);
    }

    public OWLAllValuesFrom createOWLAllValuesFrom() {
        Collection collection = CollectionUtilities.createCollection((Object)this.anonymousRootCls);
        return (OWLAllValuesFrom)this.createCls(null, collection, this.owlAllValuesFromClass, false);
    }

    public OWLAllValuesFrom createOWLAllValuesFrom(RDFProperty rDFProperty, RDFResource rDFResource) {
        OWLAllValuesFrom oWLAllValuesFrom = this.createOWLAllValuesFrom();
        oWLAllValuesFrom.setOnProperty(rDFProperty);
        oWLAllValuesFrom.setFiller(rDFResource);
        return oWLAllValuesFrom;
    }

    public OWLAllValuesFrom createOWLAllValuesFrom(RDFProperty rDFProperty, RDFSLiteral[] rDFSLiteralArray) {
        OWLAllValuesFrom oWLAllValuesFrom = this.createOWLAllValuesFrom();
        oWLAllValuesFrom.setOnProperty(rDFProperty);
        OWLDataRange oWLDataRange = this.createOWLDataRange(rDFSLiteralArray);
        oWLAllValuesFrom.setFiller(oWLDataRange);
        return oWLAllValuesFrom;
    }

    public OWLDatatypeProperty createAnnotationOWLDatatypeProperty(String string) {
        OWLDatatypeProperty oWLDatatypeProperty = this.createOWLDatatypeProperty(string);
        oWLDatatypeProperty.setAllowsMultipleValues(true);
        oWLDatatypeProperty.addDirectType(this.owlAnnotationPropertyClass);
        return oWLDatatypeProperty;
    }

    public OWLObjectProperty createAnnotationOWLObjectProperty(String string) {
        OWLObjectProperty oWLObjectProperty = this.createOWLObjectProperty(string);
        oWLObjectProperty.setAllowsMultipleValues(true);
        oWLObjectProperty.addDirectType(this.owlAnnotationPropertyClass);
        return oWLObjectProperty;
    }

    public OWLCardinality createOWLCardinality() {
        Collection collection = CollectionUtilities.createCollection((Object)this.anonymousRootCls);
        return (OWLCardinality)this.createCls(null, collection, this.owlCardinalityClass, false);
    }

    public OWLCardinality createOWLCardinality(RDFProperty rDFProperty, int n) {
        OWLCardinality oWLCardinality = this.createOWLCardinality();
        oWLCardinality.setOnProperty(rDFProperty);
        oWLCardinality.setCardinality(n);
        return oWLCardinality;
    }

    public OWLCardinality createOWLCardinality(RDFProperty rDFProperty, int n, RDFSClass rDFSClass) {
        OWLCardinality oWLCardinality = this.createOWLCardinality(rDFProperty, n);
        oWLCardinality.setValuesFrom(rDFSClass);
        return oWLCardinality;
    }

    public synchronized Cls createCls(FrameID frameID, String string, Collection collection, Collection collection2, boolean bl) {
        if (this.bootstrapped && string == null) {
            string = this.isDefaultAnonymousType(collection2) ? this.getNextAnonymousResourceName() : this.createUniqueNewFrameName(DEFAULT_CLASS_NAME);
        }
        return super.createCls(frameID, string, collection, collection2, bl);
    }

    public OWLComplementClass createOWLComplementClass() {
        Collection collection = CollectionUtilities.createCollection((Object)this.anonymousRootCls);
        return (OWLComplementClass)this.createCls(null, collection, this.owlComplementClassClass, false);
    }

    public OWLComplementClass createOWLComplementClass(RDFSClass rDFSClass) {
        OWLComplementClass oWLComplementClass = this.createOWLComplementClass();
        oWLComplementClass.setComplement(rDFSClass);
        return oWLComplementClass;
    }

    public OWLDataRange createOWLDataRange() {
        return (OWLDataRange)this.getOWLDataRangeClass().createAnonymousInstance();
    }

    public OWLDataRange createOWLDataRange(RDFSLiteral[] rDFSLiteralArray) {
        OWLDataRange oWLDataRange = this.createOWLDataRange();
        RDFList rDFList = this.createRDFList(Arrays.asList(rDFSLiteralArray).iterator());
        oWLDataRange.setPropertyValue(this.getOWLOneOfProperty(), rDFList);
        return oWLDataRange;
    }

    public OWLDatatypeProperty createOWLDatatypeProperty(String string) {
        return this.createOWLDatatypeProperty(string, (OWLNamedClass)this.owlDatatypePropertyClass);
    }

    public OWLDatatypeProperty createOWLDatatypeProperty(String string, OWLNamedClass oWLNamedClass) {
        if (string == null) {
            string = this.createUniqueNewFrameName("DatatypeProperty");
        }
        OWLDatatypeProperty oWLDatatypeProperty = null;
        if (this.inInit) {
            oWLDatatypeProperty = (OWLDatatypeProperty)this.createSystemSlot(string, oWLNamedClass);
            this.owlThingClass.addDirectTemplateSlot(oWLDatatypeProperty);
        } else {
            oWLDatatypeProperty = (OWLDatatypeProperty)this.createSlot(string, oWLNamedClass, this.loadDefaults);
        }
        oWLDatatypeProperty.setAllowsMultipleValues(true);
        oWLDatatypeProperty.setValueType(ValueType.ANY);
        return oWLDatatypeProperty;
    }

    public OWLDatatypeProperty createOWLDatatypeProperty(String string, RDFSDatatype rDFSDatatype) {
        OWLDatatypeProperty oWLDatatypeProperty = this.createOWLDatatypeProperty(string);
        oWLDatatypeProperty.setAllowsMultipleValues(true);
        oWLDatatypeProperty.setRange(rDFSDatatype);
        return oWLDatatypeProperty;
    }

    public OWLDatatypeProperty createOWLDatatypeProperty(String string, RDFSLiteral[] rDFSLiteralArray) {
        OWLDatatypeProperty oWLDatatypeProperty = this.createOWLDatatypeProperty(string);
        OWLDataRange oWLDataRange = this.createOWLDataRange(rDFSLiteralArray);
        oWLDatatypeProperty.setRange(oWLDataRange);
        return oWLDatatypeProperty;
    }

    private void createDefaultOWLOntology() {
        if (this.getDefaultOWLOntology() == null) {
            this.createDefaultOWLOntologyReally();
        }
    }

    protected void createDefaultOWLOntologyReally() {
        Instance instance = this.createInstance(":", this.owlOntologyClass);
        instance.setDirectOwnSlotValue(this.rdfTypeProperty, (Object)this.owlOntologyClass);
        this.getNamespaceManager().setDefaultNamespace("http://www.owl-ontologies.com/unnamed.owl#");
        this.getNamespaceManager().setPrefix(RDF.getURI(), "rdf");
        this.getNamespaceManager().setPrefix(RDFS.getURI(), "rdfs");
        this.getNamespaceManager().setPrefix("http://www.w3.org/2002/07/owl#", "owl");
        this.getNamespaceManager().setPrefix("http://www.w3.org/2001/XMLSchema#", "xsd");
    }

    protected FrameStoreManager createFrameStoreManager() {
        return new OWLFrameStoreManager(this);
    }

    public OWLEnumeratedClass createOWLEnumeratedClass() {
        Collection collection = CollectionUtilities.createCollection((Object)this.anonymousRootCls);
        return (OWLEnumeratedClass)this.createCls(null, collection, this.owlEnumeratedClassClass, false);
    }

    public OWLEnumeratedClass createOWLEnumeratedClass(Collection collection) {
        OWLEnumeratedClass oWLEnumeratedClass = this.createOWLEnumeratedClass();
        oWLEnumeratedClass.setOneOf(collection);
        return oWLEnumeratedClass;
    }

    public RDFExternalResource createRDFExternalResource(String string) {
        throw new RuntimeException("The class RDFExternalResource has been replaced with RDFUntypedResource");
    }

    public OWLHasValue createOWLHasValue() {
        Collection collection = CollectionUtilities.createCollection((Object)this.anonymousRootCls);
        return (OWLHasValue)this.createCls(null, collection, this.owlHasValueClass, false);
    }

    public OWLHasValue createOWLHasValue(RDFProperty rDFProperty, Object object) {
        OWLHasValue oWLHasValue = this.createOWLHasValue();
        oWLHasValue.setOnProperty(rDFProperty);
        oWLHasValue.setHasValue(object);
        return oWLHasValue;
    }

    public synchronized Instance createInstance(FrameID frameID, String string, Collection collection, boolean bl) {
        if (string == null) {
            if (this.isDefaultAnonymousType(collection)) {
                string = this.getNextAnonymousResourceName();
            } else {
                Cls cls = (Cls)collection.iterator().next();
                if (cls instanceof RDFSNamedClass) {
                    string = this.createNewResourceName(((RDFSClass)cls).getLocalName());
                }
            }
        }
        return super.createInstance(frameID, string, collection, bl);
    }

    private Slot createInstanceSlot(String string, Cls cls, Cls cls2) {
        Slot slot = this.createSystemSlot(string, cls);
        slot.setValueType(ValueType.INSTANCE);
        slot.setAllowedClses(CollectionUtilities.createCollection((Object)cls2));
        return slot;
    }

    public OWLIntersectionClass createOWLIntersectionClass() {
        Collection collection = CollectionUtilities.createCollection((Object)this.anonymousRootCls);
        return (OWLIntersectionClass)this.createCls(null, collection, this.owlIntersectionClassClass, false);
    }

    public OWLIntersectionClass createOWLIntersectionClass(Collection collection) {
        OWLIntersectionClass oWLIntersectionClass = this.createOWLIntersectionClass();
        for (RDFSClass rDFSClass : collection) {
            oWLIntersectionClass.addOperand(rDFSClass);
        }
        return oWLIntersectionClass;
    }

    public RDFList createRDFList() {
        return (RDFList)this.rdfListClass.createDirectInstance(null);
    }

    public RDFList createRDFList(Iterator iterator) {
        return this.createListInstance(iterator, this.rdfListClass);
    }

    public RDFSClass createRDFSClassFromExpression(String string) {
        try {
            OWLClassParser oWLClassParser = this.getOWLClassDisplay().getParser();
            return oWLClassParser.parseClass(this, string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public RDFSDatatype createRDFSDatatype(String string) {
        return (RDFSDatatype)this.rdfsDatatypeClass.createDirectInstance(string);
    }

    private RDFList createListInstance(Iterator iterator, Cls cls) {
        RDFList rDFList;
        if (!iterator.hasNext()) {
            return this.getRDFNil();
        }
        RDFList rDFList2 = rDFList = (RDFList)cls.createDirectInstance(null);
        while (iterator.hasNext()) {
            Object e = iterator.next();
            rDFList2.setFirst(e);
            if (!iterator.hasNext()) continue;
            RDFList rDFList3 = (RDFList)cls.createDirectInstance(null);
            rDFList2.setRest(rDFList3);
            rDFList2 = rDFList3;
        }
        rDFList2.setRest((RDFList)this.rdfNilIndividual);
        return rDFList;
    }

    public OWLMaxCardinality createOWLMaxCardinality() {
        Set<Cls> set = Collections.singleton(this.getAnonymousRootCls());
        return (OWLMaxCardinality)this.createCls(null, set, this.owlMaxCardinalityClass, false);
    }

    public OWLMaxCardinality createOWLMaxCardinality(RDFProperty rDFProperty, int n) {
        OWLMaxCardinality oWLMaxCardinality = this.createOWLMaxCardinality();
        oWLMaxCardinality.setOnProperty(rDFProperty);
        oWLMaxCardinality.setCardinality(n);
        return oWLMaxCardinality;
    }

    public OWLMaxCardinality createOWLMaxCardinality(RDFProperty rDFProperty, int n, RDFSClass rDFSClass) {
        OWLMaxCardinality oWLMaxCardinality = this.createOWLMaxCardinality(rDFProperty, n);
        oWLMaxCardinality.setValuesFrom(rDFSClass);
        return oWLMaxCardinality;
    }

    public OWLMinCardinality createOWLMinCardinality() {
        Set<Cls> set = Collections.singleton(this.anonymousRootCls);
        return (OWLMinCardinality)this.createCls(null, set, this.owlMinCardinalityClass, false);
    }

    public OWLMinCardinality createOWLMinCardinality(RDFProperty rDFProperty, int n) {
        OWLMinCardinality oWLMinCardinality = this.createOWLMinCardinality();
        oWLMinCardinality.setOnProperty(rDFProperty);
        oWLMinCardinality.setCardinality(n);
        return oWLMinCardinality;
    }

    public OWLMinCardinality createOWLMinCardinality(RDFProperty rDFProperty, int n, RDFSClass rDFSClass) {
        OWLMinCardinality oWLMinCardinality = this.createOWLMinCardinality(rDFProperty, n);
        oWLMinCardinality.setValuesFrom(rDFSClass);
        return oWLMinCardinality;
    }

    public OWLNamedClass createOWLNamedClass(String string) {
        return this.createOWLNamedClass(string, this.loadDefaults);
    }

    public OWLNamedClass createOWLNamedClass(String string, boolean bl) {
        return (OWLNamedClass)this.createCls(string, this.getRootClses(), this.owlNamedClassClass, bl);
    }

    public OWLNamedClass createOWLNamedClass(String string, OWLNamedClass oWLNamedClass) {
        return (OWLNamedClass)this.createCls(string, this.getRootClses(), oWLNamedClass, this.loadDefaults);
    }

    public OWLNamedClass createOWLNamedSubclass(String string, OWLNamedClass oWLNamedClass) {
        OWLNamedClass oWLNamedClass2 = this.createOWLNamedClass(string);
        if (!oWLNamedClass.equals(this.getOWLThingClass())) {
            oWLNamedClass2.addSuperclass(oWLNamedClass);
            oWLNamedClass2.removeSuperclass(this.getOWLThingClass());
        }
        return oWLNamedClass2;
    }

    public OWLObjectProperty createOWLObjectProperty(String string) {
        return this.createOWLObjectProperty(string, (OWLNamedClass)this.owlObjectPropertyClass);
    }

    public OWLObjectProperty createOWLObjectProperty(String string, OWLNamedClass oWLNamedClass) {
        if (string == null) {
            string = this.createUniqueNewFrameName("ObjectProperty");
        }
        OWLObjectProperty oWLObjectProperty = null;
        oWLObjectProperty = this.inInit ? (OWLObjectProperty)this.createSystemSlot(string, oWLNamedClass) : (OWLObjectProperty)this.createSlot(string, oWLNamedClass, this.loadDefaults);
        oWLObjectProperty.setAllowsMultipleValues(true);
        oWLObjectProperty.setValueType(ValueType.INSTANCE);
        return oWLObjectProperty;
    }

    public OWLObjectProperty createOWLObjectProperty(String string, Collection collection) {
        OWLObjectProperty oWLObjectProperty = this.createOWLObjectProperty(string);
        oWLObjectProperty.setUnionRangeClasses(collection);
        return oWLObjectProperty;
    }

    public OWLOntology createOWLOntology(String string) {
        return (OWLOntology)this.createInstance(string + ":", this.owlOntologyClass);
    }

    public OWLOntology createOWLOntology(String string, String string2) {
        String string3 = this.getNamespaceManager().getPrefix(string2);
        return this.createOWLOntology(string3);
    }

    public RDFSNamedClass createRDFSNamedClass(String string) {
        return this.createRDFSNamedClass(string, true);
    }

    public RDFSNamedClass createRDFSNamedClass(String string, boolean bl) {
        return (RDFSNamedClass)this.createCls(string, this.getRootClses(), this.rdfsNamedClassClass, bl);
    }

    public RDFSNamedClass createRDFSNamedClass(String string, Collection collection, RDFSClass rDFSClass) {
        return (RDFSNamedClass)this.createCls(string, collection, rDFSClass);
    }

    public RDFSNamedClass createRDFSNamedSubclass(String string, RDFSNamedClass rDFSNamedClass) {
        RDFSNamedClass rDFSNamedClass2 = this.createRDFSNamedClass(string);
        if (!rDFSNamedClass.equals(this.getOWLThingClass())) {
            rDFSNamedClass2.addSuperclass(rDFSNamedClass);
            rDFSNamedClass2.removeSuperclass(this.getOWLThingClass());
        }
        return rDFSNamedClass2;
    }

    public RDFUntypedResource createRDFUntypedResource(String string) {
        Instance instance = this.rdfExternalResourceClass.createDirectInstance(string);
        return (RDFUntypedResource)instance;
    }

    public RDFProperty createRDFProperty(String string) {
        if (string == null) {
            string = this.createUniqueNewFrameName("RDFProperty");
        }
        RDFProperty rDFProperty = (RDFProperty)this.createSlot(string, this.rdfPropertyClass, this.loadDefaults);
        rDFProperty.setValueType(ValueType.ANY);
        rDFProperty.setAllowsMultipleValues(true);
        return rDFProperty;
    }

    public Triple createTriple(RDFResource rDFResource, RDFProperty rDFProperty, Object object) {
        return new DefaultTriple(rDFResource, rDFProperty, object);
    }

    public Set getAllImports() {
        HashSet<String> hashSet = new HashSet<String>();
        for (Object e : this.getOWLOntologies()) {
            OWLOntology oWLOntology = (OWLOntology)e;
            for (Object e2 : oWLOntology.getImports()) {
                if (e2 instanceof RDFResource) {
                    hashSet.add(((RDFResource)e2).getURI());
                    continue;
                }
                if (!(e2 instanceof String)) continue;
                hashSet.add((String)e2);
            }
        }
        return hashSet;
    }

    public RDFSNamedClass createSubclass(String string, RDFSNamedClass rDFSNamedClass) {
        return (RDFSNamedClass)this.createCls(string, Collections.singleton(rDFSNamedClass));
    }

    public RDFSNamedClass createSubclass(String string, Collection collection) {
        return (RDFSNamedClass)this.createCls(string, collection);
    }

    public OWLSomeValuesFrom createOWLSomeValuesFrom() {
        Collection collection = CollectionUtilities.createCollection((Object)this.anonymousRootCls);
        return (OWLSomeValuesFrom)this.createCls(null, collection, this.owlSomeValuesFromClass, false);
    }

    public OWLSomeValuesFrom createOWLSomeValuesFrom(RDFProperty rDFProperty, RDFResource rDFResource) {
        OWLSomeValuesFrom oWLSomeValuesFrom = this.createOWLSomeValuesFrom();
        oWLSomeValuesFrom.setOnProperty(rDFProperty);
        oWLSomeValuesFrom.setFiller(rDFResource);
        return oWLSomeValuesFrom;
    }

    public OWLSomeValuesFrom createOWLSomeValuesFrom(RDFProperty rDFProperty, RDFSLiteral[] rDFSLiteralArray) {
        OWLSomeValuesFrom oWLSomeValuesFrom = this.createOWLSomeValuesFrom();
        oWLSomeValuesFrom.setOnProperty(rDFProperty);
        OWLDataRange oWLDataRange = this.createOWLDataRange(rDFSLiteralArray);
        oWLSomeValuesFrom.setFiller(oWLDataRange);
        return oWLSomeValuesFrom;
    }

    public RDFProperty createSubproperty(String string, RDFProperty rDFProperty) {
        return (RDFProperty)this.createSlot(string, rDFProperty.getProtegeType(), Collections.singleton(rDFProperty), true);
    }

    public boolean endTransaction() {
        return this.commitTransaction();
    }

    public QueryResults executeSPARQLQuery(String string) throws Exception {
        String string2 = SPARQLQueryResults.createPrefixDeclarations(this) + string;
        return SPARQLQueryResults.create(this, string2);
    }

    public OWLUnionClass createOWLUnionClass() {
        Collection collection = CollectionUtilities.createCollection((Object)this.anonymousRootCls);
        return (OWLUnionClass)this.createCls(null, collection, this.owlUnionClassClass, false);
    }

    public OWLUnionClass createOWLUnionClass(Collection collection) {
        OWLUnionClass oWLUnionClass = this.createOWLUnionClass();
        for (RDFSClass rDFSClass : collection) {
            oWLUnionClass.addOperand(rDFSClass);
        }
        return oWLUnionClass;
    }

    public RDFSLiteral createRDFSLiteral(Object object) {
        return DefaultRDFSLiteral.create(this, object);
    }

    public RDFSLiteral createRDFSLiteral(String string, RDFSDatatype rDFSDatatype) {
        return DefaultRDFSLiteral.create((OWLModel)this, string, rDFSDatatype);
    }

    public RDFSLiteral createRDFSLiteral(String string, String string2) {
        return DefaultRDFSLiteral.create((OWLModel)this, string, string2);
    }

    public Object createRDFSLiteralOrString(String string, String string2) {
        if (string2 != null && (string2 = string2.trim()).length() > 0) {
            return this.createRDFSLiteral(string, string2);
        }
        return string;
    }

    public static void deleteAllFrames(OWLModel oWLModel) {
        Object object2;
        OWLModel oWLModel2 = oWLModel;
        for (Object object2 : oWLModel2.getInstances()) {
            if (object2 instanceof Cls || !object2.isEditable() && !object2.isIncluded() || object2.isSystem()) continue;
            oWLModel2.deleteFrame((Frame)object2);
        }
        ArrayList arrayList = new ArrayList();
        for (Cls cls : oWLModel.getUserDefinedOWLNamedClasses()) {
            if (!cls.isEditable() && !cls.isIncluded() || cls.isSystem() || !cls.isMetaCls()) continue;
            arrayList.add(cls);
        }
        object2 = arrayList.iterator();
        while (object2.hasNext()) {
            Cls cls;
            cls = (Cls)object2.next();
            for (Frame frame : cls.getInstances()) {
                oWLModel2.deleteFrame(frame);
            }
        }
        for (Cls cls : oWLModel.getUserDefinedOWLNamedClasses()) {
            if (cls.getDirectType() == null || !cls.isEditable() && !cls.isIncluded() || cls.isSystem()) continue;
            oWLModel2.deleteFrame((Frame)cls);
        }
    }

    public void deleteCls(Cls cls) {
        if (cls instanceof OWLAnonymousClass && cls.getDirectSubclassCount() == 1) {
            Cls cls2 = (Cls)cls.getDirectSubclasses().iterator().next();
            cls2.removeDirectSuperclass(cls);
            return;
        }
        super.deleteCls(cls);
    }

    public boolean ensureProtegeMetaOntologyImported() {
        OWLOntology oWLOntology = this.getDefaultOWLOntology();
        for (String string : oWLOntology.getImports()) {
            if (!string.equals(ProtegeNames.FILE)) continue;
            return false;
        }
        oWLOntology.addImports(ProtegeNames.FILE);
        this.ensureProtegePrefixExists();
        return true;
    }

    private void ensureProtegePrefixExists() {
        if (this.getNamespaceManager().getPrefix(ProtegeNames.NS) == null) {
            String string = "protege";
            this.getNamespaceManager().setPrefix(ProtegeNames.NS, string);
            this.getNamespaceManager().setPrefix("http://www.owl-ontologies.com/2005/08/07/xsp.owl#", "xsp");
        }
    }

    public Collection getOWLAllDifferents() {
        RDFSNamedClass rDFSNamedClass = this.getOWLAllDifferentClass();
        return rDFSNamedClass.getDirectInstances();
    }

    public RDFSNamedClass getOWLAllDifferentClass() {
        return (RDFSNamedClass)this.owlAllDifferentClass;
    }

    public Collection getOWLAnnotationProperties() {
        ArrayList<Slot> arrayList = new ArrayList<Slot>();
        for (Slot slot : this.getSlots()) {
            if (!(slot instanceof RDFProperty) || !((RDFProperty)slot).isAnnotationProperty()) continue;
            arrayList.add(slot);
        }
        return arrayList;
    }

    public Cls getAnonymousRootCls() {
        return this.anonymousRootCls;
    }

    public synchronized String getBrowserText(Instance instance) {
        if (instance instanceof RDFResource) {
            if (instance instanceof OWLAnonymousClass) {
                return instance.getBrowserText();
            }
            if (instance.isDeleted()) {
                return "<deleted>";
            }
            Cls cls = instance.getDirectType();
            if (this.getProject() == null) {
                return this.getName((Frame)instance);
            }
            if (cls == null) {
                return this.getMissingTypeString(instance);
            }
            BrowserSlotPattern browserSlotPattern = this.getProject().getBrowserSlotPattern(instance.getDirectType());
            if (browserSlotPattern == null) {
                return this.getDisplaySlotNotSetString(instance);
            }
            String string = null;
            List list = browserSlotPattern.getElements();
            Slot slot = browserSlotPattern.getFirstSlot();
            if (list.size() == 1 && slot != null && !slot.equals(this.nameSlot) && slot.getValueType() == ValueType.STRING) {
                RDFSLiteral rDFSLiteral;
                String string2 = this.getDefaultLanguage();
                Collection collection = null;
                collection = slot instanceof RDFProperty ? ((RDFResource)instance).getPropertyValues((RDFProperty)slot) : instance.getOwnSlotValues(slot);
                if (string2 != null) {
                    for (Object e : collection) {
                        if (!(e instanceof RDFSLiteral) || !string2.equals((rDFSLiteral = (RDFSLiteral)e).getLanguage())) continue;
                        string = rDFSLiteral.getString();
                        break;
                    }
                }
                if (string == null) {
                    for (Object e : collection) {
                        if (e instanceof RDFSLiteral) {
                            rDFSLiteral = (RDFSLiteral)e;
                            if (rDFSLiteral.getLanguage() != null) continue;
                            string = rDFSLiteral.getString();
                        } else {
                            string = e.toString();
                        }
                        break;
                    }
                }
            } else {
                string = browserSlotPattern.getBrowserText(instance);
            }
            if (string == null) {
                string = this.getDisplaySlotPatternValueNotSetString(instance, browserSlotPattern);
            }
            return string;
        }
        return super.getBrowserText(instance);
    }

    public Collection getChangedInferredClasses() {
        return this.getClsesWithClassificationStatus(3);
    }

    public RDFSNamedClass getCommonSuperclass(Collection collection) {
        ArrayList arrayList;
        HashSet<RDFSClass> hashSet = new HashSet<RDFSClass>();
        Iterator iterator = collection.iterator();
        RDFSNamedClass rDFSNamedClass = (RDFSNamedClass)iterator.next();
        Collection collection2 = rDFSNamedClass.getSuperclasses(true);
        for (Object object : collection2) {
            if (!(object instanceof RDFSNamedClass)) continue;
            hashSet.add((RDFSClass)object);
        }
        while (iterator.hasNext()) {
            Object object;
            arrayList = (RDFSNamedClass)iterator.next();
            object = new HashSet(arrayList.getSuperclasses(true));
            Object object2 = hashSet.iterator();
            while (object2.hasNext()) {
                RDFSNamedClass rDFSNamedClass2 = (RDFSNamedClass)object2.next();
                if (object.contains(rDFSNamedClass2)) continue;
                object2.remove();
            }
        }
        arrayList = new ArrayList(hashSet);
        for (Object object2 : arrayList) {
            hashSet.removeAll(object2.getSuperclasses(true));
        }
        return (RDFSNamedClass)hashSet.iterator().next();
    }

    public RDFProperty getProtegeClassificationStatusProperty() {
        return (RDFProperty)this.protegeClassificationStatusProperty;
    }

    private Collection getClsesWithClassificationStatus(int n) {
        RDFProperty rDFProperty = this.getProtegeClassificationStatusProperty();
        Collection collection = this.getFramesWithValue(rDFProperty, null, false, new Integer(n));
        ArrayList<Frame> arrayList = new ArrayList<Frame>();
        for (Frame frame : collection) {
            if (!(frame instanceof OWLNamedClass)) continue;
            arrayList.add(frame);
        }
        return arrayList;
    }

    public OWLDatatypeProperty getOWLDatatypeProperty(String string) {
        return (OWLDatatypeProperty)this.getSlot(string);
    }

    public OWLNamedClass getOWLDatatypePropertyClass() {
        return (OWLNamedClass)this.owlDatatypePropertyClass;
    }

    public RDFSNamedClass getOWLDeprecatedClassClass() {
        return (RDFSNamedClass)this.owlDeprecatedClassClass;
    }

    public String getDefaultLanguage() {
        String string;
        OWLOntology oWLOntology;
        RDFProperty rDFProperty;
        if (this.isProtegeMetaOntologyImported() && (rDFProperty = this.getRDFProperty(ProtegeNames.getDefaultLanguageSlotName())) != null && (oWLOntology = this.getDefaultOWLOntology()) != null && (string = (String)oWLOntology.getPropertyValue(rDFProperty)) != null && string.length() > 0) {
            return string;
        }
        return null;
    }

    public OWLOntology getDefaultOWLOntology() {
        return (OWLOntology)this.getFrame(":");
    }

    public Collection getDomainlessProperties() {
        return this.getRootCls().getDirectTemplateSlots();
    }

    public Set getFloatDatatypes() {
        return this.floatDatatypes;
    }

    public Set getIntegerDatatypes() {
        return this.integerDatatypes;
    }

    public RDFProperty getOWLDifferentFromProperty() {
        return (RDFProperty)this.owlDifferentFromProperty;
    }

    public RDFProperty getOWLDisjointWithProperty() {
        return (RDFProperty)this.owlDisjointWithProperty;
    }

    public RDFProperty getOWLEquivalentPropertyProperty() {
        return (RDFProperty)this.owlEquivalentPropertyProperty;
    }

    public RDFProperty getOWLOneOfProperty() {
        return (RDFProperty)this.owlOneOfProperty;
    }

    public OWLProject getOWLProject() {
        return this.owlProject;
    }

    public RepositoryManager getRepositoryManager() {
        if (this.repositoryManager == null) {
            this.repositoryManager = new RepositoryManager(this);
            RepositoryFileManager repositoryFileManager = new RepositoryFileManager(this);
            repositoryFileManager.loadGlobalRepositories();
        }
        return this.repositoryManager;
    }

    public RDFExternalResource getRDFExternalResource(String string) {
        for (RDFExternalResource rDFExternalResource : this.getRDFUntypedResourcesClass().getInstances(false)) {
            if (!string.equals(rDFExternalResource.getResourceURI())) continue;
            return rDFExternalResource;
        }
        return null;
    }

    public RDFSClass getRDFExternalResourceClass() {
        return (RDFSNamedClass)this.rdfExternalResourceClass;
    }

    public RDFProperty getRDFFirstProperty() {
        return (RDFProperty)this.rdfFirstProperty;
    }

    public Collection getInconsistentClasses() {
        return this.getOWLNothing().getInferredSubclasses();
    }

    public Model getJenaModel() {
        if (this.jenaModel == null) {
            this.jenaModel = JenaModelFactory.createModel(this);
        }
        return this.jenaModel;
    }

    public RDFSNamedClass getOWLAnnotationPropertyClass() {
        return (RDFSNamedClass)this.owlAnnotationPropertyClass;
    }

    public OWLClassParser getOWLClassParser() {
        return this.getOWLClassDisplay().getParser();
    }

    public OWLClassDisplay getOWLClassDisplay() {
        return this.owlClassRenderer;
    }

    public RDFProperty getProtegeInferredSubclassesProperty() {
        return (RDFProperty)this.protegeInferredSubclassesProperty;
    }

    public RDFProperty getProtegeInferredSuperclassesProperty() {
        return (RDFProperty)this.protegeInferredSuperclassesProperty;
    }

    public RDFProperty getRDFSDomainProperty() {
        return (RDFProperty)this.rdfsDomainProperty;
    }

    public RDFProperty getRDFSIsDefinedByProperty() {
        return (RDFProperty)this.rdfsIsDefinedByProperty;
    }

    public RDFProperty getRDFSLabelProperty() {
        return (RDFProperty)this.rdfsLabelProperty;
    }

    public int getRDFResourceCount() {
        return this.getFrameCount() - 54;
    }

    public Collection getRDFResources() {
        Collection collection = this.getFrames();
        return AbstractOWLModel.getRDFResources(this, collection);
    }

    public Collection getRDFResourcesWithPropertyValue(RDFProperty rDFProperty, Object object) {
        Collection collection = this.getFramesWithValue(rDFProperty, null, false, object);
        return AbstractOWLModel.getRDFResources(this, collection);
    }

    public static Collection getRDFResources(KnowledgeBase knowledgeBase, Collection collection) {
        ArrayList<Frame> arrayList = new ArrayList<Frame>();
        for (Frame frame : collection) {
            if (!(frame instanceof RDFResource)) continue;
            arrayList.add(frame);
        }
        AbstractOWLModel.removeProtegeSystemResources(knowledgeBase, arrayList);
        return arrayList;
    }

    public RDFSNamedClass getRDFListClass() {
        return (RDFSNamedClass)this.rdfListClass;
    }

    public RDFUntypedResource getRDFUntypedResource(String string, boolean bl) {
        RDFUntypedResource rDFUntypedResource = (RDFUntypedResource)this.getFrame(string);
        if (bl && rDFUntypedResource == null) {
            rDFUntypedResource = this.createRDFUntypedResource(string);
        }
        return rDFUntypedResource;
    }

    public RDFSNamedClass getRDFUntypedResourcesClass() {
        return (RDFSNamedClass)this.rdfExternalResourceClass;
    }

    public Collection getResourceNameMatches(String string, int n) {
        Collection collection = this.getFrameNameMatches(string, n);
        return AbstractOWLModel.getRDFResources(this, collection);
    }

    public RDFSNamedClass getOWLDataRangeClass() {
        return (RDFSNamedClass)this.owlDataRangeClass;
    }

    public RDFProperty getOWLIntersectionOfProperty() {
        return (RDFProperty)this.owlIntersectionOfProperty;
    }

    public OWLNamedClass getOWLNamedClass(String string) {
        return (OWLNamedClass)this.getCls(string);
    }

    public OWLNamedClass getOWLNamedClassClass() {
        return (OWLNamedClass)this.owlNamedClassClass;
    }

    public RDFProperty getOWLValuesFromProperty() {
        return (RDFProperty)this.owlValuesFromProperty;
    }

    public Collection getMatchingResources(RDFProperty rDFProperty, String string, int n) {
        Collection collection = this.getMatchingFrames(rDFProperty, null, false, string, n);
        return AbstractOWLModel.getRDFResources(this, collection);
    }

    public String getNextAnonymousResourceName() {
        String string;
        while (this.getFrame(string = ANONYMOUS_BASE + this.anonCount) != null) {
            ++this.anonCount;
        }
        return string;
    }

    public RDFList getRDFNil() {
        return (RDFList)this.rdfNilIndividual;
    }

    public Collection getRDFProperties() {
        return AbstractOWLModel.getRDFResources(this, this.getSlots());
    }

    public RDFResource getRDFResource(String string) {
        return (RDFResource)this.getFrame(string);
    }

    public RDFResource getRDFResourceAs(String string, Class clazz) {
        RDFResource rDFResource = this.getRDFResource(string);
        if (rDFResource != null) {
            return rDFResource.as(clazz);
        }
        return null;
    }

    public OWLIndividual getOWLIndividual(String string) {
        return (OWLIndividual)this.getFrame(string);
    }

    public OWLNamedClass getOWLNothing() {
        return (OWLNamedClass)this.owlNothingClass;
    }

    public Collection getOWLRestrictionsOnProperty(RDFProperty rDFProperty) {
        return this.getFramesWithValue(this.owlOnPropertyProperty, null, false, rDFProperty);
    }

    public Collection getSearchSynonymProperties() {
        HashSet<Frame> hashSet = new HashSet<Frame>();
        String string = this.getOWLProject().getSettingsMap().getString(SEARCH_SYNONYMS_KEY);
        if (string != null) {
            String[] stringArray = string.split(SEARCH_SYNONYMS_SEPARATOR);
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                Frame frame = this.getFrame(string2);
                if (!(frame instanceof Slot)) continue;
                hashSet.add(frame);
            }
        }
        return hashSet;
    }

    public OWLObjectProperty getOWLObjectProperty(String string) {
        return (OWLObjectProperty)this.getSlot(string);
    }

    public OWLNamedClass getOWLObjectPropertyClass() {
        return (OWLNamedClass)this.owlObjectPropertyClass;
    }

    public Collection getOWLOntologies() {
        return this.owlOntologyClass.getInstances();
    }

    public OWLOntology getOWLOntologyByURI(String string) {
        OWLOntology oWLOntology = null;
        try {
            URI uRI = new URI(string);
            oWLOntology = (OWLOntology)this.getOWLOntologyByURI(uRI);
        }
        catch (URISyntaxException uRISyntaxException) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", uRISyntaxException);
        }
        return oWLOntology;
    }

    public RDFResource getOWLOntologyByURI(URI uRI) {
        String string;
        String string2 = uRI.toString();
        if (!string2.endsWith("/") && !string2.endsWith("#")) {
            string2 = string2 + "#";
        }
        String string3 = (string = this.getNamespaceManager().getPrefix(string2)) != null ? string + ":" : ":";
        return this.getRDFResource(string3);
    }

    public OWLNamedClass getOWLOntologyClass() {
        return (OWLNamedClass)this.owlOntologyClass;
    }

    public Collection getOWLOntologyProperties() {
        return Arrays.asList(this.owlBackwardCompatibleWithProperty, this.owlIncompatibleWithProperty, this.owlPriorVersionProperty);
    }

    public Collection getOWLClasses() {
        return this.getRDFSClasses();
    }

    public OWLFrameStore getOWLFrameStore() {
        return this.owlFrameStore;
    }

    public RDFSNamedClass getOWLFunctionalPropertyClass() {
        return (RDFSNamedClass)this.owlFunctionalPropertyClass;
    }

    public RDFSNamedClass getOWLInverseFunctionalPropertyClass() {
        return (RDFSNamedClass)this.owlInverseFunctionalPropertyClass;
    }

    public Collection getOWLIndividuals() {
        return this.getOWLIndividuals(false);
    }

    public Collection getOWLIndividuals(boolean bl) {
        Collection collection = this.getRDFIndividuals(this.listOWLNamedClasses(), bl);
        Iterator iterator = this.listOWLAnonymousClasses();
        while (iterator.hasNext()) {
            OWLAnonymousClass oWLAnonymousClass = (OWLAnonymousClass)iterator.next();
            Collection collection2 = oWLAnonymousClass.getInstances(false);
            for (Instance instance : collection2) {
                collection.add(instance);
            }
        }
        return collection;
    }

    public OWLProperty getOWLProperty(String string) {
        return (OWLProperty)this.getSlot(string);
    }

    public Collection getOWLSystemResources() {
        ArrayList<Frame> arrayList = new ArrayList<Frame>(Arrays.asList(this.getOWLSystemFramesArray()));
        arrayList.addAll(this.rdfsDatatypeClass.getDirectInstances());
        return arrayList;
    }

    protected Frame[] getOWLSystemFramesArray() {
        this.nameSlot = this.getSlot(":NAME");
        Frame[] frameArray = new Frame[87];
        this.owlAllValuesFromClass = this.getCls("owl:AllValuesFromRestriction");
        frameArray[0] = this.owlAllValuesFromClass;
        this.anonymousClassMetaCls = this.getCls("owl:AnonymousClass");
        frameArray[1] = this.anonymousClassMetaCls;
        this.anonymousRootCls = this.getCls(":OWL-ANONYMOUS-ROOT");
        frameArray[2] = this.anonymousRootCls;
        this.owlCardinalityClass = this.getCls("owl:CardinalityRestriction");
        frameArray[3] = this.owlCardinalityClass;
        this.owlComplementClassClass = this.getCls("owl:ComplementClass");
        frameArray[4] = this.owlComplementClassClass;
        this.owlEnumeratedClassClass = this.getCls("owl:EnumeratedClass");
        frameArray[5] = this.owlEnumeratedClassClass;
        this.owlHasValueClass = this.getCls("owl:HasValueRestriction");
        frameArray[6] = this.owlHasValueClass;
        this.owlIntersectionClassClass = this.getCls("owl:IntersectionClass");
        frameArray[7] = this.owlIntersectionClassClass;
        this.owlLogicalClassClass = this.getCls("owl:LogicalClass");
        frameArray[8] = this.owlLogicalClassClass;
        this.owlMaxCardinalityClass = this.getCls("owl:MaxCardinalityRestriction");
        frameArray[9] = this.owlMaxCardinalityClass;
        this.owlMinCardinalityClass = this.getCls("owl:MinCardinalityRestriction");
        frameArray[10] = this.owlMinCardinalityClass;
        this.owlOntologyPrefixesProperty = this.getSlot(":OWL-ONTOLOGY-PREFIXES");
        frameArray[11] = this.owlOntologyPrefixesProperty;
        this.owlRestrictionClass = this.getCls("owl:Restriction");
        frameArray[12] = this.owlRestrictionClass;
        this.owlSomeValuesFromClass = this.getCls("owl:SomeValuesFromRestriction");
        frameArray[13] = this.owlSomeValuesFromClass;
        this.owlUnionClassClass = this.getCls("owl:UnionClass");
        frameArray[14] = this.owlUnionClassClass;
        this.rdfExternalResourceClass = this.getCls("protege:ExternalResource");
        frameArray[15] = this.rdfExternalResourceClass;
        this.owlResourceURIProperty = this.getSlot(":OWL-RESOURCE-URI");
        frameArray[16] = this.owlResourceURIProperty;
        this.protegeClassificationStatusProperty = this.getSlot("protege:classificationStatus");
        frameArray[17] = this.protegeClassificationStatusProperty;
        this.protegeInferredTypeProperty = this.getSlot("protege:inferredType");
        frameArray[18] = this.protegeInferredTypeProperty;
        this.protegeInferredSubclassesProperty = this.getSlot("protege:inferredSuperclassOf");
        frameArray[19] = this.protegeInferredSubclassesProperty;
        this.protegeInferredSuperclassesProperty = this.getSlot("protege:inferredSubclassOf");
        frameArray[20] = this.protegeInferredSuperclassesProperty;
        this.owlAllDifferentClass = this.getCls("owl:AllDifferent");
        frameArray[21] = this.owlAllDifferentClass;
        this.owlAllValuesFromProperty = this.getSlot("owl:allValuesFrom");
        frameArray[22] = this.owlAllValuesFromProperty;
        this.owlAnnotationPropertyClass = this.getCls("owl:AnnotationProperty");
        frameArray[23] = this.owlAnnotationPropertyClass;
        this.owlBackwardCompatibleWithProperty = this.getSlot("owl:backwardCompatibleWith");
        frameArray[24] = this.owlBackwardCompatibleWithProperty;
        this.owlCardinalityProperty = this.getSlot("owl:cardinality");
        frameArray[25] = this.owlCardinalityProperty;
        this.rdfsCommentProperty = this.getSlot("rdfs:comment");
        frameArray[26] = this.rdfsCommentProperty;
        this.owlComplementOfProperty = this.getSlot("owl:complementOf");
        frameArray[27] = this.owlComplementOfProperty;
        this.owlDataRangeClass = this.getCls("owl:DataRange");
        frameArray[28] = this.owlDataRangeClass;
        this.owlDatatypePropertyClass = this.getCls("owl:DatatypeProperty");
        frameArray[29] = this.owlDatatypePropertyClass;
        this.rdfsDomainProperty = this.getSlot("rdfs:domain");
        frameArray[30] = this.rdfsDomainProperty;
        this.owlDeprecatedClassClass = this.getCls("owl:DeprecatedClass");
        frameArray[31] = this.owlDeprecatedClassClass;
        this.owlDeprecatedPropertyClass = this.getCls("owl:DeprecatedProperty");
        frameArray[32] = this.owlDeprecatedPropertyClass;
        this.owlFunctionalPropertyClass = this.getCls("owl:FunctionalProperty");
        frameArray[33] = this.owlFunctionalPropertyClass;
        this.owlInverseFunctionalPropertyClass = this.getCls("owl:InverseFunctionalProperty");
        frameArray[34] = this.owlInverseFunctionalPropertyClass;
        this.owlSymmetricPropertyClass = this.getCls("owl:SymmetricProperty");
        frameArray[35] = this.owlSymmetricPropertyClass;
        this.owlTransitivePropertyClass = this.getCls("owl:TransitiveProperty");
        frameArray[36] = this.owlTransitivePropertyClass;
        this.owlDifferentFromProperty = this.getSlot("owl:differentFrom");
        frameArray[37] = this.owlDifferentFromProperty;
        this.owlDisjointWithProperty = this.getSlot("owl:disjointWith");
        frameArray[38] = this.owlDisjointWithProperty;
        this.owlDistinctMembersProperty = this.getSlot("owl:distinctMembers");
        frameArray[39] = this.owlDistinctMembersProperty;
        this.owlEquivalentClassProperty = this.getSlot("owl:equivalentClass");
        frameArray[40] = this.owlEquivalentClassProperty;
        this.owlEquivalentPropertyProperty = this.getSlot("owl:equivalentProperty");
        frameArray[41] = this.owlEquivalentPropertyProperty;
        this.rdfFirstProperty = this.getSlot("rdf:first");
        frameArray[42] = this.rdfFirstProperty;
        this.owlHasValueProperty = this.getSlot("owl:hasValue");
        frameArray[43] = this.owlHasValueProperty;
        this.owlIncompatibleWithProperty = this.getSlot("owl:incompatibleWith");
        frameArray[44] = this.owlIncompatibleWithProperty;
        this.owlIntersectionOfProperty = this.getSlot("owl:intersectionOf");
        frameArray[45] = this.owlIntersectionOfProperty;
        this.owlValuesFromProperty = this.getSlot("owl:valuesFrom");
        frameArray[46] = this.owlValuesFromProperty;
        this.rdfsIsDefinedByProperty = this.getSlot("rdfs:isDefinedBy");
        frameArray[47] = this.rdfsIsDefinedByProperty;
        this.rdfsLabelProperty = this.getSlot("rdfs:label");
        frameArray[48] = this.rdfsLabelProperty;
        this.rdfListClass = this.getCls("rdf:List");
        frameArray[49] = this.rdfListClass;
        this.rdfsLiteralClass = this.getCls("rdfs:Literal");
        frameArray[50] = this.rdfsLiteralClass;
        this.rdfsSubPropertyOfProperty = this.getSlot("rdfs:subPropertyOf");
        frameArray[51] = this.rdfsSubPropertyOfProperty;
        this.rdfsSubClassOfProperty = this.getSlot("rdfs:subClassOf");
        frameArray[52] = this.rdfsSubClassOfProperty;
        this.owlInverseOfProperty = this.getSlot("owl:inverseOf");
        frameArray[53] = this.owlInverseOfProperty;
        this.owlMaxCardinalityProperty = this.getSlot("owl:maxCardinality");
        frameArray[54] = this.owlMaxCardinalityProperty;
        this.owlMinCardinalityProperty = this.getSlot("owl:minCardinality");
        frameArray[55] = this.owlMinCardinalityProperty;
        this.owlNamedClassClass = this.getCls("owl:Class");
        frameArray[56] = this.owlNamedClassClass;
        this.rdfNilIndividual = this.getInstance("rdf:nil");
        frameArray[57] = this.rdfNilIndividual;
        this.owlNothingClass = this.getCls("owl:Nothing");
        frameArray[58] = this.owlNothingClass;
        this.owlObjectPropertyClass = this.getCls("owl:ObjectProperty");
        frameArray[59] = this.owlObjectPropertyClass;
        this.owlOnPropertyProperty = this.getSlot("owl:onProperty");
        frameArray[60] = this.owlOnPropertyProperty;
        this.owlOntologyClass = this.getCls("owl:Ontology");
        frameArray[61] = this.owlOntologyClass;
        this.owlImportsProperty = this.getSlot("owl:imports");
        frameArray[62] = this.owlImportsProperty;
        this.owlClassMetaCls = this.getCls(":OWL-CLASS");
        frameArray[63] = this.owlClassMetaCls;
        this.owlOneOfProperty = this.getSlot("owl:oneOf");
        frameArray[64] = this.owlOneOfProperty;
        this.rdfPropertyClass = this.getCls("rdf:Property");
        frameArray[65] = this.rdfPropertyClass;
        this.owlPriorVersionProperty = this.getSlot("owl:priorVersion");
        frameArray[66] = this.owlPriorVersionProperty;
        this.rdfObjectProperty = this.getSlot("rdf:object");
        frameArray[67] = this.rdfObjectProperty;
        this.rdfPredicateProperty = this.getSlot("rdf:predicate");
        frameArray[68] = this.rdfPredicateProperty;
        this.rdfsRangeProperty = this.getSlot("rdfs:range");
        frameArray[69] = this.rdfsRangeProperty;
        this.rdfStatementClass = this.getCls("rdf:Statement");
        frameArray[70] = this.rdfStatementClass;
        this.rdfSubjectProperty = this.getSlot("rdf:subject");
        frameArray[71] = this.rdfSubjectProperty;
        this.rdfTypeProperty = this.getSlot("rdf:type");
        frameArray[72] = this.rdfTypeProperty;
        this.rdfValueProperty = this.getSlot("rdf:value");
        frameArray[73] = this.rdfValueProperty;
        this.rdfsNamedClassClass = this.getCls("rdfs:Class");
        frameArray[74] = this.rdfsNamedClassClass;
        this.rdfAltClass = this.getCls("rdf:Alt");
        frameArray[75] = this.rdfAltClass;
        this.rdfBagClass = this.getCls("rdf:Bag");
        frameArray[76] = this.rdfBagClass;
        this.rdfsContainerClass = this.getCls("rdfs:Container");
        frameArray[77] = this.rdfsContainerClass;
        this.rdfsDatatypeClass = this.getCls("rdfs:Datatype");
        frameArray[78] = this.rdfsDatatypeClass;
        this.rdfsMemberProperty = this.getSlot("rdfs:member");
        frameArray[79] = this.rdfsMemberProperty;
        this.rdfSeqClass = this.getCls("rdf:Seq");
        frameArray[80] = this.rdfSeqClass;
        this.rdfRestSlot = this.getSlot("rdf:rest");
        frameArray[81] = this.rdfRestSlot;
        this.owlSameAsProperty = this.getSlot("owl:sameAs");
        frameArray[82] = this.owlSameAsProperty;
        this.rdfsSeeAlsoProperty = this.getSlot("rdfs:seeAlso");
        frameArray[83] = this.rdfsSeeAlsoProperty;
        this.owlSomeValuesFromProperty = this.getSlot("owl:someValuesFrom");
        frameArray[84] = this.owlSomeValuesFromProperty;
        this.owlUnionOfProperty = this.getSlot("owl:unionOf");
        frameArray[85] = this.owlUnionOfProperty;
        this.owlVersionInfoProperty = this.getSlot("owl:versionInfo");
        frameArray[86] = this.owlVersionInfoProperty;
        return frameArray;
    }

    public OWLNamedClass getOWLThingClass() {
        return (OWLNamedClass)this.getRootCls();
    }

    public RDFProperty getProtegeAllowedParentProperty() {
        return this.getRDFProperty(ProtegeNames.PROTEGE_PREFIX + ":" + "allowedParent");
    }

    public ValueType getOWLValueType(String string) {
        return XMLSchemaDatatypes.getValueType(string);
    }

    public RDFIndividual getRDFIndividual(String string) {
        return (RDFIndividual)this.getFrame(string);
    }

    public Collection getRDFIndividuals() {
        return this.getRDFIndividuals(false);
    }

    public Collection getRDFIndividuals(boolean bl) {
        return this.getRDFIndividuals(this.listRDFSNamedClasses(), bl);
    }

    private Collection getRDFIndividuals(Iterator iterator, boolean bl) {
        HashSet<Instance> hashSet = new HashSet<Instance>();
        while (iterator.hasNext()) {
            RDFSNamedClass rDFSNamedClass = (RDFSNamedClass)iterator.next();
            if (!rDFSNamedClass.isVisible() && bl) continue;
            Collection collection = rDFSNamedClass.getInstances(false);
            for (Instance instance : collection) {
                if (!(instance instanceof RDFIndividual) || instance instanceof OWLOntology || instance instanceof RDFList || instance instanceof OWLAllDifferent) continue;
                hashSet.add(instance);
            }
        }
        return hashSet;
    }

    public RDFSNamedClass getRDFSNamedClassClass() {
        return (RDFSNamedClass)this.rdfsNamedClassClass;
    }

    public RDFSNamedClass getRDFSNamedClass(String string) {
        return (RDFSNamedClass)this.getCls(string);
    }

    public RDFProperty getRDFProperty(String string) {
        return (RDFProperty)this.getSlot(string);
    }

    public RDFSNamedClass getRDFPropertyClass() {
        return (RDFSNamedClass)this.rdfPropertyClass;
    }

    public OWLDatatypeProperty getProtegeReadOnlyProperty() {
        if (this.isProtegeMetaOntologyImported()) {
            return (OWLDatatypeProperty)this.getSlot(ProtegeNames.getReadOnlySlotName());
        }
        return null;
    }

    public RDFSDatatype getRDFSDatatypeByName(String string) {
        return (RDFSDatatype)this.getFrame(string);
    }

    public RDFSDatatype getRDFSDatatypeByURI(String string) {
        for (RDFSDatatype rDFSDatatype : this.getRDFSDatatypes()) {
            if (!string.equals(rDFSDatatype.getURI())) continue;
            return rDFSDatatype;
        }
        return null;
    }

    public RDFSDatatype getRDFSDatatypeOfValue(Object object) {
        if (object instanceof RDFSLiteral) {
            return ((RDFSLiteral)object).getDatatype();
        }
        return DefaultRDFSLiteral.create(this, object).getDatatype();
    }

    public Collection getRDFSDatatypes() {
        ArrayList<RDFResource> arrayList = new ArrayList<RDFResource>();
        for (RDFResource rDFResource : this.rdfsDatatypeClass.getDirectInstances()) {
            if (rDFResource.isAnonymous()) continue;
            arrayList.add(rDFResource);
        }
        return arrayList;
    }

    public RDFProperty getRDFRestProperty() {
        return (RDFProperty)this.rdfRestSlot;
    }

    public RDFSDatatype getRDFXMLLiteralType() {
        if (this.xmlLiteralType == null) {
            this.xmlLiteralType = this.getRDFSDatatypeByName("rdf:XMLLiteral");
        }
        return this.xmlLiteralType;
    }

    public RDFSNamedClass[] getOWLRestrictionMetaclasses() {
        return new RDFSNamedClass[]{(RDFSNamedClass)this.owlAllValuesFromClass, (RDFSNamedClass)this.owlSomeValuesFromClass, (RDFSNamedClass)this.owlHasValueClass, (RDFSNamedClass)this.owlCardinalityClass, (RDFSNamedClass)this.owlMinCardinalityClass, (RDFSNamedClass)this.owlMaxCardinalityClass};
    }

    public synchronized Cls getRootCls() {
        if (this.owlThingClass == null) {
            this.owlThingClass = new DefaultOWLNamedClass(this, Model.ClsID.THING);
        }
        return this.owlThingClass;
    }

    public synchronized Cls getRootSlotMetaCls() {
        return this.getCls("rdf:Property");
    }

    public RDFProperty getOWLSameAsProperty() {
        return (RDFProperty)this.owlSameAsProperty;
    }

    public RDFProperty getOWLUnionOfProperty() {
        return (RDFProperty)this.owlUnionOfProperty;
    }

    public Cls getRDFSClassMetaClassCls() {
        return this.rdfsNamedClassClass;
    }

    public Cls getOWLNamedClassMetaClassCls() {
        return this.owlNamedClassClass;
    }

    public Cls getOWLDatatypePropertyMetaClassCls() {
        return this.owlDatatypePropertyClass;
    }

    public Cls getOWLObjectPropertyMetaClassCls() {
        return this.owlObjectPropertyClass;
    }

    public Cls getOWLAllDifferentClassCls() {
        return this.owlAllDifferentClass;
    }

    public Cls getRDFListCls() {
        return this.rdfListClass;
    }

    public Cls getOWLOntologyCls() {
        return this.owlOntologyClass;
    }

    public RDFProperty getProtegeSubclassesDisjointProperty() {
        if (this.isProtegeMetaOntologyImported()) {
            if (this.protegeSubclassesDisjointProperty == null) {
                this.protegeSubclassesDisjointProperty = this.getSlot(ProtegeNames.getSubclassesDisjointSlotName());
            }
            return (RDFProperty)this.protegeSubclassesDisjointProperty;
        }
        return null;
    }

    public RDFProperty getRDFTypeProperty() {
        return (RDFProperty)this.rdfTypeProperty;
    }

    public RDFProperty[] getSystemAnnotationProperties() {
        return new RDFProperty[]{(RDFProperty)this.rdfsSeeAlsoProperty, (RDFProperty)this.rdfsIsDefinedByProperty, (RDFProperty)this.rdfsLabelProperty, (RDFProperty)this.owlVersionInfoProperty, (RDFProperty)this.owlBackwardCompatibleWithProperty, (RDFProperty)this.owlIncompatibleWithProperty, (RDFProperty)this.owlPriorVersionProperty, (RDFProperty)this.rdfsCommentProperty};
    }

    public String getTodoAnnotationPrefix() {
        String string;
        OWLOntology oWLOntology;
        RDFProperty rDFProperty = this.getRDFProperty(ProtegeNames.getTodoPrefixSlotName());
        if (rDFProperty != null && (oWLOntology = this.getDefaultOWLOntology()) != null && (string = (String)oWLOntology.getPropertyValue(rDFProperty)) != null) {
            return string;
        }
        return DEFAULT_TODO_PREFIX;
    }

    public OWLDatatypeProperty getTodoAnnotationProperty() {
        Object object;
        OWLOntology oWLOntology;
        RDFProperty rDFProperty = this.getRDFProperty(ProtegeNames.getTodoPropertySlotName());
        if (rDFProperty != null && (oWLOntology = this.getDefaultOWLOntology()) != null && (object = oWLOntology.getPropertyValue(rDFProperty)) instanceof OWLDatatypeProperty) {
            return (OWLDatatypeProperty)object;
        }
        return (OWLDatatypeProperty)this.getSlot("owl:versionInfo");
    }

    public String[] getUsedLanguages() {
        Collection collection;
        OWLOntology oWLOntology;
        RDFProperty rDFProperty;
        if (this.isProtegeMetaOntologyImported() && (rDFProperty = this.getRDFProperty(ProtegeNames.getUsedLanguagesSlotName())) != null && (oWLOntology = this.getDefaultOWLOntology()) != null && (collection = oWLOntology.getPropertyValues(rDFProperty)).size() > 0) {
            return collection.toArray(new String[0]);
        }
        return DEFAULT_USED_LANGUAGES;
    }

    public Collection getUserDefinedOWLNamedClasses() {
        return this.getUserDefinedInstances(this.owlNamedClassClass);
    }

    public Collection getUserDefinedRDFIndividuals(boolean bl) {
        ArrayList<RDFResource> arrayList = new ArrayList<RDFResource>();
        for (RDFResource rDFResource : this.getRDFIndividuals(bl)) {
            if (rDFResource.isSystem()) continue;
            arrayList.add(rDFResource);
        }
        return arrayList;
    }

    private Collection getUserDefinedInstances(Cls cls) {
        Collection collection = cls.getInstances();
        return this.getUserDefinedInstances(collection);
    }

    private Collection getUserDefinedInstances(Collection collection) {
        ArrayList<Frame> arrayList = new ArrayList<Frame>();
        for (Frame frame : collection) {
            if (frame.isSystem()) continue;
            arrayList.add(frame);
        }
        return arrayList;
    }

    public Collection getUserDefinedOWLProperties() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.owlDatatypePropertyClass.getInstances());
        arrayList.addAll(this.owlObjectPropertyClass.getInstances());
        return this.getUserDefinedInstances(arrayList);
    }

    public Collection getUserDefinedOWLObjectProperties() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.owlObjectPropertyClass.getInstances());
        return this.getUserDefinedInstances(arrayList);
    }

    public Collection getUserDefinedOWLDatatypeProperties() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.owlDatatypePropertyClass.getInstances());
        return this.getUserDefinedInstances(arrayList);
    }

    public Collection getUserDefinedRDFProperties() {
        return this.getUserDefinedInstances(this.rdfPropertyClass);
    }

    public Collection getUserDefinedRDFSNamedClasses() {
        return this.getUserDefinedInstances(this.rdfsNamedClassClass);
    }

    public String getValueTypeURI(ValueType valueType) {
        return XMLSchemaDatatypes.getValueTypeURI(valueType);
    }

    public Collection getVisibleUserDefinedOWLProperties() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.owlDatatypePropertyClass.getInstances());
        arrayList.addAll(this.owlObjectPropertyClass.getInstances());
        return this.getVisibleUserDefinedInstances(arrayList);
    }

    private Collection getVisibleUserDefinedInstances(Cls cls) {
        Collection collection = cls.getInstances();
        return this.getVisibleUserDefinedInstances(collection);
    }

    private Collection getVisibleUserDefinedInstances(Collection collection) {
        ArrayList<Frame> arrayList = new ArrayList<Frame>();
        for (Frame frame : collection) {
            if (frame.isSystem() || !frame.isVisible()) continue;
            arrayList.add(frame);
        }
        return arrayList;
    }

    public Collection getVisibleUserDefinedRDFProperties() {
        return this.getVisibleUserDefinedInstances(this.rdfPropertyClass);
    }

    public RDFSDatatype getXSDboolean() {
        if (this.xsdBoolean == null) {
            this.xsdBoolean = (RDFSDatatype)this.getFrame("xsd:boolean");
        }
        return this.xsdBoolean;
    }

    public RDFSDatatype getXSDdouble() {
        if (this.xsdDouble == null) {
            this.xsdDouble = (RDFSDatatype)this.getFrame("xsd:double");
        }
        return this.xsdDouble;
    }

    public RDFSDatatype getXSDfloat() {
        if (this.xsdFloat == null) {
            this.xsdFloat = (RDFSDatatype)this.getFrame("xsd:float");
        }
        return this.xsdFloat;
    }

    public RDFSDatatype getXSDlong() {
        if (this.xsdLong == null) {
            this.xsdLong = (RDFSDatatype)this.getFrame("xsd:long");
        }
        return this.xsdLong;
    }

    public RDFSDatatype getXSDint() {
        if (this.xsdInt == null) {
            this.xsdInt = (RDFSDatatype)this.getFrame("xsd:int");
        }
        return this.xsdInt;
    }

    public RDFSDatatype getXSDshort() {
        if (this.xsdShort == null) {
            this.xsdShort = (RDFSDatatype)this.getFrame("xsd:short");
        }
        return this.xsdShort;
    }

    public RDFSDatatype getXSDbyte() {
        if (this.xsdByte == null) {
            this.xsdByte = (RDFSDatatype)this.getFrame("xsd:byte");
        }
        return this.xsdByte;
    }

    public RDFSDatatype getXSDstring() {
        if (this.xsdString == null) {
            this.xsdString = (RDFSDatatype)this.getFrame("xsd:string");
        }
        return this.xsdString;
    }

    public RDFSDatatype getXSDbase64Binary() {
        if (this.xsdBase64Binary == null) {
            this.xsdBase64Binary = (RDFSDatatype)this.getFrame("xsd:base64Binary");
        }
        return this.xsdBase64Binary;
    }

    public RDFSDatatype getXSDdate() {
        if (this.xsdDate == null) {
            this.xsdDate = (RDFSDatatype)this.getFrame("xsd:date");
        }
        return this.xsdDate;
    }

    public RDFSDatatype getXSDtime() {
        if (this.xsdTime == null) {
            this.xsdTime = (RDFSDatatype)this.getFrame("xsd:time");
        }
        return this.xsdTime;
    }

    public RDFSDatatype getXSDdateTime() {
        if (this.xsdDateTime == null) {
            this.xsdDateTime = (RDFSDatatype)this.getFrame("xsd:dateTime");
        }
        return this.xsdDateTime;
    }

    public RDFSDatatype getXSDduration() {
        if (this.xsdDuration == null) {
            this.xsdDuration = (RDFSDatatype)this.getFrame("xsd:duration");
        }
        return this.xsdDuration;
    }

    public RDFSDatatype getXSDanyURI() {
        if (this.xsdAnyURI == null) {
            this.xsdAnyURI = (RDFSDatatype)this.getFrame("xsd:anyURI");
        }
        return this.xsdAnyURI;
    }

    public RDFSDatatype getXSDdecimal() {
        if (this.xsdDecimal == null) {
            this.xsdDecimal = (RDFSDatatype)this.getFrame("xsd:decimal");
        }
        return this.xsdDecimal;
    }

    public RDFSDatatype getXSDinteger() {
        if (this.xsdInteger == null) {
            this.xsdInteger = (RDFSDatatype)this.getFrame("xsd:integer");
        }
        return this.xsdInteger;
    }

    public RDFProperty getOWLVersionInfoProperty() {
        return (RDFProperty)this.owlVersionInfoProperty;
    }

    public RDFProperty getRDFSRangeProperty() {
        return (RDFProperty)this.rdfsRangeProperty;
    }

    public RDFProperty getRDFSSubPropertyOfProperty() {
        return (RDFProperty)this.rdfsSubPropertyOfProperty;
    }

    public boolean isAnonymousResource(RDFResource rDFResource) {
        return rDFResource.isAnonymous();
    }

    public boolean isAnonymousResourceName(String string) {
        return string.charAt(0) == '@';
    }

    public boolean isDefaultAnonymousType(Cls cls) {
        return this.defaultAnonymousTypes.contains(cls);
    }

    public boolean isDefaultAnonymousType(Collection collection) {
        for (Cls cls : collection) {
            if (!this.isDefaultAnonymousType(cls)) continue;
            return true;
        }
        return false;
    }

    public boolean isOWLSystemFrame(Frame frame) {
        return this.getOWLSystemResources().contains(frame);
    }

    public boolean isProtegeMetaOntologyImported() {
        String string = ProtegeNames.getSubclassesDisjointSlotName();
        return this.getSlot(string) != null;
    }

    public boolean isValidResourceName(String string, RDFResource rDFResource) {
        return this.isValidFrameName(string, (Frame)rDFResource);
    }

    public boolean isTrueInstance(Instance instance) {
        return !(instance instanceof Slot) && !(instance instanceof Cls) && !(instance instanceof Facet) && !(instance instanceof OWLAllDifferent) && !(instance instanceof RDFList) && !(instance instanceof OWLOntology);
    }

    public Iterator listOWLAnonymousClasses() {
        ArrayList arrayList = new ArrayList();
        for (Object e : this.getCls("owl:AnonymousClass").getInstances()) {
            if (!(e instanceof OWLAnonymousClass)) continue;
            arrayList.add(e);
        }
        return arrayList.iterator();
    }

    public Iterator listOWLNamedClasses() {
        ArrayList arrayList = new ArrayList();
        for (Object e : this.getOWLNamedClassClass().getInstances(true)) {
            if (!(e instanceof OWLNamedClass)) continue;
            arrayList.add(e);
        }
        return arrayList.iterator();
    }

    public Iterator listRDFProperties() {
        return this.getRDFProperties().iterator();
    }

    public Iterator listRDFSNamedClasses() {
        ArrayList arrayList = new ArrayList();
        for (Object e : this.getRDFSNamedClassClass().getInstances(true)) {
            if (!(e instanceof RDFSNamedClass)) continue;
            arrayList.add(e);
        }
        return arrayList.iterator();
    }

    public Iterator listReferences(Object object, int n) {
        if (object instanceof DefaultRDFSLiteral) {
            object = ((DefaultRDFSLiteral)object).getRawValue();
        }
        Iterator iterator = this.getReferences(object, n).iterator();
        ArrayList<DefaultTuple> arrayList = new ArrayList<DefaultTuple>();
        while (iterator.hasNext()) {
            Reference reference = (Reference)iterator.next();
            if (!(reference.getFrame() instanceof RDFResource) || !(reference.getSlot() instanceof RDFProperty)) continue;
            arrayList.add(new DefaultTuple((RDFResource)reference.getFrame(), (RDFProperty)reference.getSlot()));
        }
        return arrayList.iterator();
    }

    public Iterator listSubjects(RDFProperty rDFProperty) {
        return this.getOWLFrameStore().getFramesWithAnyDirectOwnSlotValue(rDFProperty).iterator();
    }

    public synchronized Instance setDirectType(Instance instance, Cls cls) {
        if (instance instanceof OWLProperty && cls != null) {
            this.deleteRestrictionsDependingOnPropertyType((OWLProperty)instance, cls);
        }
        if (instance instanceof OWLNamedClass && cls.equals(this.rdfsNamedClassClass)) {
            this.deleteAnonymousSuperclasses((OWLNamedClass)instance);
        }
        return super.setDirectType(instance, cls);
    }

    private void deleteAnonymousSuperclasses(OWLNamedClass oWLNamedClass) {
        Collection collection = oWLNamedClass.getNamedSuperclasses();
        for (Cls cls : new ArrayList(oWLNamedClass.getSuperclasses(false))) {
            if (!(cls instanceof OWLAnonymousClass)) continue;
            cls.delete();
        }
        for (RDFSClass rDFSClass : collection) {
            if (oWLNamedClass.isSubclassOf(rDFSClass)) continue;
            oWLNamedClass.addSuperclass(rDFSClass);
        }
    }

    private void deleteRestrictionsDependingOnPropertyType(OWLProperty oWLProperty, Cls cls) {
        OWLNamedClass oWLNamedClass = null;
        oWLNamedClass = oWLProperty instanceof OWLDatatypeProperty ? this.getOWLDatatypePropertyClass() : this.getOWLObjectPropertyClass();
        if (!cls.hasSuperclass((Cls)oWLNamedClass)) {
            this.getOWLFrameStore().deleteQuantifierRestrictions(oWLProperty);
        }
    }

    public void setLoadDefaults(boolean bl) {
        this.loadDefaults = bl;
    }

    public void setProject(Project project) {
        super.setProject(project);
        if (this.bootstrapped) {
            this.setOWLProject(new DefaultOWLProject(project));
            project.setPrettyPrintSlotWidgetLabels(false);
            Slot slot = this.getSlot(":NAME");
            this.getRootCls().setDirectBrowserSlotPattern(new BrowserSlotPattern(slot));
            project.setDefaultClsWidgetClassName(OWLFormWidget.class.getName());
            project.setWidgetMapper((WidgetMapper)new OWLWidgetMapper(this));
            if (project.isMultiUserClient()) {
                FrameStoreManager frameStoreManager = this.getFrameStoreManager();
                frameStoreManager.removeFrameStore((FrameStore)this.owlFrameStore);
                this.owlFrameStore = null;
            }
            this.protegeClassificationStatusProperty.setVisible(false);
            this.protegeInferredSuperclassesProperty.setVisible(false);
            this.protegeInferredSubclassesProperty.setVisible(false);
            this.owlOntologyClass.setVisible(false);
        }
    }

    public void setSearchSynonymProperties(Collection collection) {
        if (collection.isEmpty()) {
            this.getOWLProject().getSettingsMap().setString(SEARCH_SYNONYMS_KEY, null);
        } else {
            String string = "";
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Slot slot = (Slot)iterator.next();
                string = string + slot.getName();
                if (!iterator.hasNext()) continue;
                string = string + SEARCH_SYNONYMS_SEPARATOR;
            }
            this.getOWLProject().getSettingsMap().setString(SEARCH_SYNONYMS_KEY, string);
        }
    }

    public void setTaskManager(TaskManager taskManager) {
        this.taskManager = taskManager;
    }

    public void addOWLTest(OWLTest oWLTest) {
        this.getOWLTestsSettingsMap().remove(oWLTest.getClass().getName());
    }

    public OWLTest[] getOWLTests() {
        Class[] classArray = OWLTestLibrary.getOWLTestClasses();
        ArrayList<OWLTest> arrayList = new ArrayList<OWLTest>();
        HashSet hashSet = new HashSet();
        Iterator iterator = this.getOWLTestsSettingsMap().listKeys();
        while (iterator.hasNext()) {
            hashSet.add(iterator.next());
        }
        for (int i = 0; i < classArray.length; ++i) {
            Class clazz = classArray[i];
            if (hashSet.contains(clazz.getName())) continue;
            arrayList.add(OWLTestLibrary.getOWLTest(clazz));
        }
        return arrayList.toArray(new OWLTest[0]);
    }

    private SettingsMap getOWLTestGroupsSettingsMap() {
        return this.getOWLProject().getSettingsMap().getSettingsMap(TESTGROUP_LIST_NAME);
    }

    private SettingsMap getOWLTestsSettingsMap() {
        return this.getOWLProject().getSettingsMap().getSettingsMap(TEST_LIST_NAME);
    }

    public boolean isAutoRepairEnabled() {
        return !Boolean.FALSE.equals(this.getOWLProject().getSettingsMap().getBoolean(AUTO_REPAIR_ENABLED));
    }

    public boolean isOWLTestGroupEnabled(String string) {
        return this.getOWLTestGroupsSettingsMap().getBoolean(string) == null;
    }

    public void removeOWLTest(OWLTest oWLTest) {
        String string = oWLTest.getClass().getName();
        this.getOWLTestsSettingsMap().setBoolean(string, true);
    }

    public void setAutoRepairEnabled(boolean bl) {
        this.getOWLProject().getSettingsMap().setBoolean(AUTO_REPAIR_ENABLED, (Boolean)bl);
    }

    public void setOWLTestGroupEnabled(String string, boolean bl) {
        if (bl) {
            this.getOWLTestGroupsSettingsMap().remove(string);
            Class[] classArray = OWLTestLibrary.getOWLTestClasses();
            for (int i = 0; i < classArray.length; ++i) {
                Class clazz = classArray[i];
                OWLTest oWLTest = OWLTestLibrary.getOWLTest(clazz);
                if (!string.equals(oWLTest.getGroup())) continue;
                this.addOWLTest(oWLTest);
            }
        } else {
            this.getOWLTestGroupsSettingsMap().setBoolean(string, true);
            OWLTest[] oWLTestArray = this.getOWLTests();
            for (int i = 0; i < oWLTestArray.length; ++i) {
                OWLTest oWLTest = oWLTestArray[i];
                if (!string.equals(oWLTest.getGroup())) continue;
                this.removeOWLTest(oWLTest);
            }
        }
    }

    public String createUniqueNewFrameName(String string) {
        return this.getUniqueFrameName(this.getName() + "_" + string);
    }

    public void defaultNamespaceChanged(String string, String string2) {
    }

    public String getResourceNameForURI(String string) {
        if (string.lastIndexOf(35) > 0) {
            return this.getFrameNameForURI(string, true);
        }
        String string2 = string.endsWith("/") ? string : string + "#";
        String string3 = this.getNamespaceManager().getPrefix(string2);
        if (string3 != null) {
            return string3 + ":";
        }
        if (string2.equals(this.getNamespaceManager().getDefaultNamespace())) {
            return ":";
        }
        return this.getFrameNameForURI(string, true);
    }

    public String getFrameNameForURI(String string, boolean bl) {
        String string2;
        String string3 = this.getLocalNameForURI(string);
        String string4 = this.getNamespaceForURI(string);
        NamespaceManager namespaceManager = this.getNamespaceManager();
        if (namespaceManager.getDefaultNamespace().equals(string4)) {
            if (string3 == null) {
                return ":";
            }
            return string3;
        }
        if (ProtegeNames.NS.equals(string4) && this.getFrame(string2 = ":" + string3) != null) {
            return string2;
        }
        string2 = namespaceManager.getPrefix(string4);
        if (string2 == null) {
            String string5 = null;
            int n = 1;
            while (namespaceManager.getNamespaceForPrefix(string5 = "p" + n++) != null) {
            }
            if (bl) {
                namespaceManager.setPrefix(string4, string5);
            }
            string2 = string5;
        }
        if (string3 != null) {
            return string2 + ":" + string3;
        }
        return string2 + ":";
    }

    public RDFResource getRDFResourceByBrowserText(String string) {
        for (Instance instance : this.getInstances()) {
            if (!(instance instanceof RDFResource) || !instance.getBrowserText().equals(string)) continue;
            return (RDFResource)this.getInstance(instance.getName());
        }
        return null;
    }

    public RDFResource getRDFResourceByNameOrBrowserText(String string) {
        Instance instance = this.getInstance(string);
        if (instance instanceof RDFResource) {
            return (RDFResource)instance;
        }
        instance = this.getRDFResourceByBrowserText(string);
        if (instance instanceof RDFResource) {
            return (RDFResource)instance;
        }
        return null;
    }

    public int getRDFSClassCount() {
        return this.owlClassMetaCls.getInstanceCount() - 4;
    }

    public Collection getRDFSClasses() {
        ArrayList arrayList = new ArrayList(this.owlClassMetaCls.getInstances());
        AbstractOWLModel.removeProtegeSystemResources(this, arrayList);
        return arrayList;
    }

    public RDFSDatatypeFactory getRDFSDatatypeFactory() {
        return this.rdfsDatatypeFactory;
    }

    private static void removeProtegeSystemResources(KnowledgeBase knowledgeBase, Collection collection) {
        if (collection.size() > 0) {
            Cls cls = knowledgeBase.getCls(":DIRECTED-BINARY-RELATION");
            collection.remove(cls);
            collection.remove(knowledgeBase.getCls(":PAL-CONSTRAINT"));
            collection.remove(knowledgeBase.getCls(":OWL-ANONYMOUS-ROOT"));
            collection.remove(knowledgeBase.getCls(":OWL-CLASS"));
            collection.remove(knowledgeBase.getSlot(":OWL-ONTOLOGY-PREFIXES"));
            collection.remove(knowledgeBase.getSlot(":OWL-RESOURCE-URI"));
            collection.remove(knowledgeBase.getSlot(":SLOT-CONSTRAINTS"));
        }
    }

    public Collection getResourcesWithPrefix(String string) {
        ArrayList<Frame> arrayList = new ArrayList<Frame>();
        for (Frame frame : this.getFrames()) {
            String string2;
            if (!(frame instanceof RDFResource) || !string.equals(string2 = ((RDFResource)frame).getNamespacePrefix())) continue;
            arrayList.add(frame);
        }
        return arrayList;
    }

    public String getLocalNameForResourceName(String string) {
        int n = string.indexOf(58);
        if (n >= 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    public String getLocalNameForURI(String string) {
        int n = Util.splitNamespace((String)string);
        if (n == string.length()) {
            return null;
        }
        return string.substring(n);
    }

    public NamespaceManager getNamespaceManager() {
        return this.namespaceManager;
    }

    public String getNamespaceForResourceName(String string) {
        int n = string.indexOf(58);
        if (n > 0) {
            String string2 = string.substring(0, n);
            String string3 = this.getNamespaceManager().getNamespaceForPrefix(string2);
            return string3;
        }
        return this.getNamespaceManager().getDefaultNamespace();
    }

    public String getNamespaceForURI(String string) {
        int n = Util.splitNamespace((String)string);
        if (n == string.length()) {
            return string;
        }
        return string.substring(0, n);
    }

    public String getPrefixForResourceName(String string) {
        int n = string.indexOf(58);
        if (n >= 0) {
            return string.substring(0, n);
        }
        return null;
    }

    public String getUniqueFrameName(String string) {
        String string2 = string;
        int n = this.lastGen;
        while (this.getFrame(string = string2 + "_" + n++) != null) {
        }
        this.lastGen = n;
        return string;
    }

    public String getURIForResourceName(String string) {
        if (string.indexOf(35) < 0) {
            NamespaceManager namespaceManager = this.getNamespaceManager();
            int n = string.indexOf(58);
            if (n == string.length() - 1) {
                String string2 = null;
                if (n == 0) {
                    string2 = namespaceManager.getDefaultNamespace();
                } else {
                    String string3 = string.substring(0, n);
                    string2 = namespaceManager.getNamespaceForPrefix(string3);
                }
                if (string2.endsWith("#") || string2.endsWith(":")) {
                    return string2.substring(0, string2.length() - 1);
                }
                return string2;
            }
            if (n >= 0) {
                String string4 = string.substring(n + 1);
                if (n == 0) {
                    return ProtegeNames.NS + string4;
                }
                String string5 = string.substring(0, n);
                String string6 = namespaceManager.getNamespaceForPrefix(string5);
                return string6 + string4;
            }
            return namespaceManager.getDefaultNamespace() + string;
        }
        return string;
    }

    public List getVisibleResources(Iterator iterator) {
        ArrayList<RDFResource> arrayList = new ArrayList<RDFResource>();
        while (iterator.hasNext()) {
            RDFResource rDFResource = (RDFResource)iterator.next();
            if (!rDFResource.isVisible()) continue;
            arrayList.add(rDFResource);
        }
        return arrayList;
    }

    public OWLDatatypeProperty getRDFSCommentProperty() {
        return (OWLDatatypeProperty)this.rdfsCommentProperty;
    }

    public String getValidNamespaceFrameName(String string) {
        return AbstractOWLModel.getValidOWLFrameName(this, string);
    }

    public static String getValidOWLFrameName(AbstractOWLModel abstractOWLModel, String string) {
        int n;
        Assert.assertNotNull((Object)string);
        String string2 = string;
        if (string2.startsWith(":")) {
            string2 = "_" + string2.substring(1);
        }
        int n2 = string2.indexOf(58) + 1;
        for (n = 0; n < string2.length(); ++n) {
            char c;
            if (n == n2 - 1 || Character.isJavaIdentifierPart(c = string2.charAt(n)) || VALID_SYMBOLS.indexOf(c) >= 0) continue;
            string2 = string2.replace(c, '_');
        }
        if (string2.length() == n2) {
            string2 = "_" + string2;
        } else if (!Character.isJavaIdentifierStart(string2.charAt(n2))) {
            n = n2 == 0 ? n2 : n2 - 1;
            string2 = string2.substring(0, n) + "_" + string2.substring(n2);
        }
        if (!string2.equals(string)) {
            string = abstractOWLModel != null && abstractOWLModel.getFrame(string2) != null ? abstractOWLModel.getUniqueFrameName(string2) : string2;
        }
        return string;
    }

    public synchronized boolean isSlotMetaCls(Cls cls) {
        return this.rdfPropertyClass.equals(cls) || this.hasSuperclass(cls, this.getRootSlotMetaCls());
    }

    public boolean isValidOWLFrameName(String string) {
        return AbstractOWLModel.isValidOWLFrameName(this.getNamespaceManager(), string);
    }

    public static boolean isValidOWLFrameName(NamespaceManager namespaceManager, String string) {
        if (string == null) {
            return false;
        }
        int n = string.indexOf(58);
        if (n >= 0) {
            if (n == string.length() - 1) {
                return false;
            }
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            String string4 = namespaceManager.getNamespaceForPrefix(string2);
            if (string4 == null) {
                return false;
            }
            int n2 = string.lastIndexOf(58);
            if (n != n2) {
                return false;
            }
            return AbstractOWLModel.isValidOWLFrameNamePart(string3);
        }
        return AbstractOWLModel.isValidOWLFrameNamePart(string);
    }

    private static boolean isValidOWLFrameNamePart(String string) {
        if (string.length() == 0) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isJavaIdentifierPart(c) || VALID_SYMBOLS.indexOf(c) >= 0) continue;
            return false;
        }
        return Character.isJavaIdentifierStart(string.charAt(0));
    }

    public void namespaceChanged(String string, String string2, String string3) {
    }

    public void prefixAdded(String string) {
    }

    public void prefixChanged(String string, String string2, String string3) {
        this.replacePrefixInInstances(string2, string3);
    }

    public void prefixRemoved(String string) {
        this.replacePrefixInInstances(string, null);
    }

    public void replacePrefixInInstances(String string, String string2) {
        TripleStoreModel tripleStoreModel = this.getTripleStoreModel();
        TripleStore tripleStore = tripleStoreModel.getActiveTripleStore();
        Iterator iterator = tripleStoreModel.listUserTripleStores();
        while (iterator.hasNext()) {
            TripleStore tripleStore2 = (TripleStore)iterator.next();
            tripleStoreModel.setActiveTripleStore(tripleStore2);
            Iterator iterator2 = tripleStore2.listHomeResources();
            while (iterator2.hasNext()) {
                String string3;
                RDFResource rDFResource = (RDFResource)iterator2.next();
                if (rDFResource.getNamespacePrefix() == null || !rDFResource.getNamespacePrefix().equals(string)) continue;
                String string4 = string3 = rDFResource.getLocalName();
                if (string2 != null && string2.length() > 0) {
                    string4 = string2 + ":" + string3;
                }
                if (this.getFrame(string4) != null) {
                    string4 = this.getUniqueFrameName(string4);
                }
                rDFResource.setName(string4);
            }
        }
        tripleStoreModel.setActiveTripleStore(tripleStore);
    }

    public void resetJenaModel() {
        this.jenaModel = null;
    }

    public void setNamespaceManager(NamespaceManager namespaceManager) {
        this.namespaceManager = namespaceManager;
    }

    public RDFSNamedClass getRDFSDatatypeClass() {
        return (RDFSNamedClass)this.rdfsDatatypeClass;
    }

    public Collection getPropertyValueLiterals(RDFResource rDFResource, RDFProperty rDFProperty) {
        return this.owlFrameStore.getPropertyValueLiterals(rDFResource, rDFProperty);
    }

    public List getValueLiterals(List list) {
        return this.owlFrameStore.getLiteralValues(list);
    }

    public RDFProperty getRDFSSubClassOfProperty() {
        return (RDFProperty)this.rdfsSubClassOfProperty;
    }

    public RDFProperty getOWLEquivalentClassProperty() {
        return (RDFProperty)this.owlEquivalentClassProperty;
    }

    public RDFProperty getOWLInverseOfProperty() {
        return (RDFProperty)this.owlInverseOfProperty;
    }

    public RDFProperty getOWLDistinctMembersProperty() {
        return (RDFProperty)this.owlDistinctMembersProperty;
    }
}

