/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.framestore;

import edu.stanford.smi.protege.event.ClsEvent;
import edu.stanford.smi.protege.event.FacetEvent;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.InstanceEvent;
import edu.stanford.smi.protege.event.KnowledgeBaseEvent;
import edu.stanford.smi.protege.event.SlotEvent;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Model;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.AbstractFrameStoreInvocationHandler;
import edu.stanford.smi.protege.model.framestore.ReferenceImpl;
import edu.stanford.smi.protege.util.AbstractEvent;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLNames;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFNames;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNames;
import edu.stanford.smi.protegex.owl.model.factory.OWLJavaFactory;
import edu.stanford.smi.protegex.owl.model.factory.OWLJavaFactoryUpdater;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLNamedClass;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class OWLFrameFactoryInvocationHandler
extends AbstractFrameStoreInvocationHandler {
    private OWLJavaFactory ff;
    private OWLNamedClass owlNamedClassClass;
    private static OWLFrameFactoryInvocationHandler recentInstance;
    private static Set<String> systemClses;
    private Cls thingCls;
    private OWLJavaFactoryUpdater updater;

    public OWLFrameFactoryInvocationHandler() {
        recentInstance = this;
    }

    private Object convert(Object object) {
        if (object instanceof Collection) {
            return this.convertCollection((Collection)object);
        }
        if (object instanceof Instance) {
            return this.convertInstance((Instance)object);
        }
        if (object instanceof Reference) {
            return this.convertReference((Reference)object);
        }
        if (object instanceof AbstractEvent) {
            return this.convertEvent((AbstractEvent)object);
        }
        return object;
    }

    public Collection convertCollection(Collection collection) {
        if (collection.size() == 0) {
            return collection;
        }
        AbstractCollection abstractCollection = null;
        abstractCollection = collection instanceof Set ? new HashSet(collection.size()) : new ArrayList(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            abstractCollection.add(this.convert(iterator.next()));
        }
        return abstractCollection;
    }

    private AbstractEvent convertEvent(AbstractEvent abstractEvent) {
        if (abstractEvent instanceof ClsEvent) {
            return new ClsEvent((Cls)this.convert(abstractEvent.getSource()), abstractEvent.getEventType(), this.convert(abstractEvent.getArgument1()), this.convert(abstractEvent.getArgument2()));
        }
        if (abstractEvent instanceof FacetEvent) {
            return new FacetEvent((Facet)this.convert(abstractEvent.getSource()), abstractEvent.getEventType(), (Frame)this.convert(((FacetEvent)abstractEvent).getFrame()), (Slot)this.convert(((FacetEvent)abstractEvent).getSlot()));
        }
        if (abstractEvent instanceof FrameEvent) {
            return new FrameEvent((Frame)this.convert(abstractEvent.getSource()), abstractEvent.getEventType(), this.convert(abstractEvent.getArgument1()), this.convert(abstractEvent.getArgument2()));
        }
        if (abstractEvent instanceof InstanceEvent) {
            return new InstanceEvent((Instance)this.convert(abstractEvent.getSource()), abstractEvent.getEventType(), this.convert(abstractEvent.getArgument()));
        }
        if (abstractEvent instanceof KnowledgeBaseEvent) {
            KnowledgeBaseEvent knowledgeBaseEvent = (KnowledgeBaseEvent)abstractEvent;
            Frame frame = (Frame)this.convert(knowledgeBaseEvent.getFrame());
            KnowledgeBase knowledgeBase = (KnowledgeBase)knowledgeBaseEvent.getSource();
            if (knowledgeBase == null) {
                knowledgeBase = frame.getKnowledgeBase();
            }
            return new KnowledgeBaseEvent(knowledgeBase, knowledgeBaseEvent.getEventType(), frame, this.convert(knowledgeBaseEvent.getArgument2()), this.convert(knowledgeBaseEvent.getArgument3()));
        }
        if (abstractEvent instanceof SlotEvent) {
            SlotEvent slotEvent = (SlotEvent)abstractEvent;
            return new SlotEvent((Slot)this.convert(slotEvent.getSlot()), slotEvent.getEventType(), (Frame)this.convert(slotEvent.getFrame()));
        }
        return abstractEvent;
    }

    public Instance convertInstance(Instance instance) {
        Object object;
        if (this.ff == null) {
            object = (AbstractOWLModel)instance.getKnowledgeBase();
            this.ff = new OWLJavaFactory((AbstractOWLModel)object);
            this.owlNamedClassClass = new DefaultOWLNamedClass((KnowledgeBase)object, OWLNames.ClsID.NAMED_CLASS);
            this.thingCls = new DefaultOWLNamedClass((KnowledgeBase)object, Model.ClsID.THING);
        }
        if (instance instanceof Cls) {
            if (Model.ClsID.THING.equals((Object)instance.getFrameID())) {
                return this.thingCls;
            }
            if (instance.isSystem() && instance.getFrameID().getLocalPart() < 9000 && !Model.ClsID.DIRECTED_BINARY_RELATION.equals((Object)instance.getFrameID()) || instance instanceof RDFSClass) {
                if (this.owlNamedClassClass.equals(instance)) {
                    return this.owlNamedClassClass;
                }
                return instance;
            }
            if (this.isDefaultNamedCls(instance)) {
                return new DefaultOWLNamedClass(instance.getKnowledgeBase(), instance.getFrameID());
            }
            return this.ff.createCls(instance.getFrameID(), instance.getDirectTypes());
        }
        if (instance instanceof Slot) {
            object = instance.getDirectTypes();
            Slot slot = this.ff.createSlot(instance.getFrameID(), (Collection)object);
            if (!(slot instanceof RDFProperty || slot.isSystem() || object.isEmpty())) {
                if (this.updater == null) {
                    this.updater = new OWLJavaFactoryUpdater(slot.getKnowledgeBase(), Collections.singleton(slot));
                }
                return this.updater.createNewFrame((Instance)slot);
            }
            return slot;
        }
        if (instance instanceof Facet) {
            return this.ff.createFacet(instance.getFrameID(), instance.getDirectTypes());
        }
        if (instance == null) {
            return null;
        }
        object = instance.getDirectTypes();
        if (object.isEmpty() && instance instanceof RDFList) {
            return instance;
        }
        return this.ff.createSimpleInstance(instance.getFrameID(), (Collection)object);
    }

    private Reference convertReference(Reference reference) {
        Instance instance = this.convertInstance((Instance)reference.getFrame());
        Slot slot = (Slot)this.convertInstance((Instance)reference.getSlot());
        Facet facet = (Facet)this.convertInstance((Instance)reference.getFacet());
        return new ReferenceImpl((Frame)instance, slot, facet, reference.isTemplate());
    }

    protected Object handleInvoke(Method method, Object[] objectArray) {
        Object object = this.invoke(method, objectArray);
        return this.convert(object);
    }

    private boolean isDefaultNamedCls(Instance instance) {
        FrameID frameID = instance.getFrameID();
        return OWLNames.ClsID.NAMED_CLASS.equals((Object)frameID) || RDFNames.ClsID.PROPERTY.equals((Object)frameID) || RDFSNames.ClsID.NAMED_CLASS.equals((Object)frameID);
    }

    public static final void setFrameFactory(OWLJavaFactory oWLJavaFactory) {
        OWLFrameFactoryInvocationHandler.recentInstance.ff = oWLJavaFactory;
    }

    static {
        systemClses = new HashSet<String>();
        systemClses.add(":THING");
        systemClses.add(":CLASS");
        systemClses.add(":META-CLASS");
        systemClses.add(":STANDARD-CLASS");
        systemClses.add(":SYSTEM-CLASS");
    }
}

