/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.classparser;

import edu.stanford.smi.protege.model.BrowserSlotPattern;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protegex.owl.model.OWLClass;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.classparser.AmbiguousNameException;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFSLiteral;
import java.util.Collection;
import java.util.List;

public class ParserUtils {
    public static Frame getFrameByName(OWLModel oWLModel, String string) throws AmbiguousNameException {
        return ParserUtils.getFrameByName(oWLModel, string, null);
    }

    public static OWLClass getOWLClassFromName(OWLModel oWLModel, String string) throws AmbiguousNameException {
        return (OWLClass)ParserUtils.getFrameByName(oWLModel, string, OWLClass.class);
    }

    public static RDFProperty getRDFPropertyFromName(OWLModel oWLModel, String string) throws AmbiguousNameException {
        return (RDFProperty)ParserUtils.getFrameByName(oWLModel, string, RDFProperty.class);
    }

    public static OWLDatatypeProperty getOWLDatatypePropertyFromName(OWLModel oWLModel, String string) throws AmbiguousNameException {
        return (OWLDatatypeProperty)ParserUtils.getFrameByName(oWLModel, string, OWLDatatypeProperty.class);
    }

    public static OWLObjectProperty getOWLObjectPropertyFromName(OWLModel oWLModel, String string) throws AmbiguousNameException {
        return (OWLObjectProperty)ParserUtils.getFrameByName(oWLModel, string, OWLObjectProperty.class);
    }

    public static RDFResource getRDFResourceFromName(OWLModel oWLModel, String string) throws AmbiguousNameException {
        return ParserUtils.getFrameByName(oWLModel, string, RDFResource.class);
    }

    public static OWLIndividual getOWLIndividualFromName(OWLModel oWLModel, String string) throws AmbiguousNameException {
        return (OWLIndividual)ParserUtils.getFrameByName(oWLModel, string, OWLIndividual.class);
    }

    private static RDFResource getFrameByName(OWLModel oWLModel, String string, Class clazz) throws AmbiguousNameException {
        RDFResource rDFResource = (RDFResource)oWLModel.getFrame(string);
        if (rDFResource != null && ParserUtils.resourceCorrectlyTyped((Frame)rDFResource, clazz)) {
            return rDFResource;
        }
        rDFResource = null;
        String string2 = oWLModel.getDefaultLanguage();
        Collection collection = oWLModel.getFramesWithValue(oWLModel.getRDFSLabelProperty(), null, false, DefaultRDFSLiteral.getRawValue(string, string2));
        for (Object e : collection) {
            if (!ParserUtils.resourceCorrectlyTyped((Frame)e, clazz) || !ParserUtils.displaysWithRDFSLabel(oWLModel, (Instance)e)) continue;
            if (rDFResource != null) {
                throw new AmbiguousNameException("Multiple resourcese share the same name " + string);
            }
            rDFResource = (RDFResource)e;
        }
        if (rDFResource != null) {
            return rDFResource;
        }
        if (string2 != null) {
            collection = oWLModel.getFramesWithValue(oWLModel.getRDFSLabelProperty(), null, false, DefaultRDFSLiteral.getRawValue(string, (String)null));
            for (Object e : collection) {
                if (!ParserUtils.resourceCorrectlyTyped((Frame)e, clazz) || !ParserUtils.displaysWithRDFSLabel(oWLModel, (Instance)e)) continue;
                if (rDFResource != null) {
                    throw new AmbiguousNameException("After falling back to the null language multiple resources share the same name " + string);
                }
                rDFResource = (RDFResource)e;
            }
        }
        return rDFResource;
    }

    private static boolean displaysWithRDFSLabel(OWLModel oWLModel, Instance instance) {
        Cls cls = instance.getDirectType();
        BrowserSlotPattern browserSlotPattern = cls.getBrowserSlotPattern();
        List list = browserSlotPattern.getSlots();
        return list.size() == 1 && list.contains(oWLModel.getRDFSLabelProperty());
    }

    private static boolean resourceCorrectlyTyped(Frame frame, Class clazz) {
        if (clazz == null) {
            return true;
        }
        return clazz.isAssignableFrom(frame.getClass());
    }
}

