/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.triplestore;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.InMemoryFrameDb;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.model.framestore.Record;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFSLiteral;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.AbstractTripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.DefaultTriple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class JenaTripleStore
extends AbstractTripleStore {
    public JenaTripleStore(OWLModel oWLModel, NarrowFrameStore narrowFrameStore, TripleStoreModel tripleStoreModel) {
        super(oWLModel, tripleStoreModel, narrowFrameStore);
    }

    public boolean equals(Object object) {
        if (object instanceof JenaTripleStore) {
            return this.frameStore.getName().equals(((JenaTripleStore)object).frameStore.getName());
        }
        return false;
    }

    public Iterator listTriples() {
        OWLModel oWLModel = this.owlModel;
        HashSet<Slot> hashSet = new HashSet<Slot>();
        hashSet.add(this.owlModel.getRDFProperty(":OWL-ONTOLOGY-PREFIXES"));
        hashSet.add(oWLModel.getSlot(":DIRECT-INSTANCES"));
        hashSet.add(oWLModel.getSlot(":DIRECT-TYPE"));
        hashSet.add(oWLModel.getSlot("protege:classificationStatus"));
        hashSet.add(oWLModel.getSlot("protege:inferredSuperclassOf"));
        hashSet.add(oWLModel.getSlot("protege:inferredSubclassOf"));
        hashSet.add(oWLModel.getSlot("protege:inferredType"));
        ArrayList<DefaultTriple> arrayList = new ArrayList<DefaultTriple>();
        Collection collection = ((InMemoryFrameDb)this.frameStore).getRecords();
        for (Record record : collection) {
            Slot slot;
            Frame frame = record.getFrame();
            if (!(frame instanceof RDFResource) || !((slot = record.getSlot()) instanceof RDFProperty) || record.getFacet() != null || record.isTemplate() || hashSet.contains(slot)) continue;
            List list = record.getValues();
            for (Object object : list) {
                if (object instanceof String && DefaultRDFSLiteral.isRawValue((String)object)) {
                    object = new DefaultRDFSLiteral(this.owlModel, (String)object);
                }
                DefaultTriple defaultTriple = new DefaultTriple((RDFResource)frame, (RDFProperty)slot, object);
                arrayList.add(defaultTriple);
            }
        }
        return arrayList.iterator();
    }
}

