/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.protege2jena;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.datatypes.xsd.impl.XMLLiteralType;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import edu.stanford.smi.protegex.owl.jena.Jena;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.impl.XMLSchemaDatatypes;
import edu.stanford.smi.protegex.owl.model.triplestore.Triple;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.util.RepositoryFileManager;
import java.io.File;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Protege2Jena {
    private Model dummyModel = ModelFactory.createDefaultModel();
    private Collection fillTripleStores;
    private OWLModel owlModel;
    private OntModel ontModel;
    private Map tripleStore2Model;
    private TripleStoreModel tripleStoreModel;
    private static final String TEMP_SUFFIX = ".temp";

    private Protege2Jena(OWLModel oWLModel, OntModel ontModel, Collection collection, Map map) {
        this.fillTripleStores = collection;
        this.owlModel = oWLModel;
        this.ontModel = ontModel;
        this.tripleStoreModel = oWLModel.getTripleStoreModel();
        this.tripleStore2Model = map;
        this.createSubModels();
        this.fillModels();
    }

    private void copyTriples(TripleStore tripleStore, Model model) {
        Iterator iterator = tripleStore.listTriples();
        while (iterator.hasNext()) {
            Triple triple = (Triple)iterator.next();
            Statement statement = this.createStatement(triple, model);
            model.add(statement);
        }
    }

    public static OntModel createOntModel(OWLModel oWLModel) {
        return Protege2Jena.createOntModel(oWLModel, OntModelSpec.OWL_MEM, oWLModel.getTripleStoreModel().getTripleStores());
    }

    public static OntModel createOntModel(OWLModel oWLModel, Collection collection) {
        return Protege2Jena.createOntModel(oWLModel, OntModelSpec.OWL_MEM, collection);
    }

    public static OntModel createOntModel(OWLModel oWLModel, Collection collection, Map map) {
        return Protege2Jena.createOntModel(oWLModel, OntModelSpec.OWL_MEM, collection, map);
    }

    public static OntModel createOntModel(OWLModel oWLModel, OntModelSpec ontModelSpec, Collection collection) {
        HashMap hashMap = new HashMap();
        return Protege2Jena.createOntModel(oWLModel, ontModelSpec, collection, hashMap);
    }

    public static OntModel createOntModel(OWLModel oWLModel, OntModelSpec ontModelSpec, Collection collection, Map map) {
        OntModel ontModel = ModelFactory.createOntologyModel((OntModelSpec)ontModelSpec);
        new Protege2Jena(oWLModel, ontModel, collection, map);
        return ontModel;
    }

    private void createSubModels() {
        Iterator iterator = this.tripleStoreModel.listUserTripleStores();
        TripleStore tripleStore = (TripleStore)iterator.next();
        Model model = this.ontModel.getBaseModel();
        this.tripleStore2Model.put(tripleStore, model);
        while (iterator.hasNext()) {
            TripleStore tripleStore2 = (TripleStore)iterator.next();
            Model model2 = this.createSubModel(tripleStore2);
            this.ontModel.addSubModel(model2);
            this.tripleStore2Model.put(tripleStore2, model2);
        }
    }

    private Model createSubModel(TripleStore tripleStore) {
        return ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
    }

    private void createNamespacePrefixes(TripleStore tripleStore, Model model) {
        for (String string : model.getNsPrefixMap().keySet()) {
            model.removeNsPrefix(string);
        }
        for (String string : tripleStore.getPrefixes()) {
            String string2 = tripleStore.getNamespaceForPrefix(string);
            model.setNsPrefix(string, string2);
        }
    }

    private Statement createStatement(Triple triple, Model model) {
        Resource resource = this.getResource(triple.getSubject(), model);
        Property property = this.getProperty(triple.getPredicate(), model);
        RDFNode rDFNode = this.getRDFNode(triple.getObject(), model);
        return model.createStatement(resource, property, rDFNode);
    }

    private void fillModels() {
        for (TripleStore tripleStore : this.tripleStore2Model.keySet()) {
            if (!this.fillTripleStores.contains(tripleStore)) continue;
            Model model = this.getModel(tripleStore);
            this.createNamespacePrefixes(tripleStore, model);
            this.copyTriples(tripleStore, model);
            this.removeRedundantRDFSDomains(model);
            this.removeRedundantRDFSSubClassOfOWLThings(model);
            this.removeRedundantRDFSSubClassOfEquivalentClasses(model);
            Protege2Jena.removeRedundantRDFLists(model);
        }
    }

    private Model getModel(TripleStore tripleStore) {
        return (Model)this.tripleStore2Model.get(tripleStore);
    }

    protected static Set getParseTypeCollectionProperties() {
        HashSet<Property> hashSet = new HashSet<Property>();
        hashSet.add(OWL.unionOf);
        hashSet.add(OWL.intersectionOf);
        hashSet.add(OWL.distinctMembers);
        hashSet.add(OWL.oneOf);
        return hashSet;
    }

    private Property getProperty(RDFProperty rDFProperty, Model model) {
        String string = rDFProperty.getURI();
        Property property = this.dummyModel.getProperty(string);
        if (property != null) {
            return property;
        }
        return this.dummyModel.createProperty(string);
    }

    private RDFNode getRDFNode(Object object, Model model) {
        if (object instanceof RDFResource) {
            return this.getResource((RDFResource)object, model);
        }
        if (object instanceof RDFSLiteral) {
            RDFSLiteral rDFSLiteral = (RDFSLiteral)object;
            String string = rDFSLiteral.getLanguage();
            if (string != null) {
                String string2 = rDFSLiteral.getString();
                return model.createLiteral(string2, string);
            }
            XSDDatatype xSDDatatype = XMLSchemaDatatypes.getXSDDatatype(rDFSLiteral.getDatatype());
            if (xSDDatatype == null && this.owlModel.getRDFXMLLiteralType().equals(rDFSLiteral.getDatatype())) {
                xSDDatatype = XMLLiteralType.theXMLLiteralType;
            }
            return model.createTypedLiteral(rDFSLiteral.getString(), (RDFDatatype)xSDDatatype);
        }
        return model.createTypedLiteral(object);
    }

    private Resource getResource(RDFResource rDFResource, Model model) {
        if (rDFResource.isAnonymous()) {
            AnonId anonId = new AnonId("_:" + rDFResource.getName());
            return model.createResource(anonId);
        }
        return model.getResource(rDFResource.getURI());
    }

    public static void removeRedundantRDFLists(Model model) {
        Set set = Protege2Jena.getParseTypeCollectionProperties();
        for (Property property : set) {
            NodeIterator nodeIterator = model.listObjectsOfProperty(property);
            while (nodeIterator.hasNext()) {
                Object e = nodeIterator.next();
                if (!(e instanceof Resource) || !((Resource)e).hasProperty(RDF.type, (RDFNode)RDF.List)) continue;
                Protege2Jena.removeRedundantRDFListsRecursively((Resource)e);
            }
        }
    }

    private static void removeRedundantRDFListsRecursively(Resource resource) {
        if (!resource.equals(RDF.nil)) {
            Statement statement;
            if (resource.hasProperty(RDF.type, (RDFNode)RDF.List)) {
                resource.removeAll(RDF.type);
            }
            if ((statement = resource.getProperty(RDF.rest)) != null) {
                Protege2Jena.removeRedundantRDFListsRecursively((Resource)statement.getObject());
            }
        }
    }

    private void removeRedundantRDFSDomains(Model model) {
        Set set = Jena.set((Iterator)model.listSubjectsWithProperty(RDFS.domain, (RDFNode)OWL.Thing));
        for (Resource resource : set) {
            StmtIterator stmtIterator = resource.listProperties(RDFS.domain);
            stmtIterator.next();
            if (stmtIterator.hasNext()) continue;
            resource.removeAll(RDFS.domain);
        }
    }

    private void removeRedundantRDFSSubClassOfOWLThings(Model model) {
        Set set = Jena.set((Iterator)model.listSubjectsWithProperty(RDFS.subClassOf, (RDFNode)OWL.Thing));
        for (Resource resource : set) {
            StmtIterator stmtIterator = resource.listProperties(RDFS.subClassOf);
            stmtIterator.next();
            if (stmtIterator.hasNext()) continue;
            resource.removeAll(RDFS.subClassOf);
        }
    }

    private void removeRedundantRDFSSubClassOfEquivalentClasses(Model model) {
        ResIterator resIterator = model.listSubjectsWithProperty(OWL.equivalentClass);
        while (resIterator.hasNext()) {
            Resource resource = (Resource)resIterator.next();
            Iterator iterator = Jena.cloneIt((Iterator)resource.listProperties(OWL.equivalentClass));
            while (iterator.hasNext()) {
                Resource resource2 = (Resource)((Statement)iterator.next()).getObject();
                if (model.contains(resource2, OWL.intersectionOf)) {
                    RDFNode rDFNode = model.listObjectsOfProperty(resource2, OWL.intersectionOf).nextNode();
                    if (!rDFNode.canAs(RDFList.class)) continue;
                    RDFList rDFList = (RDFList)rDFNode.as(RDFList.class);
                    for (Resource resource3 : rDFList) {
                        if (resource3.isAnon()) continue;
                        model.removeAll(resource, RDFS.subClassOf, (RDFNode)resource3);
                    }
                    continue;
                }
                if (resource2.isAnon()) continue;
                model.removeAll(resource, RDFS.subClassOf, (RDFNode)resource2);
                model.removeAll(resource2, RDFS.subClassOf, (RDFNode)resource);
            }
        }
    }

    public static void saveAll(OWLModel oWLModel, URI uRI) throws Exception {
        Protege2Jena.saveAll(oWLModel, uRI, "RDF/XML-ABBREV");
    }

    public static void saveAll(OWLModel oWLModel, URI uRI, String string) throws Exception {
        Object object;
        Object object2;
        Comparable<URI> comparable;
        String string2;
        Object object3;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = oWLModel.getTripleStoreModel().listUserTripleStores();
        arrayList.add(iterator.next());
        while (iterator.hasNext()) {
            object3 = (TripleStore)iterator.next();
            string2 = object3.getName();
            comparable = new URI(string2);
            object2 = oWLModel.getRepositoryManager().getRepository((URI)comparable);
            if (object2 == null || !object2.isWritable((URI)comparable)) continue;
            arrayList.add(object3);
        }
        object3 = new HashMap();
        string2 = Protege2Jena.createOntModel(oWLModel, arrayList, (Map)object3);
        comparable = new File(uRI);
        object2 = oWLModel.getNamespaceManager().getDefaultNamespace();
        JenaOWLModel.save((File)comparable, (OntModel)string2, string, (String)object2);
        Iterator iterator2 = oWLModel.getTripleStoreModel().listUserTripleStores();
        iterator2.next();
        while (iterator2.hasNext()) {
            object = (TripleStore)iterator2.next();
            if (!arrayList.contains(object)) continue;
            Model model = (Model)object3.get(object);
            String string3 = object.getName();
            URI uRI2 = new URI(string3);
            Repository repository = oWLModel.getRepositoryManager().getRepository(uRI2);
            System.out.println("Saving import " + uRI2 + " to " + repository.getOntologyLocationDescription(uRI2));
            OutputStream outputStream = repository.getOutputStream(uRI2);
            JenaOWLModel.saveModel(outputStream, model, string, uRI2 + "#");
        }
        object = new RepositoryFileManager(oWLModel);
        ((RepositoryFileManager)object).saveGlobalRepositories();
        ((RepositoryFileManager)object).saveProjectRepositories(uRI);
        System.out.println("... saving successful.");
    }
}

