/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.parser;

import com.hp.hpl.jena.rdf.arp.ALiteral;
import com.hp.hpl.jena.rdf.arp.ARP;
import com.hp.hpl.jena.rdf.arp.ARPHandlers;
import com.hp.hpl.jena.rdf.arp.AResource;
import com.hp.hpl.jena.rdf.arp.NamespaceHandler;
import com.hp.hpl.jena.rdf.arp.StatementHandler;
import com.hp.hpl.jena.vocabulary.RDFS;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.MergingNarrowFrameStore;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.MessageError;
import edu.stanford.smi.protege.util.URIUtilities;
import edu.stanford.smi.protegex.owl.jena.Jena;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.jena.parser.DefaultProtegeOWLParserLogger;
import edu.stanford.smi.protegex.owl.jena.parser.DefaultURI2NameConverter;
import edu.stanford.smi.protegex.owl.jena.parser.DefaultUnresolvedImportHandler;
import edu.stanford.smi.protegex.owl.jena.parser.ImplicitImports;
import edu.stanford.smi.protegex.owl.jena.parser.ProtegeOWLParserLogger;
import edu.stanford.smi.protegex.owl.jena.parser.URI2NameConverter;
import edu.stanford.smi.protegex.owl.jena.parser.UnresolvedImportHandler;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFUntypedResource;
import edu.stanford.smi.protegex.owl.model.factory.OWLJavaFactoryUpdater;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLNamedClass;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLOntology;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFList;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFProperty;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFSLiteral;
import edu.stanford.smi.protegex.owl.model.patcher.DefaultOWLModelPatcher;
import edu.stanford.smi.protegex.owl.model.patcher.OWLModelPatcher;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreUtil;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.RDFListPostProcessor;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.RepositoryManager;
import edu.stanford.smi.protegex.owl.swrl.model.factory.SWRLJavaFactory;
import edu.stanford.smi.protegex.owl.ui.repository.UnresolvedImportUIHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ProtegeOWLParser {
    private static transient Logger log = Log.getLogger(ProtegeOWLParser.class);
    private String currentDefaultNamespace;
    private Frame currentType;
    private static Collection errors;
    private static URI errorOntologyURI;
    public static boolean inUI;
    private boolean isRDFList = false;
    private KnowledgeBase kb;
    private ProtegeOWLParserLogger logger;
    private Cls owlNamedClassClass;
    private OWLModel owlModel;
    private OWLModelPatcher patcher;
    private String prefixForDefaultNamespace;
    private RDFProperty rdfFirstProperty;
    private RDFProperty rdfRestProperty;
    private static final String RDFS_RESOURCE_URI;
    private RDFProperty rdfTypeProperty;
    private TripleStore tripleStore;
    private TripleStoreModel tripleStoreModel;
    private Collection tripleStores = new ArrayList();
    private Map untypedResources = new HashMap();
    private URI2NameConverter uri2NameConverter;
    private static UnresolvedImportHandler unresolvedImportHandler;
    private int tripleCount = 0;

    public ProtegeOWLParser(OWLModel oWLModel, boolean bl) {
        errorOntologyURI = null;
        errors = new ArrayList();
        this.owlModel = oWLModel;
        this.kb = oWLModel;
        this.tripleStoreModel = oWLModel.getTripleStoreModel();
        this.rdfTypeProperty = oWLModel.getRDFTypeProperty();
        this.rdfFirstProperty = oWLModel.getRDFFirstProperty();
        this.rdfRestProperty = oWLModel.getRDFRestProperty();
        if (bl) {
            this.populateUntypedResourcesMap();
        }
        this.logger = this.createLogger();
        this.owlNamedClassClass = oWLModel.getOWLNamedClassClass();
        this.uri2NameConverter = this.createURI2NameConverter(oWLModel, bl);
    }

    public void run(URI uRI) throws Exception {
        URL uRL = new URL(uRI.toString());
        this.run(ProtegeOWLParser.getInputStream(uRL), uRL.toString());
    }

    public void run(InputStream inputStream, String string) throws Exception {
        this.run(string, this.createARPInvokation(inputStream, string));
    }

    public void run(Reader reader, String string) throws Exception {
        this.run(string, this.createARPInvokation(reader, string));
    }

    protected void run(String string, ARPInvokation aRPInvokation) throws Exception {
        errors = new ArrayList();
        errorOntologyURI = null;
        this.loadTriples(this.owlModel.getTripleStoreModel().getActiveTripleStore(), string, aRPInvokation);
    }

    private ARPInvokation createARPInvokation(final InputStream inputStream, final String string) {
        ARPInvokation aRPInvokation = new ARPInvokation(){

            public void invokeARP(ARP aRP) throws Exception {
                aRP.load(inputStream, string);
                inputStream.close();
            }
        };
        return aRPInvokation;
    }

    private ARPInvokation createARPInvokation(final Reader reader, final String string) {
        ARPInvokation aRPInvokation = new ARPInvokation(){

            public void invokeARP(ARP aRP) throws Exception {
                aRP.getOptions().setDefaultErrorMode();
                aRP.load(reader, string);
                reader.close();
            }
        };
        return aRPInvokation;
    }

    public void loadTriples(TripleStore tripleStore, String string, ARPInvokation aRPInvokation) throws Exception {
        String string2;
        this.owlModel.setGenerateEventsEnabled(false);
        Log.getLogger().info("Loading triples");
        Set set = this.owlModel.getAllImports();
        this.addNamespaceToImports(string, set);
        this.currentDefaultNamespace = string;
        this.tripleStore = tripleStore;
        this.tripleStores.addAll(this.tripleStoreModel.getTripleStores());
        ARP aRP = this.createARP();
        long l = System.currentTimeMillis();
        OWLOntology oWLOntology = this.owlModel.getDefaultOWLOntology();
        if (tripleStore.contains(oWLOntology, this.owlModel.getRDFTypeProperty(), this.owlModel.getOWLOntologyClass())) {
            oWLOntology.delete();
        }
        errorOntologyURI = URIUtilities.createURI((String)string);
        aRPInvokation.invokeARP(aRP);
        if (this.owlModel.getRDFResource(":") == null) {
            this.createDefaultNamespace(tripleStore);
        }
        if ((string2 = this.owlModel.getNamespaceManager().getDefaultNamespace()) != null) {
            this.addNamespaceToImports(string2, set);
        }
        this.processImports(tripleStore, set);
        long l2 = System.currentTimeMillis();
        Log.getLogger().info("[ProtegeOWLParser] Completed triple loading after " + (l2 - l) + " ms");
        do {
            this.tripleStoreModel.setActiveTripleStore(tripleStore);
            this.owlModel.getNamespaceManager().update();
            this.owlModel.flushCache();
        } while (this.runImplicitImports(set));
        this.owlModel.setUndoEnabled(false);
        new RDFListPostProcessor(this.owlModel);
        this.tripleStoreModel.setActiveTripleStore(tripleStore);
        this.uri2NameConverter.updateInternalState();
        this.replaceTemporaryNames();
        this.owlModel.getNamespaceManager().update();
        this.tripleStoreModel.endTripleStoreChanges();
        TripleStoreUtil.updateFrameInclusion(MergingNarrowFrameStore.get((KnowledgeBase)this.owlModel), this.owlModel.getSlot(":NAME"));
        l2 = System.currentTimeMillis();
        this.activateSWRLFactoryIfNecessary(set);
        this.owlModel.setUndoEnabled(true);
        errorOntologyURI = null;
        Log.getLogger().info("... Loading completed after " + (System.currentTimeMillis() - l) + " ms");
        this.owlModel.setGenerateEventsEnabled(true);
    }

    private void activateSWRLFactoryIfNecessary(Set set) {
        if (set.contains("http://www.w3.org/2003/11/swrl")) {
            SWRLJavaFactory sWRLJavaFactory = new SWRLJavaFactory(this.owlModel);
            this.owlModel.setOWLJavaFactory(sWRLJavaFactory);
            if (this.owlModel instanceof JenaOWLModel) {
                OWLJavaFactoryUpdater.run((JenaOWLModel)this.owlModel);
            }
        }
    }

    public static void setUnresolvedImportHandler(UnresolvedImportHandler unresolvedImportHandler) {
        ProtegeOWLParser.unresolvedImportHandler = unresolvedImportHandler != null ? unresolvedImportHandler : new DefaultUnresolvedImportHandler();
    }

    private void addNamespaceToImports(String string, Set set) {
        if (Jena.namespaceEndsWithSeparator(string)) {
            set.add(string.substring(0, string.length() - 1));
        } else {
            set.add(string);
        }
    }

    protected ARP createARP() {
        ARP aRP = new ARP();
        ARPHandlers aRPHandlers = aRP.getHandlers();
        aRPHandlers.setStatementHandler((StatementHandler)new MyStatementHandler());
        aRPHandlers.setErrorHandler((ErrorHandler)new MyErrorHandler());
        aRPHandlers.setNamespaceHandler((NamespaceHandler)new MyNamespaceHandler());
        aRP.setHandlersWith(aRPHandlers);
        return aRP;
    }

    private void createDefaultNamespace(TripleStore tripleStore) {
        Slot slot = this.kb.getSlot(":OWL-ONTOLOGY-PREFIXES");
        RDFResource rDFResource = TripleStoreUtil.getFirstOntology(this.owlModel, tripleStore);
        String string = rDFResource.getName();
        if (this.uri2NameConverter.isTemporaryRDFResourceName(string)) {
            String string2 = this.uri2NameConverter.getURIFromTemporaryName(string);
            string2 = Jena.getNamespaceFromURI(string2);
            String string3 = ":" + string2;
            List list = rDFResource.getDirectOwnSlotValues(slot);
            if (!list.contains(string3)) {
                this.uri2NameConverter.addPrefix(string2, "");
                for (String string4 : new ArrayList(list)) {
                    if (!string4.startsWith(":")) continue;
                    rDFResource.removeOwnSlotValue(slot, string4);
                }
                rDFResource.addOwnSlotValue(slot, ":" + string2);
            }
        }
    }

    private Object createLiteralObject(ALiteral aLiteral, RDFProperty rDFProperty) {
        DefaultRDFSLiteral defaultRDFSLiteral = (DefaultRDFSLiteral)this.createRDFSLiteral(aLiteral, rDFProperty);
        Object object = defaultRDFSLiteral.getPlainValue();
        if (object != null) {
            return object;
        }
        return defaultRDFSLiteral.getRawValue();
    }

    protected ProtegeOWLParserLogger createLogger() {
        return new DefaultProtegeOWLParserLogger();
    }

    protected OWLModelPatcher createPatcher() {
        return new DefaultOWLModelPatcher(this.owlModel);
    }

    private RDFSLiteral createRDFSLiteral(ALiteral aLiteral, RDFProperty rDFProperty) {
        if (aLiteral.getLang() != null && aLiteral.getLang().length() > 0) {
            return this.owlModel.createRDFSLiteral(aLiteral.toString(), aLiteral.getLang());
        }
        if (aLiteral.getDatatypeURI() != null) {
            RDFSDatatype rDFSDatatype = this.owlModel.getRDFSDatatypeByURI(aLiteral.getDatatypeURI());
            if (rDFSDatatype == null) {
                return this.owlModel.createRDFSLiteral(aLiteral.toString());
            }
            return this.owlModel.createRDFSLiteral(aLiteral.toString(), rDFSDatatype);
        }
        RDFResource rDFResource = rDFProperty.getRange();
        if (rDFResource instanceof RDFSDatatype) {
            RDFSDatatype rDFSDatatype = this.owlModel.getRDFSDatatypeByURI(rDFResource.getURI());
            return this.owlModel.createRDFSLiteral(aLiteral.toString(), rDFSDatatype);
        }
        return this.owlModel.createRDFSLiteral(aLiteral.toString());
    }

    private RDFResource createRDFResource(String string) {
        FrameID frameID = this.tripleStore.generateFrameID();
        RDFResource rDFResource = null;
        rDFResource = this.owlNamedClassClass.equals(this.currentType) ? new DefaultOWLNamedClass(this.owlModel, frameID) : (this.isRDFList ? new DefaultRDFList(this.owlModel, frameID) : new DefaultRDFProperty(this.owlModel, frameID));
        if (string == null) {
            string = this.owlModel.getNextAnonymousResourceName();
        }
        this.tripleStore.setRDFResourceName(rDFResource, string);
        return rDFResource;
    }

    protected URI2NameConverter createURI2NameConverter(OWLModel oWLModel, boolean bl) {
        return new DefaultURI2NameConverter(oWLModel, this.logger, bl);
    }

    public static URI getErrorURI() {
        return errorOntologyURI;
    }

    private RDFResource findResource(String string) {
        for (TripleStore tripleStore : this.tripleStores) {
            RDFResource rDFResource = tripleStore.getHomeResource(string);
            if (rDFResource == null) continue;
            return rDFResource;
        }
        return null;
    }

    protected String getImplicitImport(String string) {
        if (ImplicitImports.isImplicitImport(string)) {
            return string;
        }
        return null;
    }

    protected ProtegeOWLParserLogger getLogger() {
        return this.logger;
    }

    private RDFProperty getRDFProperty(AResource aResource) {
        return (RDFProperty)this.getRDFResource(aResource);
    }

    private RDFResource getRDFResource(AResource aResource) {
        RDFResource rDFResource;
        Object object;
        String string;
        String string2 = string = aResource.isAnonymous() ? aResource.getAnonymousID() : aResource.getURI();
        if (string.equals(RDFS_RESOURCE_URI)) {
            return this.owlModel.getOWLThingClass();
        }
        if (!this.untypedResources.isEmpty() && !aResource.isAnonymous() && (object = (RDFUntypedResource)this.untypedResources.get(string)) != null) {
            return object;
        }
        object = this.uri2NameConverter.getTemporaryRDFResourceName(aResource);
        RDFResource rDFResource2 = this.findResource((String)object);
        if (rDFResource2 != null) {
            return rDFResource2;
        }
        Object object2 = this.uri2NameConverter.getRDFResourceName(string);
        if (object2 == null) {
            object2 = object;
        }
        if ((rDFResource = this.findResource((String)object2)) == null) {
            rDFResource = this.createRDFResource((String)object2);
        }
        return rDFResource;
    }

    private Collection getUntypedResources() {
        ArrayList<RDFResource> arrayList = new ArrayList<RDFResource>();
        Iterator iterator = this.owlModel.getTripleStoreModel().listUserTripleStores();
        while (iterator.hasNext()) {
            TripleStore tripleStore = (TripleStore)iterator.next();
            Iterator iterator2 = tripleStore.listHomeResources();
            while (iterator2.hasNext()) {
                RDFResource rDFResource = (RDFResource)iterator2.next();
                if (!rDFResource.getRDFTypes().isEmpty()) continue;
                arrayList.add(rDFResource);
            }
        }
        return arrayList;
    }

    private void populateUntypedResourcesMap() {
        RDFSNamedClass rDFSNamedClass = this.owlModel.getRDFUntypedResourcesClass();
        for (RDFUntypedResource rDFUntypedResource : rDFSNamedClass.getInstances(false)) {
            String string = rDFUntypedResource.getURI();
            this.untypedResources.put(string, rDFUntypedResource);
        }
    }

    private void replaceNamespace(TripleStore tripleStore, RDFResource rDFResource, String string, String string2) {
        RDFProperty rDFProperty = rDFResource.getOWLModel().getRDFProperty(":OWL-ONTOLOGY-PREFIXES");
        Collection collection = rDFResource.getPropertyValues(rDFProperty);
        for (String string3 : collection) {
            if (!string3.startsWith(string + ":")) continue;
            rDFResource.removePropertyValue(rDFProperty, string3);
        }
        tripleStore.add(rDFResource, rDFProperty, string + ":" + string2);
    }

    private void replaceTemporaryNames() {
        TripleStore tripleStore = this.tripleStoreModel.getActiveTripleStore();
        Iterator iterator = this.owlModel.getTripleStoreModel().listUserTripleStores();
        while (iterator.hasNext()) {
            TripleStore tripleStore2 = (TripleStore)iterator.next();
            this.tripleStoreModel.setActiveTripleStore(tripleStore2);
            this.replaceTemporaryNames(tripleStore2);
        }
        this.tripleStoreModel.setActiveTripleStore(tripleStore);
    }

    private void replaceTemporaryNames(TripleStore tripleStore) {
        String string;
        Set set = Jena.set(tripleStore.listHomeResources());
        OWLNamedClass oWLNamedClass = this.owlModel.getOWLOntologyClass();
        boolean bl = false;
        for (Object object : set) {
            String string2;
            if (!object.hasRDFType(oWLNamedClass) || !this.uri2NameConverter.isTemporaryRDFResourceName(string2 = object.getName())) continue;
            string = this.uri2NameConverter.getURIFromTemporaryName(string2);
            string = Jena.getNamespaceFromURI(string);
            string2 = this.uri2NameConverter.getTemporaryRDFResourceName(string);
            this.replaceTemporaryName(tripleStore, (RDFResource)object, string2, true);
            bl = true;
        }
        if (bl) {
            this.owlModel.flushCache();
            this.owlModel.getNamespaceManager().update();
            this.uri2NameConverter.updateInternalState();
        }
        Slot slot = this.kb.getSlot(":DIRECT-TYPE");
        for (String string2 : set) {
            if (string2.isSystem()) continue;
            string = string2.getName();
            if (string2.getDirectOwnSlotValues(slot).isEmpty()) {
                String string3;
                string2.getDirectOwnSlotValues(slot);
                if (string2 instanceof RDFProperty && !tripleStore.getNarrowFrameStore().getFramesWithAnyValue((Slot)string2, null, false).isEmpty()) {
                    if (this.uri2NameConverter.isTemporaryRDFResourceName(string)) {
                        this.replaceTemporaryName(tripleStore, (RDFResource)((Object)string2), string, false);
                    }
                    tripleStore.add((RDFResource)((Object)string2), this.owlModel.getRDFTypeProperty(), this.owlModel.getRDFPropertyClass());
                    continue;
                }
                if (tripleStore.listSubjects(this.owlModel.getRDFSRangeProperty(), string2).hasNext() || tripleStore.listSubjects(this.owlModel.getRDFSDomainProperty(), string2).hasNext() || tripleStore.listSubjects(this.owlModel.getRDFSSubClassOfProperty(), string2).hasNext()) {
                    if (this.uri2NameConverter.isTemporaryRDFResourceName(string)) {
                        this.replaceTemporaryName(tripleStore, (RDFResource)((Object)string2), string, false);
                    }
                    tripleStore.add((RDFResource)((Object)string2), this.owlModel.getRDFTypeProperty(), this.owlModel.getRDFSNamedClassClass());
                    continue;
                }
                string2.setDirectType(this.kb.getCls("protege:ExternalResource"));
                RDFUntypedResource rDFUntypedResource = (RDFUntypedResource)this.kb.getFrame(string);
                if (this.uri2NameConverter.isTemporaryRDFResourceName(string)) {
                    string3 = this.uri2NameConverter.getURIFromTemporaryName(string);
                    this.owlModel.getOWLFrameStore().setFrameName((Frame)rDFUntypedResource, string3);
                    continue;
                }
                string3 = this.owlModel.getURIForResourceName(string);
                if (string3 == null || string.equals(string3)) continue;
                this.owlModel.getOWLFrameStore().setFrameName((Frame)rDFUntypedResource, string3);
                continue;
            }
            if (!this.uri2NameConverter.isTemporaryRDFResourceName(string)) continue;
            this.replaceTemporaryName(tripleStore, (RDFResource)((Object)string2), string, false);
        }
        this.owlModel.flushCache();
    }

    private void replaceTemporaryName(TripleStore tripleStore, RDFResource rDFResource, String string, boolean bl) {
        if (this.uri2NameConverter.isAnonymousRDFResourceName(string)) {
            String string2 = this.uri2NameConverter.createAnonymousRDFResourceName();
            tripleStore.setRDFResourceName(rDFResource, string2);
        } else {
            String string3 = this.uri2NameConverter.getURIFromTemporaryName(string);
            String string4 = this.uri2NameConverter.getRDFResourceName(string3);
            if (string4 == null) {
                if (bl) {
                    string3 = Jena.getNamespaceFromURI(string3);
                }
                String string5 = this.uri2NameConverter.createNewPrefix(string3);
                String string6 = this.uri2NameConverter.getResourceNamespace(string3);
                string4 = this.uri2NameConverter.getRDFResourceName(string3);
                RDFResource rDFResource2 = TripleStoreUtil.getFirstOntology(this.owlModel, tripleStore);
                this.replaceNamespace(tripleStore, rDFResource2, string5, string6);
                if (string4 == null) {
                    string6 = this.uri2NameConverter.getResourceNamespace(string3);
                    string5 = this.uri2NameConverter.createNewPrefix(string6);
                    this.replaceNamespace(tripleStore, rDFResource2, string5, string6);
                    string4 = this.uri2NameConverter.getRDFResourceName(string3);
                }
            }
            tripleStore.setRDFResourceName(rDFResource, string4);
        }
    }

    private boolean runImplicitImports(Set set) throws Exception {
        long l = System.currentTimeMillis();
        HashSet<RDFProperty> hashSet = new HashSet<RDFProperty>();
        hashSet.add(this.owlModel.getRDFSSubPropertyOfProperty());
        hashSet.add(this.owlModel.getRDFSSubClassOfProperty());
        hashSet.add(this.owlModel.getRDFSRangeProperty());
        hashSet.add(this.owlModel.getRDFSDomainProperty());
        hashSet.add(this.owlModel.getRDFTypeProperty());
        hashSet.add(this.owlModel.getRDFProperty("owl:onProperty"));
        Collection collection = this.getUntypedResources();
        for (RDFResource rDFResource : collection) {
            Object object2;
            for (Object object2 : this.kb.getReferences((Object)rDFResource, 1000)) {
                if (!hashSet.contains(object2.getSlot()) || !this.runImplicitImport(rDFResource, set, collection)) continue;
                return true;
            }
            object2 = new DefaultRDFProperty(this.owlModel, rDFResource.getFrameID());
            Iterator iterator = this.owlModel.getHeadFrameStore().getFramesWithAnyDirectOwnSlotValue((Slot)object2).iterator();
            if (!iterator.hasNext() || !this.runImplicitImport(rDFResource, set, collection)) continue;
            return true;
        }
        long l2 = System.currentTimeMillis();
        return false;
    }

    private boolean runImplicitImport(RDFResource rDFResource, Set set, Collection collection) throws Exception {
        String string;
        String string2 = rDFResource.getURI();
        if (this.uri2NameConverter.isTemporaryRDFResourceName(string2)) {
            string2 = this.uri2NameConverter.getURIFromTemporaryName(string2);
        }
        if ((string = this.owlModel.getNamespaceForURI(string2)) != null) {
            String string3 = string;
            if (string3.endsWith("#")) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            if (!set.contains(string3)) {
                String string4 = this.getImplicitImport(string3);
                if (string4 != null) {
                    this.logger.logWarning("Trying to add import for external resource: " + string4);
                    this.runImport(string4, set);
                    return true;
                }
                if (this.patcher == null) {
                    this.patcher = this.createPatcher();
                }
                if (this.patcher != null) {
                    this.patcher.patch(collection.iterator(), string);
                }
                set.add(string3);
            }
        }
        return false;
    }

    private void processImports(TripleStore tripleStore, Set set) throws Exception {
        this.prefixForDefaultNamespace = null;
        RDFProperty rDFProperty = this.owlModel.getRDFProperty("owl:imports");
        Iterator iterator = tripleStore.listSubjects(rDFProperty);
        while (iterator.hasNext()) {
            RDFResource rDFResource = (RDFResource)iterator.next();
            Iterator iterator2 = rDFResource.listPropertyValues(rDFProperty);
            while (iterator2.hasNext()) {
                Instance instance = (Instance)iterator2.next();
                String string = instance.getName();
                String string2 = null;
                if (this.uri2NameConverter.isTemporaryRDFResourceName(string)) {
                    string2 = this.uri2NameConverter.getURIFromTemporaryName(string);
                } else if (instance instanceof RDFResource) {
                    string2 = ((RDFResource)instance).getURI();
                }
                if (string2 == null) continue;
                this.runImport(string2, set);
            }
        }
    }

    private void runImport(String string, Set set) throws Exception {
        if (!set.contains(string)) {
            set.add(string);
            URI uRI = null;
            try {
                uRI = new URI(string);
            }
            catch (Exception exception) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
            }
            Repository repository = ProtegeOWLParser.getRepository(this.owlModel, this.tripleStore, uRI);
            if (repository != null) {
                this.currentDefaultNamespace = string;
                this.tripleStore = this.tripleStoreModel.createTripleStore(string);
                this.tripleStores.add(this.tripleStore);
                this.tripleStoreModel.setActiveTripleStore(this.tripleStore);
                ARP aRP = this.createARP();
                this.logger.logImport(string, repository.getOntologyLocationDescription(uRI));
                InputStream inputStream = repository.getInputStream(uRI);
                if (inputStream != null) {
                    errorOntologyURI = uRI;
                    aRP.load(inputStream, string);
                    this.processImports(this.tripleStore, set);
                } else {
                    this.logger.logWarning("Couldn't get an input stream to read " + string + " from.");
                }
            } else {
                this.logger.logWarning("Ignoring import " + string);
            }
        }
    }

    public void setLogger(ProtegeOWLParserLogger protegeOWLParserLogger) {
        this.logger = protegeOWLParserLogger;
    }

    private void setPrefixForDefaultNamespace(String string) {
        this.prefixForDefaultNamespace = string;
    }

    public void setURI2NameConverter(URI2NameConverter uRI2NameConverter) {
        this.uri2NameConverter = uRI2NameConverter;
    }

    public static Collection getErrors() {
        return errors;
    }

    public static void addImport(JenaOWLModel jenaOWLModel, URI uRI) throws Exception {
        ProtegeOWLParser.addImport(jenaOWLModel, uRI, null);
    }

    public static void addImport(JenaOWLModel jenaOWLModel, URI uRI, String string) throws Exception {
        TripleStore tripleStore = jenaOWLModel.getTripleStoreModel().getActiveTripleStore();
        Repository repository = ProtegeOWLParser.getRepository(jenaOWLModel, tripleStore, uRI);
        if (repository != null) {
            TripleStore tripleStore2 = jenaOWLModel.getTripleStoreModel().createTripleStore(uRI.toString());
            ProtegeOWLParser protegeOWLParser = new ProtegeOWLParser(jenaOWLModel, true);
            if (string != null) {
                protegeOWLParser.setPrefixForDefaultNamespace(string);
            }
            InputStream inputStream = repository.getInputStream(uRI);
            protegeOWLParser.loadTriples(tripleStore2, uRI.toString(), protegeOWLParser.createARPInvokation(inputStream, uRI.toString()));
            jenaOWLModel.getTripleStoreModel().setActiveTripleStore(tripleStore);
            jenaOWLModel.getOWLFrameStore().copyFacetValuesIntoNamedClses();
        }
    }

    private static Repository getRepository(OWLModel oWLModel, TripleStore tripleStore, URI uRI) {
        RepositoryManager repositoryManager = oWLModel.getRepositoryManager();
        Repository repository = repositoryManager.getRepository(uRI, true);
        if (repository == null && (repository = unresolvedImportHandler.handleUnresolvableImport(oWLModel, tripleStore, uRI)) != null) {
            repositoryManager.addProjectRepository(0, repository);
        }
        return repository;
    }

    public static InputStream getInputStream(URL uRL) throws IOException {
        if (uRL.getProtocol().equals("http")) {
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setRequestProperty("Accept", "application/rdf+xml");
            uRLConnection.addRequestProperty("Accept", "text/xml");
            uRLConnection.addRequestProperty("Accept", "*/*");
            return uRLConnection.getInputStream();
        }
        return uRL.openStream();
    }

    static {
        inUI = false;
        RDFS_RESOURCE_URI = RDFS.Resource.getURI();
        unresolvedImportHandler = new UnresolvedImportUIHandler();
    }

    public static interface ARPInvokation {
        public void invokeARP(ARP var1) throws Exception;
    }

    private class MyStatementHandler
    implements StatementHandler {
        private MyStatementHandler() {
        }

        public void statement(AResource aResource, AResource aResource2, AResource aResource3) {
            RDFProperty rDFProperty = ProtegeOWLParser.this.getRDFProperty(aResource2);
            if (ProtegeOWLParser.this.rdfRestProperty.equals(rDFProperty)) {
                ProtegeOWLParser.this.isRDFList = true;
            }
            RDFResource rDFResource = ProtegeOWLParser.this.getRDFResource(aResource3);
            if (rDFProperty.equals(ProtegeOWLParser.this.rdfTypeProperty)) {
                ProtegeOWLParser.this.currentType = (Frame)rDFResource;
            }
            ProtegeOWLParser.this.isRDFList = ProtegeOWLParser.this.rdfFirstProperty.equals(rDFProperty) || ProtegeOWLParser.this.rdfRestProperty.equals(rDFProperty);
            RDFResource rDFResource2 = ProtegeOWLParser.this.getRDFResource(aResource);
            ProtegeOWLParser.this.isRDFList = false;
            ProtegeOWLParser.this.currentType = null;
            if (!ProtegeOWLParser.this.tripleStoreModel.getPropertyValues(rDFResource2, rDFProperty).contains(rDFResource)) {
                ProtegeOWLParser.this.tripleStore.add(rDFResource2, rDFProperty, rDFResource);
                ProtegeOWLParser.this.logger.logTripleAdded(rDFResource2, rDFProperty, rDFResource);
                ProtegeOWLParser.this.tripleCount++;
                if (ProtegeOWLParser.this.tripleCount % 5000 == 0) {
                    Log.getLogger().info("Loaded " + ProtegeOWLParser.this.tripleCount + " triples");
                }
            }
        }

        public void statement(AResource aResource, AResource aResource2, ALiteral aLiteral) {
            RDFResource rDFResource = ProtegeOWLParser.this.getRDFResource(aResource);
            RDFProperty rDFProperty = ProtegeOWLParser.this.getRDFProperty(aResource2);
            Object object = ProtegeOWLParser.this.createLiteralObject(aLiteral, rDFProperty);
            ProtegeOWLParser.this.tripleStore.add(rDFResource, rDFProperty, object);
            ProtegeOWLParser.this.logger.logTripleAdded(rDFResource, rDFProperty, object);
            ProtegeOWLParser.this.tripleCount++;
            if (ProtegeOWLParser.this.tripleCount % 5000 == 0) {
                Log.getLogger().info("Loaded " + ProtegeOWLParser.this.tripleCount + " triples");
            }
        }
    }

    private class MyNamespaceHandler
    implements NamespaceHandler {
        private RDFResource ontology;
        private Map prefix2Namespace = new HashMap();

        private MyNamespaceHandler() {
        }

        public void startPrefixMapping(String string, String string2) {
            if (!(string2.endsWith("#") || string2.endsWith("/") || string2.endsWith(":"))) {
                ProtegeOWLParser.this.logger.logWarning("Invalid namespace \"" + string2 + "\" for prefix \"" + string + "\" ignored.");
            } else {
                if (ProtegeOWLParser.this.prefixForDefaultNamespace != null && string.length() == 0) {
                    ProtegeOWLParser.this.owlModel.getNamespaceManager().setPrefix(string2, ProtegeOWLParser.this.prefixForDefaultNamespace);
                    string = ProtegeOWLParser.this.prefixForDefaultNamespace;
                    ProtegeOWLParser.this.prefixForDefaultNamespace = null;
                }
                string = ProtegeOWLParser.this.uri2NameConverter.addPrefix(string2, string);
                this.prefix2Namespace.put(string, string2);
            }
        }

        public void endPrefixMapping(String string) {
            String string2;
            if (this.ontology == null) {
                this.ontology = TripleStoreUtil.getFirstOntology(ProtegeOWLParser.this.owlModel, ProtegeOWLParser.this.tripleStore);
                if (this.ontology == null) {
                    string2 = (String)this.prefix2Namespace.get("");
                    if (string2 == null) {
                        ProtegeOWLParser.this.logger.logWarning("No default namespace found in file.  Will use " + ProtegeOWLParser.this.currentDefaultNamespace);
                        string2 = ProtegeOWLParser.this.currentDefaultNamespace;
                        this.prefix2Namespace.put("", string2);
                    }
                    FrameID frameID = ProtegeOWLParser.this.tripleStore.generateFrameID();
                    this.ontology = new DefaultOWLOntology(ProtegeOWLParser.this.owlModel, frameID);
                    String string3 = ProtegeOWLParser.this.uri2NameConverter.getTemporaryRDFResourceName(string2);
                    ProtegeOWLParser.this.tripleStore.setRDFResourceName(this.ontology, string3);
                    ProtegeOWLParser.this.tripleStore.add(this.ontology, ProtegeOWLParser.this.owlModel.getRDFTypeProperty(), ProtegeOWLParser.this.owlModel.getOWLOntologyClass());
                    ProtegeOWLParser.this.tripleStore.getNarrowFrameStore().addValues((Frame)this.ontology, ProtegeOWLParser.this.owlModel.getSlot(":OWL-ONTOLOGY-PREFIXES"), null, false, Collections.singleton(":" + string2));
                }
            }
            if ((string2 = (String)this.prefix2Namespace.get(string)) != null) {
                ProtegeOWLParser.this.replaceNamespace(ProtegeOWLParser.this.tripleStore, this.ontology, string, string2);
                ProtegeOWLParser.this.owlModel.getNamespaceManager().update();
            }
        }
    }

    private class MyErrorHandler
    implements ErrorHandler {
        private MyErrorHandler() {
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            this.saveErrors(sAXParseException);
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.saveErrors(sAXParseException);
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            this.saveErrors(sAXParseException, false);
        }

        protected void saveErrors(SAXParseException sAXParseException) {
            this.saveErrors(sAXParseException, true);
        }

        protected void saveErrors(SAXParseException sAXParseException, boolean bl) {
            String string = (bl ? "An error " : "A warning ") + "occurred at parsing the OWL ontology ";
            string = string + "\n\n    " + errorOntologyURI + "\n\n";
            string = string + "    at line " + sAXParseException.getLineNumber() + " and column " + sAXParseException.getColumnNumber() + ".\n";
            string = string + "    Jena parse error message: " + sAXParseException.getMessage();
            Log.getLogger().log(bl ? Level.SEVERE : Level.WARNING, string, sAXParseException);
            errors.add(new MessageError((Exception)sAXParseException, string));
        }
    }
}

