/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.parser;

import com.hp.hpl.jena.rdf.arp.AResource;
import com.hp.hpl.jena.rdf.model.impl.Util;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protegex.owl.jena.Jena;
import edu.stanford.smi.protegex.owl.jena.parser.ProtegeOWLParserLogger;
import edu.stanford.smi.protegex.owl.jena.parser.URI2NameConverter;
import edu.stanford.smi.protegex.owl.model.NamespaceManager;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.ProtegeNames;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLOntology;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DefaultURI2NameConverter
implements URI2NameConverter {
    private int externalResourceIndex = 1;
    private boolean firstDefaultNamespaceHandled = false;
    private ProtegeOWLParserLogger logger;
    private OWLModel owlModel;
    private Map prefix2URI = new HashMap();
    private Map uri2Prefix = new HashMap();
    private Set ontologyURIs;
    private static final String ANONYMOUS_PREFIX = "@";
    private static final String EXTERNAL_RESOURCE_PREFIX = "&";
    private static final String TEMPORARY_PREFIX = "^";
    private static final String PREFIX_BASE = "p";

    public DefaultURI2NameConverter(OWLModel oWLModel, ProtegeOWLParserLogger protegeOWLParserLogger, boolean bl) {
        this.owlModel = oWLModel;
        this.logger = protegeOWLParserLogger;
        this.firstDefaultNamespaceHandled = bl;
        this.updateInternalState();
        this.initPrefixesFromOWLModel();
    }

    /*
     * Enabled aggressive block sorting
     */
    public String addPrefix(String string, String string2) {
        String string3 = this.getNamespace(string2);
        if (string3 != null) {
            if (string2.length() == 0) {
                if (this.firstDefaultNamespaceHandled) return string2;
                this.addPrefixHelper(string, string2);
                this.firstDefaultNamespaceHandled = true;
                return string2;
            }
            if (string.equals(string3)) return string2;
            this.logger.logWarning("Conflicting prefix found " + string2 + ":" + "\n  Existing namespace: " + string3 + "\n  New namespace: " + string);
            return string2;
        }
        String string4 = this.getPrefix(string);
        if (string4 == null) {
            this.addPrefixHelper(string, string2);
            return string2;
        }
        if (string4.equals(string2)) return string2;
        if (this.isPreferredPrefix(string2, string)) {
            this.addPrefixHelper(string, string2);
            return string2;
        }
        if (string4.length() <= 0) return string4;
        this.logger.logWarning("Ignoring namespace prefix \"" + string2 + "\" for existing prefix \"" + string4 + "\"");
        return string4;
    }

    private void addPrefixHelper(String string, String string2) {
        this.uri2Prefix.put(string, string2);
        this.prefix2URI.put(string2, string);
    }

    public String createAnonymousRDFResourceName() {
        return this.owlModel.getNextAnonymousResourceName();
    }

    private String createNewPrefixHelper(String string) {
        String string2;
        int n = 1;
        do {
            string2 = PREFIX_BASE + n;
            ++n;
        } while (this.uri2Prefix.containsValue(string2));
        return string2;
    }

    public String createNewPrefix(String string) {
        int n = Util.splitNamespace((String)string);
        String string2 = string.substring(0, n);
        String string3 = this.createNewPrefixHelper(string2);
        this.addPrefixHelper(string2, string3);
        return string3;
    }

    private String getNamespace(String string) {
        return (String)this.prefix2URI.get(string);
    }

    private String getPrefix(String string) {
        return (String)this.uri2Prefix.get(string);
    }

    public String getRDFExternalResourceName() {
        String string;
        while (this.owlModel.getFrame(string = EXTERNAL_RESOURCE_PREFIX + this.externalResourceIndex++) != null) {
        }
        return string;
    }

    public String getRDFResourceName(String string) {
        String string2;
        String string3;
        if (this.ontologyURIs.contains(string)) {
            String string4 = this.getPrefix(string = Jena.getNamespaceFromURI(string));
            if (string4 == null) {
                return null;
            }
            return string4 + ":";
        }
        int n = string.lastIndexOf(35);
        if (n > 0 && n < string.length() - 1 && !this.owlModel.isValidResourceName(string3 = string.substring(n + 1), null)) {
            string3 = AbstractOWLModel.getValidOWLFrameName(null, string3);
            string = string.substring(0, n + 1) + string3;
        }
        int n2 = Util.splitNamespace((String)string);
        String string5 = string.substring(0, n2);
        String string6 = string.substring(n2);
        if (ProtegeNames.NS.equals(string5) && string6.length() > 0 && this.owlModel.getFrame(string2 = ":" + string6) != null) {
            return string2;
        }
        string2 = this.getPrefix(string5);
        if (string2 == null) {
            return null;
        }
        if (string2.length() == 0) {
            if (string6.length() == 0) {
                return ":";
            }
            return string6;
        }
        return string2 + ":" + string6;
    }

    public String getResourceNamespace(String string) {
        int n = Util.splitNamespace((String)string);
        return string.substring(0, n);
    }

    public String getTemporaryRDFResourceName(String string) {
        return TEMPORARY_PREFIX + string;
    }

    public String getTemporaryRDFResourceName(AResource aResource) {
        if (aResource.isAnonymous()) {
            return ANONYMOUS_PREFIX + aResource.toString();
        }
        return this.getTemporaryRDFResourceName(aResource.getURI());
    }

    public String getURIFromTemporaryName(String string) {
        return string.substring(TEMPORARY_PREFIX.length());
    }

    private void initPrefixesFromOWLModel() {
        NamespaceManager namespaceManager = this.owlModel.getNamespaceManager();
        this.addPrefixHelper(namespaceManager.getDefaultNamespace(), "");
        for (String string : namespaceManager.getPrefixes()) {
            String string2 = namespaceManager.getNamespaceForPrefix(string);
            this.addPrefixHelper(string2, string);
        }
    }

    public boolean isAnonymousRDFResourceName(String string) {
        return string.startsWith(ANONYMOUS_PREFIX);
    }

    protected boolean isPreferredPrefix(String string, String string2) {
        return string.equals("owl") || string.equals("rdf") || string.equals("rdfs") || string.equals("swrl");
    }

    public boolean isTemporaryRDFResourceName(String string) {
        return string.startsWith(TEMPORARY_PREFIX);
    }

    public void updateInternalState() {
        Object object;
        String string;
        Object object22;
        this.ontologyURIs = new HashSet();
        for (Object object22 : this.owlModel.getOWLOntologies()) {
            String string2;
            if (!(object22 instanceof RDFResource)) {
                object22 = new DefaultOWLOntology(this.owlModel, ((Frame)object22).getFrameID());
            }
            if ((string = (object = (RDFResource)object22).getName()).length() <= 0) continue;
            if (this.isTemporaryRDFResourceName(string)) {
                string2 = this.getURIFromTemporaryName(string);
                this.ontologyURIs.add(string2);
                continue;
            }
            string2 = object.getURI();
            this.ontologyURIs.add(string2);
        }
        ArrayList arrayList = new ArrayList(this.owlModel.getNamespaceManager().getPrefixes());
        arrayList.add("");
        object22 = arrayList.iterator();
        while (object22.hasNext()) {
            object = (String)object22.next();
            string = this.owlModel.getNamespaceManager().getNamespaceForPrefix((String)object);
            if (string == null) continue;
            if (string.endsWith("#") || string.endsWith(":")) {
                string = string.substring(0, string.length() - 1);
            }
            this.ontologyURIs.add(string);
        }
    }
}

