/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.export;

import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.plugin.ExportPlugin;
import edu.stanford.smi.protege.ui.ProjectView;
import edu.stanford.smi.protegex.owl.jena.JenaKnowledgeBaseFactory;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Component;
import java.net.URI;
import java.util.ArrayList;
import javax.swing.JFileChooser;

public abstract class AbstractJenaFileExportPlugin
implements ExportPlugin {
    private String lang;

    protected AbstractJenaFileExportPlugin(String string) {
        this.lang = string;
    }

    public void dispose() {
    }

    public String getName() {
        return this.lang;
    }

    public void handleExportRequest(Project project) {
        KnowledgeBase knowledgeBase = project.getKnowledgeBase();
        if (knowledgeBase instanceof JenaOWLModel) {
            JenaOWLModel jenaOWLModel = (JenaOWLModel)knowledgeBase;
            ArrayList arrayList = new ArrayList();
            JFileChooser jFileChooser = OWLUI.createJFileChooser(this.lang, JenaKnowledgeBaseFactory.getExtension(this.lang));
            if (jFileChooser.showSaveDialog(ProtegeUI.getTopLevelContainer(knowledgeBase.getProject())) == 0) {
                URI uRI = jFileChooser.getSelectedFile().toURI();
                jenaOWLModel.save(uRI, this.lang, arrayList);
                if (arrayList.isEmpty()) {
                    ProtegeUI.getModalDialogFactory().showMessageDialog(jenaOWLModel, "Successfully exported to " + uRI);
                } else {
                    ProtegeUI.getModalDialogFactory().showErrorMessageDialog(jenaOWLModel, "Could not export:\n" + arrayList.iterator().next());
                }
            }
        } else {
            ProjectView projectView = ProtegeUI.getProjectView(project);
            ProtegeUI.getModalDialogFactory().showMessageDialog((Component)projectView, "This function can only export OWL File projects.");
        }
    }
}

