/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.javacode;

import edu.stanford.smi.protegex.owl.javacode.RDFPropertyAtClassCode;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class RDFSClassCode {
    private RDFSNamedClass cls;

    public RDFSClassCode(RDFSNamedClass rDFSNamedClass) {
        this.cls = rDFSNamedClass;
    }

    public String getJavaName() {
        return RDFSClassCode.getValidJavaName(this.cls.getLocalName());
    }

    public List getPropertyCodes() {
        HashSet<RDFProperty> hashSet = new HashSet<RDFProperty>();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Collection collection = this.cls.getUnionDomainProperties();
        HashSet<RDFProperty> hashSet2 = new HashSet<RDFProperty>(collection);
        if (this.cls instanceof OWLNamedClass) {
            OWLNamedClass oWLNamedClass = (OWLNamedClass)this.cls;
            for (Object object : oWLNamedClass.getRestrictions()) {
                hashSet2.add(object.getOnProperty());
            }
        }
        for (RDFProperty rDFProperty : hashSet2) {
            Object object;
            hashSet.add(rDFProperty);
            object = new RDFPropertyAtClassCode(this.cls, rDFProperty);
            arrayList.add(object);
            Collection collection2 = rDFProperty.getSubproperties(true);
            for (RDFProperty rDFProperty2 : collection2) {
                if (rDFProperty2.isDomainDefined() || hashSet.contains(rDFProperty2)) continue;
                arrayList.add(new RDFPropertyAtClassCode(this.cls, rDFProperty2));
                hashSet.add(rDFProperty2);
            }
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public static String getValidJavaName(String string) {
        for (int i = 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isJavaIdentifierPart(c)) continue;
            string = string.replace(c, '_');
        }
        return string;
    }
}

