/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.ui;

import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecord;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecordRenderer;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.ReasonerTask;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class ReasonerProgressModalDialog
extends JDialog {
    private JButton okButton;
    private JButton cancelButton;
    private JProgressBar progBar;
    private JLabel messageLabel;
    private String description;
    private String message;
    private JTree tree;
    private DefaultMutableTreeNode root;
    private HashMap treeNodeMap;
    private ReasonerTask curTask;

    public ReasonerProgressModalDialog(Frame frame, String string) {
        super(frame, string, true);
        this.setDefaultCloseOperation(2);
        this.setSize(600, 500);
        this.setLocation(this.getToolkit().getScreenSize().width / 2 - this.getWidth() / 2, this.getToolkit().getScreenSize().height / 2 - this.getHeight() / 2);
        this.createUI();
    }

    private void createUI() {
        JPanel jPanel = new JPanel(new BorderLayout(7, 7));
        this.getContentPane().setLayout(new BorderLayout());
        this.createLogRecordTree(jPanel);
        this.createProgressPanel(jPanel);
        this.createButtonPanel(jPanel);
        this.getContentPane().add(jPanel);
        this.setupKeyClose();
    }

    private void createLogRecordTree(JPanel jPanel) {
        this.treeNodeMap = new HashMap();
        this.root = new DefaultMutableTreeNode("Reasoner log");
        this.tree = new JTree(new DefaultTreeModel(this.root));
        jPanel.add(new JScrollPane(this.tree));
        this.tree.setCellRenderer(new ReasonerLogRecordRenderer());
        this.tree.setRowHeight(0);
    }

    private void createProgressPanel(JPanel jPanel) {
        JPanel jPanel2 = new JPanel(new BorderLayout(7, 7));
        this.messageLabel = new JLabel();
        jPanel2.add((Component)this.messageLabel, "North");
        this.progBar = new JProgressBar();
        jPanel2.add((Component)this.progBar, "South");
        jPanel.add((Component)jPanel2, "North");
    }

    private void createButtonPanel(JPanel jPanel) {
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReasonerProgressModalDialog.this.closeDialog();
            }
        });
        this.okButton.setDefaultCapable(false);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ReasonerProgressModalDialog.this.curTask != null) {
                    ReasonerProgressModalDialog.this.curTask.setRequestAbort();
                }
                ReasonerProgressModalDialog.this.cancelButton.setEnabled(false);
            }
        });
        JPanel jPanel2 = new JPanel(new GridLayout(1, 0, 7, 7));
        jPanel2.add(this.cancelButton);
        jPanel2.add(this.okButton);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel2, "East");
        jPanel.add((Component)jPanel3, "South");
        jPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
    }

    private void setupKeyClose() {
        this.setFocusable(true);
        this.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    ReasonerProgressModalDialog.this.closeDialog();
                }
            }
        });
    }

    public void setMessage(String string) {
        this.message = string;
        this.updateLabel();
    }

    public void setDescription(String string) {
        this.description = string;
        this.updateLabel();
    }

    protected void updateLabel() {
        this.messageLabel.setText(this.description + ": " + this.message);
    }

    public void setOKButtonEnabled(boolean bl) {
        this.okButton.setEnabled(bl);
    }

    public void setCancelButtonEnabled(boolean bl) {
        this.cancelButton.setEnabled(bl);
    }

    public void setProgressBarMaxValue(int n) {
        this.progBar.setMaximum(n);
    }

    public void setProgress(int n) {
        if (this.progBar.isIndeterminate()) {
            this.progBar.setIndeterminate(false);
        }
        this.progBar.setValue(n);
    }

    public void setProgressIndeterminate(boolean bl) {
        this.progBar.setIndeterminate(bl);
    }

    public void postLogRecord(ReasonerLogRecord reasonerLogRecord) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(reasonerLogRecord);
        this.treeNodeMap.put(reasonerLogRecord, defaultMutableTreeNode);
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.treeNodeMap.get(reasonerLogRecord.getParent());
        if (defaultMutableTreeNode2 == null) {
            defaultMutableTreeNode2 = this.root;
        }
        defaultTreeModel.insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
        this.tree.expandPath(new TreePath(defaultMutableTreeNode2.getPath()));
        this.tree.scrollPathToVisible(new TreePath(this.root.getLastLeaf().getPath()));
        this.tree.updateUI();
    }

    public void setReasonerDescription(String string) {
        this.setTitle(string);
    }

    public void setTask(ReasonerTask reasonerTask) {
        this.curTask = reasonerTask;
    }

    private void closeDialog() {
        if (this.okButton.isEnabled()) {
            this.treeNodeMap.keySet().removeAll(this.treeNodeMap.keySet());
            this.root.removeAllChildren();
            this.dispose();
        }
    }
}

