/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.ui;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.ui.ProjectView;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.inference.dig.exception.DIGReasonerException;
import edu.stanford.smi.protegex.owl.inference.dig.reasoner.DIGReasonerIdentity;
import edu.stanford.smi.protegex.owl.inference.protegeowl.ProtegeOWLReasoner;
import edu.stanford.smi.protegex.owl.inference.protegeowl.ReasonerManager;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecord;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecordFactory;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogger;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLoggerListener;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLoggerUtil;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.WarningMessageLogRecord;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.ReasonerTaskEvent;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.ReasonerTaskListener;
import edu.stanford.smi.protegex.owl.inference.ui.ReasonerProgressModalDialog;
import edu.stanford.smi.protegex.owl.inference.ui.ReasonerWarningPanel;
import edu.stanford.smi.protegex.owl.inference.ui.RunnableReasonerAction;
import edu.stanford.smi.protegex.owl.inference.util.ReasonerPreferences;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.cls.OWLClassesTab;
import edu.stanford.smi.protegex.owl.ui.results.ResultsPanelManager;
import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class ReasonerActionRunner {
    private static transient Logger log = Log.getLogger(ReasonerActionRunner.class);
    private boolean showClassifierResults;
    private RunnableReasonerAction runner;
    private boolean journalingEnabled;

    public ReasonerActionRunner(RunnableReasonerAction runnableReasonerAction, boolean bl) {
        this.showClassifierResults = bl;
        this.runner = runnableReasonerAction;
    }

    public void execute() {
        final Project project = this.runner.getOWLModel().getProject();
        if (project != null) {
            this.journalingEnabled = project.isJournalingEnabled();
        }
        ProtegeOWLReasoner protegeOWLReasoner = ReasonerManager.getInstance().getReasoner(this.runner.getOWLModel());
        String string = ReasonerPreferences.getInstance().getReasonerURL();
        String string2 = protegeOWLReasoner.getDIGReasoner().getReasonerURL();
        if (!string2.equals(string)) {
            protegeOWLReasoner.setURL(string);
        }
        DIGReasonerIdentity dIGReasonerIdentity = protegeOWLReasoner.getIdentity();
        Component component = ProtegeUI.getTopLevelContainer(project);
        Frame frame = null;
        if (component instanceof Frame) {
            frame = (Frame)component;
        }
        String string3 = dIGReasonerIdentity != null ? "Connected to " + dIGReasonerIdentity.getName() + " " + dIGReasonerIdentity.getVersion() : "Could not obtain reasoner identity";
        final ReasonerProgressModalDialog reasonerProgressModalDialog = new ReasonerProgressModalDialog(frame, string3);
        ReasonerLoggerListenerBridge reasonerLoggerListenerBridge = new ReasonerLoggerListenerBridge(reasonerProgressModalDialog);
        ReasonerLogger.getInstance().addListener(reasonerLoggerListenerBridge);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (ReasonerActionRunner.this.showClassifierResults) {
                    ReasonerActionRunner.this.showInferredHierarchy(false);
                }
            }
        });
        Runnable runnable = new Runnable(){

            public void run() {
                block7: {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            reasonerProgressModalDialog.show();
                        }
                    });
                    try {
                        final ArrayList arrayList = new ArrayList();
                        boolean bl = ReasonerPreferences.getInstance().isShowWarningResultsPanel();
                        ReasonerLoggerListener reasonerLoggerListener = null;
                        ReasonerLogger reasonerLogger = ReasonerLogger.getInstance();
                        if (bl) {
                            reasonerLoggerListener = new ReasonerLoggerListener(){

                                public void logRecordPosted(ReasonerLogRecord reasonerLogRecord) {
                                    if (reasonerLogRecord instanceof WarningMessageLogRecord) {
                                        arrayList.add(ReasonerLoggerUtil.convertToOWLTestResult((WarningMessageLogRecord)reasonerLogRecord));
                                    }
                                }
                            };
                            reasonerLogger.addListener(reasonerLoggerListener);
                        }
                        ReasonerActionRunner.this.runner.executeReasonerActions(new ReasonerTaskListenerBridge(reasonerProgressModalDialog));
                        if (project != null) {
                            project.setJournalingEnabled(ReasonerActionRunner.this.journalingEnabled);
                        }
                        if (bl && arrayList.size() > 0) {
                            reasonerLogger.removeListener(reasonerLoggerListener);
                            reasonerLoggerListener = null;
                            ReasonerWarningPanel reasonerWarningPanel = new ReasonerWarningPanel(ReasonerActionRunner.this.runner.getOWLModel(), arrayList);
                            ResultsPanelManager.addResultsPanel(ReasonerActionRunner.this.runner.getOWLModel(), reasonerWarningPanel, true);
                        }
                        if (ReasonerActionRunner.this.showClassifierResults) {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    ReasonerActionRunner.this.showInferredHierarchy(true);
                                }
                            });
                        }
                    }
                    catch (DIGReasonerException dIGReasonerException) {
                        final DIGReasonerException dIGReasonerException2 = dIGReasonerException;
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                reasonerProgressModalDialog.setOKButtonEnabled(true);
                                reasonerProgressModalDialog.setProgressIndeterminate(false);
                                ReasonerLogger reasonerLogger = ReasonerLogger.getInstance();
                                ReasonerLogRecordFactory reasonerLogRecordFactory = ReasonerLogRecordFactory.getInstance();
                                ReasonerLogRecord reasonerLogRecord = reasonerLogRecordFactory.createDIGReasonerExceptionLogRecord(dIGReasonerException2, null);
                                reasonerLogger.postLogRecord(reasonerLogRecord);
                            }
                        });
                        if (!ReasonerActionRunner.this.runner.getOWLModel().getGenerateEventsEnabled()) {
                            ReasonerActionRunner.this.runner.getOWLModel().setGenerateEventsEnabled(true);
                        }
                        if (project == null) break block7;
                        project.setJournalingEnabled(ReasonerActionRunner.this.journalingEnabled);
                    }
                }
            }
        };
        try {
            Thread thread = new Thread(runnable);
            thread.start();
        }
        catch (Exception exception) {
            reasonerProgressModalDialog.setOKButtonEnabled(true);
            reasonerProgressModalDialog.setProgressIndeterminate(false);
            Log.emptyCatchBlock((Throwable)exception);
        }
    }

    protected void showInferredHierarchy(boolean bl) {
        ProjectView projectView = ProtegeUI.getProjectView(this.runner.getOWLModel().getProject());
        OWLClassesTab oWLClassesTab = (OWLClassesTab)projectView.getTabByClassName(OWLClassesTab.class.getName());
        if (oWLClassesTab != null) {
            if (bl) {
                ReasonerPreferences reasonerPreferences = ReasonerPreferences.getInstance();
                if (reasonerPreferences.isAutomaticallyShowInferredHierarchy()) {
                    oWLClassesTab.setInferredClsesVisible(true);
                }
                if (reasonerPreferences.isShowReasonerResultsPanel()) {
                    oWLClassesTab.refreshChangedClses();
                    oWLClassesTab.requestFocusInWindow();
                }
            } else {
                oWLClassesTab.setInferredClsesVisible(false);
            }
        }
    }

    private class ReasonerTaskListenerBridge
    implements ReasonerTaskListener {
        private ReasonerProgressModalDialog dlg;

        public ReasonerTaskListenerBridge(ReasonerProgressModalDialog reasonerProgressModalDialog) {
            this.dlg = reasonerProgressModalDialog;
        }

        public void addedToTask(final ReasonerTaskEvent reasonerTaskEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    int n = reasonerTaskEvent.getSource().getTaskSize();
                    ReasonerTaskListenerBridge.this.dlg.setTask(reasonerTaskEvent.getSource());
                    ReasonerTaskListenerBridge.this.dlg.setProgressIndeterminate(false);
                    ReasonerTaskListenerBridge.this.dlg.setProgressBarMaxValue(n);
                    ReasonerTaskListenerBridge.this.dlg.setCancelButtonEnabled(true);
                    ReasonerTaskListenerBridge.this.dlg.setOKButtonEnabled(false);
                }
            });
        }

        public void progressChanged(final ReasonerTaskEvent reasonerTaskEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    int n = reasonerTaskEvent.getSource().getProgress();
                    ReasonerTaskListenerBridge.this.dlg.setProgress(n);
                }
            });
        }

        public void progressIndeterminateChanged(final ReasonerTaskEvent reasonerTaskEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    boolean bl = reasonerTaskEvent.getSource().isProgressIndeterminate();
                    ReasonerTaskListenerBridge.this.dlg.setProgressIndeterminate(bl);
                }
            });
        }

        public void descriptionChanged(final ReasonerTaskEvent reasonerTaskEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String string = reasonerTaskEvent.getSource().getDescription();
                    ReasonerTaskListenerBridge.this.dlg.setDescription(string);
                }
            });
        }

        public void messageChanged(final ReasonerTaskEvent reasonerTaskEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String string = reasonerTaskEvent.getSource().getMessage();
                    ReasonerTaskListenerBridge.this.dlg.setMessage(string);
                }
            });
        }

        public void taskFailed(ReasonerTaskEvent reasonerTaskEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ReasonerTaskListenerBridge.this.dlg.setOKButtonEnabled(true);
                    ReasonerTaskListenerBridge.this.dlg.setCancelButtonEnabled(false);
                    ReasonerTaskListenerBridge.this.dlg.setProgressIndeterminate(false);
                }
            });
        }

        public void taskCompleted(ReasonerTaskEvent reasonerTaskEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ReasonerTaskListenerBridge.this.dlg.setOKButtonEnabled(true);
                    ReasonerTaskListenerBridge.this.dlg.setCancelButtonEnabled(false);
                }
            });
        }
    }

    private class ReasonerLoggerListenerBridge
    implements ReasonerLoggerListener {
        private ReasonerProgressModalDialog dlg;

        public ReasonerLoggerListenerBridge(ReasonerProgressModalDialog reasonerProgressModalDialog) {
            this.dlg = reasonerProgressModalDialog;
        }

        public void logRecordPosted(final ReasonerLogRecord reasonerLogRecord) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ReasonerLoggerListenerBridge.this.dlg.postLogRecord(reasonerLogRecord);
                }
            });
        }
    }
}

