/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.protegeowl.task;

import edu.stanford.smi.protegex.owl.inference.dig.exception.DIGReasonerException;
import edu.stanford.smi.protegex.owl.inference.dig.translator.DIGQueryResponse;
import edu.stanford.smi.protegex.owl.inference.protegeowl.ProtegeOWLReasoner;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecord;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecordFactory;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.AbstractReasonerTask;
import edu.stanford.smi.protegex.owl.inference.util.ReasonerUtil;
import edu.stanford.smi.protegex.owl.inference.util.TimeDifference;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import java.util.Collection;
import java.util.Iterator;
import org.w3c.dom.Document;

public class UpdateInconsistentClassesTask
extends AbstractReasonerTask {
    private ProtegeOWLReasoner protegeOWLReasoner;

    public UpdateInconsistentClassesTask(ProtegeOWLReasoner protegeOWLReasoner) {
        super(protegeOWLReasoner);
        this.protegeOWLReasoner = protegeOWLReasoner;
    }

    public int getTaskSize() {
        return ReasonerUtil.getInstance().getNamedClses(this.protegeOWLReasoner.getKnowledgeBase()).size();
    }

    public void run() throws DIGReasonerException {
        Object object2;
        OWLModel oWLModel = this.protegeOWLReasoner.getKnowledgeBase();
        ReasonerLogRecord reasonerLogRecord = ReasonerLogRecordFactory.getInstance().createInformationMessageLogRecord("Check concept consistency", null);
        this.postLogRecord(reasonerLogRecord);
        this.setProgress(0);
        TimeDifference timeDifference = new TimeDifference();
        this.setDescription("Computing inconsistent concepts");
        this.setMessage("Building reasoner query...");
        timeDifference.markStart();
        Document document = this.getTranslator().createAsksDocument(this.protegeOWLReasoner.getReasonerKnowledgeBaseURI());
        Collection collection = ReasonerUtil.getInstance().getNamedClses(oWLModel);
        for (Object object2 : collection) {
            this.getTranslator().createSatisfiableQuery(document, object2.getName(), (RDFSClass)object2);
            this.doAbortCheck();
        }
        timeDifference.markEnd();
        this.postLogRecord(ReasonerLogRecordFactory.getInstance().createInformationMessageLogRecord("Time to build query = " + timeDifference, reasonerLogRecord));
        timeDifference.markStart();
        this.setMessage("Querying reasoner for inconsistent concepts...");
        this.setProgressIndeterminate(true);
        object2 = this.protegeOWLReasoner.getDIGReasoner().performRequest(document);
        this.setProgressIndeterminate(false);
        this.doAbortCheck();
        timeDifference.markEnd();
        this.postLogRecord(ReasonerLogRecordFactory.getInstance().createInformationMessageLogRecord("Time to send and receive from reasoner = " + timeDifference, reasonerLogRecord));
        this.setMessage("Updating Protege-OWL...");
        timeDifference.markStart();
        oWLModel.setGenerateEventsEnabled(false);
        oWLModel.beginTransaction("Compute and mark inconsistent classes");
        Iterator iterator = this.getTranslator().getDIGQueryResponseIterator(oWLModel, (Document)object2);
        ReasonerLogRecord reasonerLogRecord2 = null;
        while (iterator.hasNext()) {
            this.doAbortCheck();
            DIGQueryResponse dIGQueryResponse = (DIGQueryResponse)iterator.next();
            String string = dIGQueryResponse.getID();
            OWLNamedClass oWLNamedClass = oWLModel.getOWLNamedClass(string);
            if (oWLNamedClass != null) {
                if (dIGQueryResponse.getBoolean()) {
                    oWLNamedClass.setClassificationStatus(1);
                    oWLNamedClass.removeInferredSuperclass(oWLNamedClass.getOWLModel().getOWLNamedClass("owl:Nothing"));
                } else {
                    if (reasonerLogRecord2 == null) {
                        reasonerLogRecord2 = ReasonerLogRecordFactory.getInstance().createInformationMessageLogRecord("Inconsistent concepts", reasonerLogRecord);
                        this.postLogRecord(reasonerLogRecord2);
                    }
                    this.postLogRecord(ReasonerLogRecordFactory.getInstance().createConceptConsistencyLogRecord(oWLNamedClass, false, reasonerLogRecord2));
                    oWLNamedClass.setClassificationStatus(2);
                    oWLNamedClass.addInferredSuperclass(oWLNamedClass.getOWLModel().getOWLNamedClass("owl:Nothing"));
                }
            }
            this.setProgress(this.getProgress() + 1);
        }
        timeDifference.markEnd();
        this.postLogRecord(ReasonerLogRecordFactory.getInstance().createInformationMessageLogRecord("Time to update Protege-OWL = " + timeDifference, reasonerLogRecord));
        this.setTaskCompleted();
        oWLModel.endTransaction();
        oWLModel.setGenerateEventsEnabled(true);
    }
}

