/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.protegeowl.task;

import edu.stanford.smi.protegex.owl.inference.dig.exception.DIGReasonerException;
import edu.stanford.smi.protegex.owl.inference.dig.translator.DIGQueryResponse;
import edu.stanford.smi.protegex.owl.inference.protegeowl.ProtegeOWLReasoner;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecord;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecordFactory;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.AbstractReasonerTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.BooleanResultReasonerTask;
import edu.stanford.smi.protegex.owl.inference.util.TimeDifference;
import edu.stanford.smi.protegex.owl.model.OWLClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import java.util.Iterator;
import org.w3c.dom.Document;

public class GetConceptSatisfiableTask
extends AbstractReasonerTask
implements BooleanResultReasonerTask {
    private OWLClass aClass;
    private ProtegeOWLReasoner protegeOWLReasoner;
    private boolean satisfiable;

    public GetConceptSatisfiableTask(OWLClass oWLClass, ProtegeOWLReasoner protegeOWLReasoner) {
        super(protegeOWLReasoner);
        this.aClass = oWLClass;
        this.protegeOWLReasoner = protegeOWLReasoner;
        this.satisfiable = true;
    }

    public int getTaskSize() {
        return 1;
    }

    public void run() throws DIGReasonerException {
        OWLModel oWLModel = this.protegeOWLReasoner.getKnowledgeBase();
        ReasonerLogRecordFactory reasonerLogRecordFactory = ReasonerLogRecordFactory.getInstance();
        ReasonerLogRecord reasonerLogRecord = reasonerLogRecordFactory.createInformationMessageLogRecord("Checking consistency of " + this.aClass.getBrowserText(), null);
        this.postLogRecord(reasonerLogRecord);
        this.setDescription("Computing consistency");
        this.setMessage("Building reasoner query...");
        Document document = this.getTranslator().createAsksDocument(this.protegeOWLReasoner.getReasonerKnowledgeBaseURI());
        this.getTranslator().createSatisfiableQuery(document, "q0", this.aClass);
        this.setMessage("Querying reasoner...");
        TimeDifference timeDifference = new TimeDifference();
        timeDifference.markStart();
        Document document2 = this.protegeOWLReasoner.getDIGReasoner().performRequest(document);
        timeDifference.markEnd();
        this.postLogRecord(reasonerLogRecordFactory.createInformationMessageLogRecord("Time to query reasoner = " + timeDifference, reasonerLogRecord));
        Iterator iterator = this.getTranslator().getDIGQueryResponseIterator(oWLModel, document2);
        if (iterator.hasNext()) {
            DIGQueryResponse dIGQueryResponse = (DIGQueryResponse)iterator.next();
            this.satisfiable = dIGQueryResponse.getBoolean();
        }
        this.postLogRecord(reasonerLogRecordFactory.createConceptConsistencyLogRecord(this.aClass, this.satisfiable, reasonerLogRecord));
        this.setProgress(1);
        this.setMessage("Finished");
        this.setTaskCompleted();
    }

    public boolean getResult() {
        return this.satisfiable;
    }
}

