/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.protegeowl;

import edu.stanford.smi.protege.event.ProjectAdapter;
import edu.stanford.smi.protege.event.ProjectEvent;
import edu.stanford.smi.protege.event.ProjectListener;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protegex.owl.inference.protegeowl.DefaultProtegeOWLReasoner;
import edu.stanford.smi.protegex.owl.inference.protegeowl.ProtegeOWLReasoner;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import java.util.HashMap;
import java.util.Map;

public class ReasonerManager {
    public Map reasonerMap;
    private static ReasonerManager instance;
    private ProjectListener projectListener = new ProjectAdapter(){

        public void projectClosed(ProjectEvent projectEvent) {
            Project project = (Project)projectEvent.getSource();
            project.removeProjectListener((ProjectListener)this);
            ReasonerManager.this.reasonerMap.remove(project.getKnowledgeBase());
        }
    };

    private ReasonerManager() {
        this.reasonerMap = new HashMap();
    }

    public static synchronized ReasonerManager getInstance() {
        if (instance == null) {
            instance = new ReasonerManager();
        }
        return instance;
    }

    public ProtegeOWLReasoner getReasoner(OWLModel oWLModel) {
        ProtegeOWLReasoner protegeOWLReasoner = (ProtegeOWLReasoner)this.reasonerMap.get(oWLModel);
        if (protegeOWLReasoner == null) {
            protegeOWLReasoner = new DefaultProtegeOWLReasoner(oWLModel);
            this.reasonerMap.put(oWLModel, protegeOWLReasoner);
            oWLModel.getProject().addProjectListener(this.projectListener);
        }
        return protegeOWLReasoner;
    }

    public ProtegeOWLReasoner getReasoner(OWLModel oWLModel, boolean bl) {
        return new DefaultProtegeOWLReasoner(oWLModel);
    }

    public ProtegeOWLReasoner createReasoner(OWLModel oWLModel) {
        return new DefaultProtegeOWLReasoner(oWLModel);
    }
}

