/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.dig.translator;

import edu.stanford.smi.protegex.owl.inference.dig.translator.DefaultDIGQueryResponse;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import java.util.Iterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DefaultDIGQueryResponseIterator
implements Iterator {
    private Document doc;
    private int currentElementIndex = 0;
    private NodeList nodeList;
    private boolean elementAvailable = false;
    private DefaultDIGQueryResponse interpreter;

    public DefaultDIGQueryResponseIterator(Document document, OWLModel oWLModel) {
        this.doc = document;
        this.nodeList = this.doc.getDocumentElement().getChildNodes();
        this.currentElementIndex = 0;
        this.interpreter = new DefaultDIGQueryResponse(oWLModel);
        this.advanceToNextElement();
    }

    public boolean hasNext() {
        return this.elementAvailable;
    }

    protected void advanceToNextElement() {
        int n = this.currentElementIndex;
        this.elementAvailable = true;
        while (this.nodeList.item(n).getNodeType() != 1 || this.nodeList.item(n).getNodeName().equals("error")) {
            if (n == this.nodeList.getLength() - 1) {
                this.elementAvailable = false;
                break;
            }
            ++n;
        }
        this.currentElementIndex = n;
    }

    public Object next() {
        Element element = (Element)this.nodeList.item(this.currentElementIndex);
        ++this.currentElementIndex;
        this.interpreter.setElement(element);
        this.advanceToNextElement();
        return this.interpreter;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

