/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.dig.translator;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import java.util.HashMap;

public class DIGDataTypes {
    public static final int REAL_MULTIPLIER = 10000;
    private static DIGDataTypes instance;
    private HashMap map = new HashMap();
    private HashMap rangeMap;

    protected DIGDataTypes(OWLModel oWLModel) {
        this.map.put(oWLModel.getXSDint(), new IntDataTypeMapEntry());
        this.map.put(oWLModel.getXSDinteger(), new IntDataTypeMapEntry());
        this.map.put(oWLModel.getXSDlong(), new IntDataTypeMapEntry());
        this.map.put(oWLModel.getXSDshort(), new IntDataTypeMapEntry());
        this.map.put(oWLModel.getXSDboolean(), new IntDataTypeMapEntry());
        this.map.put(oWLModel.getXSDstring(), new StringDataTypeMapEntry());
        this.map.put(oWLModel.getXSDtime(), new StringDataTypeMapEntry());
        this.map.put(oWLModel.getXSDanyURI(), new StringDataTypeMapEntry());
        this.map.put(oWLModel.getXSDbase64Binary(), new StringDataTypeMapEntry());
        this.map.put(oWLModel.getXSDdecimal(), new StringDataTypeMapEntry());
        this.map.put(oWLModel.getXSDbyte(), new StringDataTypeMapEntry());
        this.map.put(oWLModel.getXSDdouble(), new StringDataTypeMapEntry());
        this.map.put(oWLModel.getXSDduration(), new StringDataTypeMapEntry());
        this.map.put(oWLModel.getXSDdateTime(), new StringDataTypeMapEntry());
        this.map.put(oWLModel.getXSDdate(), new StringDataTypeMapEntry());
    }

    public static synchronized DIGDataTypes getInstance(OWLModel oWLModel) {
        if (instance == null) {
            instance = new DIGDataTypes(oWLModel);
        }
        return instance;
    }

    public boolean isSupported(RDFSDatatype rDFSDatatype) {
        return this.map.containsKey(rDFSDatatype);
    }

    public boolean isSupported(RDFSLiteral rDFSLiteral) {
        return this.map.containsKey(rDFSLiteral.getDatatype());
    }

    public String getIndividualAxiomValueTagName(RDFSLiteral rDFSLiteral) {
        String string = null;
        DataTypeMapEntry dataTypeMapEntry = (DataTypeMapEntry)this.map.get(rDFSLiteral.getDatatype());
        if (dataTypeMapEntry != null) {
            string = dataTypeMapEntry.getValueTag();
        }
        return string;
    }

    public String getPropertyRangeTagName(RDFSDatatype rDFSDatatype) {
        String string = null;
        DataTypeMapEntry dataTypeMapEntry = (DataTypeMapEntry)this.map.get(rDFSDatatype);
        if (dataTypeMapEntry != null) {
            string = dataTypeMapEntry.getRangeTag();
        }
        return string;
    }

    public String getConcreteDomainExpressionTagName(RDFSLiteral rDFSLiteral) {
        String string = null;
        DataTypeMapEntry dataTypeMapEntry = (DataTypeMapEntry)this.map.get(rDFSLiteral.getDatatype());
        if (dataTypeMapEntry != null) {
            string = dataTypeMapEntry.getValueRestrictionTag();
        }
        return string;
    }

    public String getDataTypeRendering(RDFSLiteral rDFSLiteral) {
        DataTypeMapEntry dataTypeMapEntry = (DataTypeMapEntry)this.map.get(rDFSLiteral.getDatatype());
        if (dataTypeMapEntry != null) {
            return dataTypeMapEntry.getRenderering(rDFSLiteral);
        }
        return null;
    }

    private class StringDataTypeMapEntry
    extends DataTypeMapEntry {
        public StringDataTypeMapEntry() {
            super("sval", "rangestring", "stringequals");
        }

        public String getRenderering(RDFSLiteral rDFSLiteral) {
            return rDFSLiteral.getString();
        }
    }

    private class IntDataTypeMapEntry
    extends DataTypeMapEntry {
        public IntDataTypeMapEntry() {
            super("ival", "rangeint", "intequals");
        }

        public String getRenderering(RDFSLiteral rDFSLiteral) {
            return rDFSLiteral.getString();
        }
    }

    private abstract class DataTypeMapEntry {
        private String valueTag;
        private String rangeTag;
        private String valueRestrictionTag;

        public DataTypeMapEntry(String string, String string2, String string3) {
            this.valueTag = string;
            this.rangeTag = string2;
            this.valueRestrictionTag = string3;
        }

        public String getValueTag() {
            return this.valueTag;
        }

        public String getRangeTag() {
            return this.rangeTag;
        }

        public String getValueRestrictionTag() {
            return this.valueRestrictionTag;
        }

        public abstract String getRenderering(RDFSLiteral var1);
    }
}

