/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.dig.reasoner.logger;

import edu.stanford.smi.protegex.owl.inference.dig.exception.DIGError;
import edu.stanford.smi.protegex.owl.inference.dig.reasoner.DIGReasoner;
import edu.stanford.smi.protegex.owl.inference.dig.reasoner.logger.DIGLoggerListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

public class DIGLogger {
    private static Map loggerMap = new WeakHashMap();
    private ArrayList listeners = new ArrayList();

    private DIGLogger() {
    }

    public static DIGLogger getInstance(DIGReasoner dIGReasoner) {
        DIGLogger dIGLogger = (DIGLogger)loggerMap.get(dIGReasoner);
        if (dIGLogger == null) {
            dIGLogger = new DIGLogger();
            loggerMap.put(dIGReasoner, dIGLogger);
        }
        return dIGLogger;
    }

    public void logError(DIGError dIGError) {
        Iterator iterator = new ArrayList(this.listeners).iterator();
        while (iterator.hasNext()) {
            WeakReference weakReference = (WeakReference)iterator.next();
            if (weakReference.get() == null) {
                iterator.remove();
                continue;
            }
            ((DIGLoggerListener)iterator.next()).errorLogged(dIGError);
        }
    }

    public void addListener(DIGLoggerListener dIGLoggerListener) {
        this.listeners.add(new WeakReference<DIGLoggerListener>(dIGLoggerListener));
    }

    public void removeListener(DIGLoggerListener dIGLoggerListener) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            WeakReference weakReference = (WeakReference)iterator.next();
            if (weakReference.get() == null) {
                iterator.remove();
                continue;
            }
            if (weakReference.get() != dIGLoggerListener) continue;
            iterator.remove();
        }
    }
}

