/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.database;

import edu.stanford.smi.protege.util.URIField;
import edu.stanford.smi.protege.util.Wizard;
import edu.stanford.smi.protege.util.WizardPage;
import edu.stanford.smi.protegex.owl.database.OWLDatabasePlugin;
import edu.stanford.smi.protegex.owl.database.OWLDatabaseWizardPage;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Component;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class InitOWLDatabaseFromFileWizardPage
extends WizardPage {
    private OWLDatabasePlugin plugin;
    private URIField uriField;

    public InitOWLDatabaseFromFileWizardPage(Wizard wizard, OWLDatabasePlugin oWLDatabasePlugin) {
        super("Specify Ontology File", wizard);
        this.plugin = oWLDatabasePlugin;
        this.uriField = new URIField("URI of OWL file to populate the new database with", null, ".owl", "OWL Files");
        this.uriField.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                InitOWLDatabaseFromFileWizardPage.this.setPageComplete(true);
            }
        });
        this.add("Center", (Component)this.uriField);
        this.add("South", OWLUI.createHelpPanel("This allows you to use the Protege-OWL parser to load OWL/RDF files directly into a new database.  In theory, this parser should be able to handle files of arbitrary size, because it loads the file triple-by-triple.", "Create OWL Database from a File"));
        this.setPageComplete(false);
    }

    public WizardPage getNextPage() {
        return new OWLDatabaseWizardPage(this.getWizard(), this.plugin, true);
    }

    public void onFinish() {
        this.plugin.setOntologyFileURI(this.uriField.getAbsoluteURI());
    }
}

