/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.database;

import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.framestore.MergingNarrowFrameStore;
import edu.stanford.smi.protege.plugin.CreateProjectWizard;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.MessageError;
import edu.stanford.smi.protege.util.Wizard;
import edu.stanford.smi.protege.util.WizardPage;
import edu.stanford.smi.protegex.owl.database.CreateOWLDatabaseProjectPlugin;
import edu.stanford.smi.protegex.owl.database.InitOWLDatabaseFromFileWizardPage;
import edu.stanford.smi.protegex.owl.database.OWLDatabaseModel;
import edu.stanford.smi.protegex.owl.jena.JenaKnowledgeBaseFactory;
import edu.stanford.smi.protegex.owl.jena.parser.ProtegeOWLParser;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;

public class CreateOWLDatabaseFromFileProjectPlugin
extends CreateOWLDatabaseProjectPlugin {
    public CreateOWLDatabaseFromFileProjectPlugin() {
        super("OWL File (.owl or .rdf)");
    }

    protected Project buildNewProject(KnowledgeBaseFactory knowledgeBaseFactory) {
        JenaKnowledgeBaseFactory.useStandalone = false;
        ArrayList<MessageError> arrayList = new ArrayList<MessageError>();
        Project project = super.createNewProject(knowledgeBaseFactory);
        this.initializeSources(project.getSources());
        try {
            File file = File.createTempFile("protege", "temp");
            project.setProjectFilePath(file.getPath());
            project.save(arrayList);
            project = Project.loadProjectFromFile((String)file.getPath(), arrayList);
            OWLDatabaseModel oWLDatabaseModel = (OWLDatabaseModel)project.getKnowledgeBase();
            this.updateTripleStores(oWLDatabaseModel);
            ProtegeOWLParser protegeOWLParser = new ProtegeOWLParser(oWLDatabaseModel, false);
            try {
                protegeOWLParser.run(this.ontologyFileURI);
            }
            catch (Exception exception) {
                String string = "Could not load OWL file into database";
                Log.getLogger().severe(string);
                Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
                arrayList.add(new MessageError(exception, string));
            }
            oWLDatabaseModel.resetTripleStoreModel();
            this.handleErrors(arrayList);
            project.setProjectFilePath(null);
            file.delete();
            this.updateTripleStores(oWLDatabaseModel);
        }
        catch (IOException iOException) {
            Log.getLogger().severe(Log.toString((Throwable)iOException));
        }
        return project;
    }

    private void updateTripleStores(OWLDatabaseModel oWLDatabaseModel) {
        oWLDatabaseModel.resetTripleStoreModel();
        TripleStore tripleStore = oWLDatabaseModel.getTripleStoreModel().getTopTripleStore();
        oWLDatabaseModel.getTripleStoreModel().setActiveTripleStore(tripleStore);
        MergingNarrowFrameStore mergingNarrowFrameStore = MergingNarrowFrameStore.get((KnowledgeBase)oWLDatabaseModel);
        mergingNarrowFrameStore.setTopFrameStore(mergingNarrowFrameStore.getActiveFrameStore().getName());
    }

    public boolean canCreateProject(KnowledgeBaseFactory knowledgeBaseFactory, boolean bl) {
        return super.canCreateProject(knowledgeBaseFactory, bl) && bl;
    }

    public WizardPage createCreateProjectWizardPage(CreateProjectWizard createProjectWizard, boolean bl) {
        return new InitOWLDatabaseFromFileWizardPage((Wizard)createProjectWizard, this);
    }
}

