/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.util.DefaultRenderer;
import java.util.HashMap;
import java.util.Map;

public class ValueTypeRenderer
extends DefaultRenderer {
    private static final Map valueTypeToKeyMap = new HashMap();

    private static void insert(ValueType valueType, ResourceKey resourceKey) {
        valueTypeToKeyMap.put(valueType, resourceKey);
    }

    public void load(Object object) {
        ValueType valueType = (ValueType)object;
        ResourceKey resourceKey = this.getKey(valueType);
        String string = LocalizedText.getText(resourceKey);
        this.setMainText(string);
    }

    private ResourceKey getKey(ValueType valueType) {
        return (ResourceKey)valueTypeToKeyMap.get(valueType);
    }

    static {
        ValueTypeRenderer.insert(ValueType.INSTANCE, ResourceKey.TYPE_INSTANCE);
        ValueTypeRenderer.insert(ValueType.CLS, ResourceKey.TYPE_CLASS);
        ValueTypeRenderer.insert(ValueType.ANY, ResourceKey.TYPE_ANY);
        ValueTypeRenderer.insert(ValueType.BOOLEAN, ResourceKey.TYPE_BOOLEAN);
        ValueTypeRenderer.insert(ValueType.FLOAT, ResourceKey.TYPE_FLOAT);
        ValueTypeRenderer.insert(ValueType.INTEGER, ResourceKey.TYPE_INTEGER);
        ValueTypeRenderer.insert(ValueType.SYMBOL, ResourceKey.TYPE_SYMBOL);
        ValueTypeRenderer.insert(ValueType.STRING, ResourceKey.TYPE_STRING);
    }
}

