/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.RoleConstraint;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.widget.ComboBoxWidget;
import edu.stanford.smi.protege.widget.RoleRenderer;
import java.awt.Component;
import java.util.ArrayList;

public class RoleWidget
extends ComboBoxWidget {
    public void comboBoxValueChanged() {
        Object object = this.getComboBoxSelection();
        if (RoleConstraint.isAbstract((String)object)) {
            this.makeConcreteAbstract();
        } else {
            this.makeAbstractConcrete();
        }
    }

    private void makeAbstractConcrete() {
        this.valueChanged();
    }

    private void makeConcreteAbstract() {
        int n;
        Cls cls = (Cls)this.getInstance();
        int n2 = n = cls == null ? 0 : cls.getDirectInstanceCount();
        if (n > 0) {
            String string = n == 1 ? "" : "s";
            String string2 = "The class " + cls.getBrowserText();
            string2 = string2 + " has " + n + " direct instance" + string + ".\n";
            string2 = string2 + "Changing the role to \"abstract\" will cause these instances to be deleted.\n\n";
            int n3 = ModalDialog.showMessageDialog((Component)this, string2 = string2 + "Do you really want to make this change?", 13);
            if (n3 == 2) {
                for (Instance instance : new ArrayList(cls.getDirectInstances())) {
                    instance.delete();
                }
                this.valueChanged();
            } else {
                this.setComboBoxValue("Concrete".toString());
            }
        } else {
            this.valueChanged();
        }
    }

    public void initialize() {
        this.setDisplayNullEntry(false);
        super.initialize();
        this.setRenderer(new RoleRenderer());
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        return slot.getName().equals(":ROLE");
    }

    public String getLabel() {
        return this.localizeStandardLabel(super.getLabel(), "Role", ResourceKey.ROLE_SLOT_WIDGET_LABEL);
    }
}

