/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.ui.DisplayUtilities;
import edu.stanford.smi.protege.ui.InstanceDisplay;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.widget.AbstractTabWidget;
import edu.stanford.smi.protege.widget.KAToolTabConfigurationPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class KAToolTab
extends AbstractTabWidget {
    private static final String TOP_LEVEL_INSTANCE_PROPERTY = "KATool.TOP_LEVEL_INSTANCE";

    public boolean configure() {
        KAToolTabConfigurationPanel kAToolTabConfigurationPanel = new KAToolTabConfigurationPanel(this);
        ModalDialog.showDialog(this, kAToolTabConfigurationPanel, "Configure KA Tool", 11);
        return true;
    }

    private JComponent createClsPanel() {
        Instance instance = this.getTopLevelInstance();
        Assert.assertNotNull("top level instance", instance);
        InstanceDisplay instanceDisplay = new InstanceDisplay(this.getProject());
        instanceDisplay.setInstance(instance);
        return instanceDisplay;
    }

    private Action createSelectClsAction() {
        return new AbstractAction("Press to select top-level instance"){

            public void actionPerformed(ActionEvent actionEvent) {
                Instance instance = DisplayUtilities.pickInstance((Component)KAToolTab.this, KAToolTab.this.getKnowledgeBase());
                if (instance != null) {
                    KAToolTab.this.setTopLevelInstance(instance);
                }
            }
        };
    }

    private JComponent createSetupPanel() {
        JPanel jPanel = new JPanel(new FlowLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add(ComponentFactory.createButton(this.createSelectClsAction()));
        jPanel.add(jPanel2);
        return jPanel;
    }

    public Instance getTopLevelInstance() {
        Instance instance = null;
        String string = this.getPropertyList().getString(TOP_LEVEL_INSTANCE_PROPERTY);
        if (string != null && (instance = this.getKnowledgeBase().getInstance(string)) == null) {
            Log.getLogger().warning("Unable to find top level instance " + string);
        }
        return instance;
    }

    public void initialize() {
        if (this.getLabel() == null) {
            this.setLabel("Knowledge Acquisition");
        }
        this.setupUI();
    }

    public void setTopLevelInstance(Instance instance) {
        this.getPropertyList().setString(TOP_LEVEL_INSTANCE_PROPERTY, instance.getName());
        this.setupUI();
    }

    private void setupUI() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        Instance instance = this.getTopLevelInstance();
        JComponent jComponent = instance == null ? this.createSetupPanel() : this.createClsPanel();
        this.add(jComponent);
        this.revalidate();
        this.repaint();
    }
}

