/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.StandardAction;
import edu.stanford.smi.protege.util.WizardPage;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public abstract class Wizard
extends JDialog {
    public static final int RESULT_FINISH = 1;
    public static final int RESULT_CANCEL = 2;
    private JComponent cardHolder;
    private CardLayout layout;
    private JComponent buttonPanel;
    private JButton finishButton;
    private JButton nextButton;
    private JButton backButton;
    private JButton cancelButton;
    private int result;

    protected Wizard(JComponent jComponent, String string) {
        super(Wizard.getFrame(jComponent), string, true);
        this.initialize();
    }

    protected Wizard(Dialog dialog, String string) {
        super(dialog, string, true);
        this.initialize();
    }

    protected void initialize() {
        this.getContentPane().setLayout(new BorderLayout());
        this.layout = new CardLayout();
        this.cardHolder = new JPanel(this.layout);
        this.buttonPanel = new JPanel();
        this.getContentPane().add((Component)this.cardHolder, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.createButtons();
    }

    private static JFrame getFrame(JComponent jComponent) {
        return (JFrame)SwingUtilities.getRoot(jComponent);
    }

    private void createButtons() {
        this.finishButton = this.createFinishButton();
        this.nextButton = this.createNextButton();
        this.backButton = this.createBackButton();
        this.backButton.setEnabled(false);
        this.cancelButton = this.createCancelButton();
        Box box = Box.createHorizontalBox();
        box.add(this.backButton);
        box.add(this.nextButton);
        box.add(Box.createHorizontalStrut(3));
        box.add(this.finishButton);
        box.add(Box.createHorizontalStrut(3));
        box.add(this.cancelButton);
        this.buttonPanel.setLayout(new FlowLayout(2, 0, 0));
        this.buttonPanel.add(box);
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 10, 5));
    }

    private JButton createFinishButton() {
        StandardAction standardAction = new StandardAction("Finish"){

            public void actionPerformed(ActionEvent actionEvent) {
                Wizard.this.result = 1;
                Wizard.this.onFinish();
                Wizard.this.setVisible(false);
            }
        };
        standardAction.setMnemonic(70);
        return this.createButton(standardAction);
    }

    private JButton createButton(Action action) {
        JButton jButton = ComponentFactory.createButton(action);
        jButton.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                Wizard.this.updateDefaultButton();
            }

            public void focusLost(FocusEvent focusEvent) {
                Wizard.this.updateDefaultButton();
            }
        });
        return jButton;
    }

    private JButton createNextButton() {
        StandardAction standardAction = new StandardAction("Next >"){

            public void actionPerformed(ActionEvent actionEvent) {
                Wizard.this.showNextPage();
            }
        };
        standardAction.setMnemonic(78);
        return this.createButton(standardAction);
    }

    private JButton createBackButton() {
        StandardAction standardAction = new StandardAction("< Back"){

            public void actionPerformed(ActionEvent actionEvent) {
                Wizard.this.showPreviousPage();
            }
        };
        standardAction.setMnemonic(66);
        return this.createButton(standardAction);
    }

    private JButton createCancelButton() {
        AbstractAction abstractAction = new AbstractAction("Cancel"){

            public void actionPerformed(ActionEvent actionEvent) {
                Wizard.this.result = 2;
                Wizard.this.onCancel();
                Wizard.this.setVisible(false);
            }
        };
        return this.createButton(abstractAction);
    }

    private int getCurrentPageIndex() {
        int n = 0;
        for (int i = 0; i < this.cardHolder.getComponentCount(); ++i) {
            Component component = this.cardHolder.getComponent(i);
            if (!component.isVisible()) continue;
            n = i;
            break;
        }
        return n;
    }

    private int getPageCount() {
        return this.cardHolder.getComponentCount();
    }

    public void addPage(WizardPage wizardPage) {
        if (wizardPage != null) {
            this.addPageToCardHolder(wizardPage);
            WizardPage wizardPage2 = wizardPage.getNextPage();
            if (wizardPage2 != null) {
                this.addPage(wizardPage2);
            }
        }
        this.updateButtons();
    }

    public void updateNextPage(WizardPage wizardPage) {
        if (this.removeFollowingPages(wizardPage)) {
            this.addPage(wizardPage.getNextPage());
        }
    }

    private void addPageToCardHolder(WizardPage wizardPage) {
        this.cardHolder.add((Component)wizardPage, wizardPage.getName());
    }

    private void removePageFromCardHolder(int n) {
        this.cardHolder.remove(n);
    }

    private boolean removeFollowingPages(WizardPage wizardPage) {
        int n = this.getPageIndex(wizardPage);
        if (n != -1) {
            for (int i = this.cardHolder.getComponentCount() - 1; i > n; --i) {
                this.removePageFromCardHolder(i);
            }
        }
        return n != -1;
    }

    private int getPageIndex(WizardPage wizardPage) {
        int n = -1;
        for (int i = 0; i < this.cardHolder.getComponentCount(); ++i) {
            Component component = this.cardHolder.getComponent(i);
            if (component != wizardPage) continue;
            n = i;
            break;
        }
        return n;
    }

    public int execute() {
        this.layout.first(this.cardHolder);
        ComponentUtilities.center(this);
        this.setVisible(true);
        return this.result;
    }

    public void notifyChanged(WizardPage wizardPage) {
        this.updateButtons();
    }

    private void updateButtons() {
        this.backButton.setEnabled(this.canGoBack());
        this.nextButton.setEnabled(this.canGoNext());
        this.finishButton.setEnabled(this.canFinish());
        this.updateDefaultButton();
    }

    private void updateDefaultButton() {
        if (this.backButton.hasFocus()) {
            this.setDefaultButton(this.backButton);
        } else if (this.nextButton.hasFocus()) {
            this.setDefaultButton(this.nextButton);
        } else if (this.finishButton.hasFocus()) {
            this.setDefaultButton(this.finishButton);
        } else if (this.cancelButton.hasFocus()) {
            this.setDefaultButton(this.cancelButton);
        } else if (this.finishButton.isEnabled()) {
            this.setDefaultButton(this.finishButton);
        } else if (this.nextButton.isEnabled()) {
            this.setDefaultButton(this.nextButton);
        } else {
            this.setDefaultButton(null);
        }
    }

    private void setDefaultButton(JButton jButton) {
        this.getRootPane().setDefaultButton(jButton);
    }

    protected void onFinish() {
        for (int i = 0; i < this.cardHolder.getComponentCount(); ++i) {
            WizardPage wizardPage = (WizardPage)this.cardHolder.getComponent(i);
            wizardPage.onFinish();
        }
    }

    protected void onCancel() {
        for (int i = 0; i < this.cardHolder.getComponentCount(); ++i) {
            WizardPage wizardPage = (WizardPage)this.cardHolder.getComponent(i);
            wizardPage.onCancel();
        }
    }

    public boolean canGoBack() {
        return !this.isShowingFirstPage();
    }

    protected boolean isShowingFirstPage() {
        return this.getCurrentPageIndex() == 0;
    }

    protected boolean isShowingLastPage() {
        return this.getCurrentPageIndex() == this.getPageCount() - 1;
    }

    protected WizardPage getCurrentPage() {
        return (WizardPage)this.cardHolder.getComponent(this.getCurrentPageIndex());
    }

    public boolean canGoNext() {
        WizardPage wizardPage = this.getCurrentPage();
        return wizardPage.isPageComplete() && !this.isShowingLastPage();
    }

    public boolean canFinish() {
        boolean bl = true;
        for (int i = 0; i < this.cardHolder.getComponentCount(); ++i) {
            WizardPage wizardPage = (WizardPage)this.cardHolder.getComponent(i);
            if (wizardPage.isPageComplete()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    protected void showPreviousPage() {
        this.layout.previous(this.cardHolder);
        this.getCurrentPage().requestFocus();
        this.updateButtons();
    }

    protected void showNextPage() {
        this.layout.next(this.cardHolder);
        this.getCurrentPage().requestFocus();
        this.updateButtons();
    }
}

