/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.ListenerCollection;
import edu.stanford.smi.protege.util.ListenerList;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectionEventDispatcher;
import edu.stanford.smi.protege.util.SelectionListener;
import java.awt.event.MouseEvent;
import java.util.Collection;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SelectableList
extends JList
implements Selectable {
    private ListenerCollection _listeners = new ListenerList(new SelectionEventDispatcher());
    private boolean _isDragEvent;
    private boolean _isMultiSelectPressEvent;
    private boolean _isDeferringSelection;

    public SelectableList() {
        this.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    SelectableList.this.notifySelectionListeners();
                }
            }
        });
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this._listeners.add(this, selectionListener);
    }

    public Collection getSelection() {
        return ComponentUtilities.getSelection(this);
    }

    public void setSelectedValue(Object object) {
        ComponentUtilities.setSelectedValue(this, object);
    }

    public void setListenerNotificationEnabled(boolean bl) {
        this._listeners.setPostingEnabled(bl);
    }

    public void notifySelectionListeners() {
        this._listeners.postEvent(this, 1);
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        this._isMultiSelectPressEvent = false;
        int n = this.locationToIndex(mouseEvent.getPoint());
        int n2 = mouseEvent.getID();
        if (n2 == 501) {
            if (n == -1) {
                this.clearSelection();
            } else if (this.isSelectedIndex(n)) {
                this._isMultiSelectPressEvent = true;
                this._isDeferringSelection = true;
            }
        }
        if (this._isDeferringSelection && n2 == 502) {
            this.setSelectionInterval(n, n);
            this._isDeferringSelection = false;
        }
        super.processMouseEvent(mouseEvent);
        this._isMultiSelectPressEvent = false;
    }

    public void processMouseMotionEvent(MouseEvent mouseEvent) {
        boolean bl = ComponentUtilities.isDragAndDropEnabled(this);
        this._isDragEvent = bl && mouseEvent.getID() == 506;
        super.processMouseMotionEvent(mouseEvent);
        this._isDragEvent = false;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this._listeners.remove(this, selectionListener);
    }

    public void setSelectionInterval(int n, int n2) {
        if (!this._isDragEvent && !this._isMultiSelectPressEvent) {
            super.setSelectionInterval(n, n2);
        }
    }

    public String toString() {
        return "SelectableList";
    }
}

