/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.TransferableCollection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JList;

public abstract class ListDragSourceListener
implements DragGestureListener,
DragSourceListener {
    private int[] _indexes;
    private Collection _objects;

    public abstract void doCopy(JComponent var1, int[] var2, Collection var3);

    public abstract void doMove(JComponent var1, int[] var2, Collection var3);

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        if (dragSourceDropEvent.getDropSuccess()) {
            JComponent jComponent = (JComponent)dragSourceDropEvent.getDragSourceContext().getComponent();
            int n = dragSourceDropEvent.getDropAction();
            if (n == 2) {
                this.doMove(jComponent, this._indexes, this._objects);
            } else if (n == 1) {
                this.doCopy(jComponent, this._indexes, this._objects);
            }
        }
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        JList jList = (JList)dragGestureEvent.getComponent();
        if (ComponentUtilities.isDragAndDropEnabled(jList)) {
            this._indexes = jList.getSelectedIndices();
            this._objects = Arrays.asList(jList.getSelectedValues());
            if (!this._objects.isEmpty()) {
                TransferableCollection transferableCollection = new TransferableCollection(this._objects);
                dragGestureEvent.startDrag(DragSource.DefaultMoveDrop, transferableCollection, this);
            }
        }
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }
}

