/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.util.AbstractValidatableComponent;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.widget.ProtegePropertiesComponent;
import java.awt.BorderLayout;
import java.io.File;
import java.util.Properties;
import javax.swing.JTabbedPane;

public class ConfigureProtegePropertiesPanel
extends AbstractValidatableComponent {
    private final String PROTEGE_LAX_FILE = "Protege.lax";
    private Project _project;
    private ProtegePropertiesComponent _protegeProp;
    private ProtegePropertiesComponent _protegeLax;
    private Properties _copyProtegeProperties;

    public ConfigureProtegePropertiesPanel(Project project) {
        this._project = project;
        this.buildGUI();
    }

    private void buildGUI() {
        this.setLayout(new BorderLayout());
        JTabbedPane jTabbedPane = ComponentFactory.createTabbedPane(true);
        this._copyProtegeProperties = new Properties();
        this.copyProperties(ApplicationProperties.getApplicationProperties(), this._copyProtegeProperties);
        this._protegeProp = new ProtegePropertiesComponent(this._copyProtegeProperties);
        this._protegeProp.setVisibleHeaderButton(this._protegeProp.getLoadAction(), false);
        jTabbedPane.addTab("protege.properties", this._protegeProp);
        File file = this.getLaxFile();
        if (file.exists()) {
            this._protegeLax = new ProtegePropertiesComponent(file);
            this._protegeLax.setVisibleHeaderButton(this._protegeLax.getLoadAction(), false);
            jTabbedPane.addTab("Protege.lax", this._protegeLax);
        }
        this.add(jTabbedPane);
    }

    private void copyProperties(Properties properties, Properties properties2) {
        properties2.clear();
        for (String string : properties.keySet()) {
            properties2.setProperty(string, properties.getProperty(string));
        }
    }

    private File getLaxFile() {
        File file = ApplicationProperties.getApplicationDirectory();
        return new File(file, "Protege.lax");
    }

    public void saveContents() {
        this.copyProperties(this._copyProtegeProperties, ApplicationProperties.getApplicationProperties());
        ApplicationProperties.flush();
        File file = this.getLaxFile();
        if (file.exists()) {
            this._protegeLax.savePropertyFile(file);
        }
    }

    public boolean validateContents() {
        return true;
    }
}

