/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.test;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.storage.database.DatabaseKnowledgeBaseFactory;
import edu.stanford.smi.protege.test.AbstractProjectFactory;
import edu.stanford.smi.protege.test.AbstractTestCase;
import edu.stanford.smi.protege.test.ClipsProjectFactory;
import edu.stanford.smi.protege.test.ProjectFactory;
import edu.stanford.smi.protege.util.AbstractEvent;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.PropertyList;
import java.io.File;
import java.io.FileInputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public abstract class APITestCase
extends AbstractTestCase {
    private Collection _firedEvents = new ArrayList();
    private static Properties _junitProperties = null;
    private static final String DB_PREFIX = "junit.db.";
    private static DBType _dbType = DBType.Oracle;
    public static final String JUNIT_DB_DRIVER_PROPERTY = "driver";
    public static final String JUNIT_DB_TABLE_PROPERTY = "table";
    public static final String JUNIT_DB_USER_PROPERTY = "user";
    public static final String JUNIT_DB_PASSWORD_PROPERTY = "password";
    public static final String JUNIT_DB_URL_PROPERTY = "url";
    private static ProjectFactory _factory = new ClipsProjectFactory();
    private static Project _scratchProject = _factory.createProject();
    private static boolean _isFileProject = true;
    private static Set<DBType> informedDBConfigured = EnumSet.noneOf(DBType.class);
    private static boolean informedNoConfigurationFile = false;
    private static int callNumber = 0;

    protected void assertEventFired(int n) {
        APITestCase.assertTrue((this.getEventFired(n) != null ? 1 : 0) != 0);
    }

    protected AbstractEvent getEventFired(int n) {
        AbstractEvent abstractEvent = null;
        Iterator iterator = this._firedEvents.iterator();
        while (iterator.hasNext() && abstractEvent == null) {
            AbstractEvent abstractEvent2 = (AbstractEvent)iterator.next();
            if (abstractEvent2.getEventType() != n) continue;
            abstractEvent = abstractEvent2;
        }
        return abstractEvent;
    }

    public void setUp() throws Exception {
        super.setUp();
        _factory = new ClipsProjectFactory();
        _isFileProject = true;
    }

    public final void tearDown() throws Exception {
        super.tearDown();
        if (_scratchProject != null) {
            Project project = _scratchProject;
            _scratchProject = null;
            project.dispose();
        }
    }

    protected void clearEvents() {
        this._firedEvents.clear();
    }

    protected int getEventCount() {
        return this._firedEvents.size();
    }

    private static void configureDBSources(PropertyList propertyList) {
        if (!APITestCase.dbConfigured()) {
            return;
        }
        DatabaseKnowledgeBaseFactory.setDriver(propertyList, APITestCase.getDBProperty(JUNIT_DB_DRIVER_PROPERTY));
        DatabaseKnowledgeBaseFactory.setTablename(propertyList, APITestCase.getDBProperty(JUNIT_DB_TABLE_PROPERTY));
        DatabaseKnowledgeBaseFactory.setUsername(propertyList, APITestCase.getDBProperty(JUNIT_DB_USER_PROPERTY));
        DatabaseKnowledgeBaseFactory.setPassword(propertyList, APITestCase.getDBProperty(JUNIT_DB_PASSWORD_PROPERTY));
        DatabaseKnowledgeBaseFactory.setURL(propertyList, APITestCase.getDBProperty(JUNIT_DB_URL_PROPERTY));
    }

    public static DBType chooseDBType() {
        DBType[] dBTypeArray = DBType.values();
        int n = dBTypeArray.length;
        for (int i = 0; i < n; ++i) {
            DBType dBType;
            _dbType = dBType = dBTypeArray[i];
            if (!APITestCase.dbConfigured()) continue;
            return _dbType;
        }
        return null;
    }

    public static boolean dbConfigured() {
        Properties properties = APITestCase.getJunitProperties();
        if (properties == null) {
            return false;
        }
        String string = APITestCase.getDBProperty("configured");
        if (string == null || !string.toLowerCase().equals("true")) {
            if (!informedDBConfigured.contains((Object)_dbType)) {
                System.out.println("Database Tests for " + (Object)((Object)_dbType) + " not configured");
                informedDBConfigured.add(_dbType);
            }
            return false;
        }
        if (!informedDBConfigured.contains((Object)_dbType)) {
            System.out.println("Database Tests for " + (Object)((Object)_dbType) + " configured");
            informedDBConfigured.add(_dbType);
        }
        return true;
    }

    public static String getDBProperty(String string) {
        Properties properties = APITestCase.getJunitProperties();
        return properties.getProperty(DB_PREFIX + (Object)((Object)_dbType) + "." + string);
    }

    public static Properties getJunitProperties() {
        if (_junitProperties != null) {
            return _junitProperties;
        }
        try {
            Properties properties = new Properties();
            String string = ApplicationProperties.getApplicationDirectory().getPath() + File.separator + "junit.properties";
            FileInputStream fileInputStream = new FileInputStream(string);
            properties.load(fileInputStream);
            _junitProperties = properties;
            return _junitProperties;
        }
        catch (Exception exception) {
            if (!informedNoConfigurationFile) {
                System.out.println("No configuration file for tests");
                informedNoConfigurationFile = true;
            }
            return null;
        }
    }

    public Project getProject() {
        if (_scratchProject == null) {
            _scratchProject = _factory.createProject();
        }
        return _scratchProject;
    }

    public static boolean isDatabaseProject() {
        return !_isFileProject && _scratchProject != null;
    }

    public static boolean isFileProject() {
        return _isFileProject && _scratchProject != null;
    }

    private static void closeProject() {
        if (_scratchProject != null) {
            _scratchProject.dispose();
            _scratchProject = null;
        }
    }

    private static Project createScratchDatabaseProject() {
        ArrayList arrayList = new ArrayList();
        Project project = new Project(null, (Collection)arrayList);
        URI uRI = AbstractProjectFactory.getProjectURI();
        project.setProjectURI(uRI);
        PropertyList propertyList = project.getSources();
        propertyList.setString("factory_class_name", DatabaseKnowledgeBaseFactory.class.getName());
        APITestCase.configureDBSources(propertyList);
        project.save(arrayList);
        APITestCase.checkErrors(arrayList);
        _scratchProject = Project.loadProjectFromURI(uRI, arrayList);
        APITestCase.checkErrors(arrayList);
        return _scratchProject;
    }

    private static Project createScratchFileProject() {
        return _factory.createProject();
    }

    protected Slot getSlot(String string) {
        return this.getDomainKB().getSlot(string);
    }

    public static void init() {
        _scratchProject = null;
    }

    public void recordEventFired(AbstractEvent abstractEvent) {
        this._firedEvents.add(abstractEvent);
    }

    protected static void saveAndReload() {
        _scratchProject = _factory.saveAndReloadProject(_scratchProject);
    }

    protected static void setDatabaseProject() {
        _isFileProject = false;
        APITestCase.closeProject();
        _scratchProject = APITestCase.createScratchDatabaseProject();
    }

    protected static void setFileProject() {
        _isFileProject = true;
        APITestCase.closeProject();
        _scratchProject = APITestCase.createScratchFileProject();
    }

    protected Object getClientInformation(String string) {
        return this.getProject().getClientInformation(string);
    }

    protected void setClientInformation(String string, Object object) {
        this.getProject().setClientInformation(string, object);
    }

    public static void setProjectFactory(ProjectFactory projectFactory) {
        _factory = projectFactory;
    }

    public static void setDBType(DBType dBType) {
        _dbType = dBType;
    }

    public static DBType getDBType() {
        return _dbType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DBType {
        Oracle,
        MySQL,
        MsAccess,
        PostGres,
        SQLServer;

    }
}

