/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.framestore.SimpleTestCase;
import edu.stanford.smi.protege.server.RemoteProjectManager;
import edu.stanford.smi.protege.server.RemoteServer;
import edu.stanford.smi.protege.server.RemoteServerProject;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.Server;
import edu.stanford.smi.protege.test.APITestCase;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Server_Test
extends SimpleTestCase {
    private static transient Logger log = Log.getLogger(Server_Test.class);
    public static final String HOST = "localhost";
    private static final String USER1 = "Ray Fergerson";
    private static final String PASSWORD1 = "claudia";
    private static final String WRONG_PASSWORD = "elle";
    private static final String PROJECT_NAME = "Newspaper";
    private static final String USER2 = "Jennifer Vendetti";
    private static final String PASSWORD2 = "jenny";
    private static final String NAME = "//localhost/" + Server.getBoundName();
    private static final String JAR_PROPERTY = "junit.server.protege.jar";
    private static boolean serverRunning = false;
    private RemoteServer _server;
    private static String metaproject = "examples/server/metaproject.pprj";
    private static boolean informedServerNotConfigured = false;

    public void setUp() throws Exception {
        super.setUp();
        try {
            if (!Server_Test.startServer()) {
                return;
            }
            this._server = (RemoteServer)Naming.lookup(NAME);
            this._server.reinitialize();
        }
        catch (NotBoundException notBoundException) {
            Server_Test.fail((String)"Could not bind to server (is rmiregistry running?)");
        }
    }

    public static boolean startServer() throws Exception {
        Properties properties = APITestCase.getJunitProperties();
        String string = properties.getProperty(JAR_PROPERTY);
        if (string == null) {
            if (!informedServerNotConfigured) {
                System.out.println("Server Tests Not Configured");
                informedServerNotConfigured = true;
            }
            return false;
        }
        System.setProperty("java.rmi.server.codebase", string);
        String[] stringArray = new String[]{"", metaproject};
        if (!serverRunning) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("starting server");
            }
            Server.startServer(stringArray);
            serverRunning = true;
        }
        return true;
    }

    public static boolean isServerRunning() {
        return serverRunning;
    }

    public static void setMetaProject(String string) {
        metaproject = string;
    }

    private static String getMachineIpAddress() {
        return SystemUtilities.getMachineIpAddress();
    }

    public void testSession() throws RemoteException {
        if (!serverRunning) {
            return;
        }
        RemoteSession remoteSession = this._server.openSession(USER1, Server_Test.getMachineIpAddress(), PASSWORD1);
        Server_Test.assertNotNull((String)"session", (Object)remoteSession);
        RemoteSession remoteSession2 = this._server.openSession(USER1, Server_Test.getMachineIpAddress(), WRONG_PASSWORD);
        Server_Test.assertNull((String)"no session", (Object)remoteSession2);
        this._server.closeSession(remoteSession);
    }

    public void testConnection() throws RemoteException {
        if (!serverRunning) {
            return;
        }
        RemoteSession remoteSession = this._server.openSession(USER1, Server_Test.getMachineIpAddress(), PASSWORD1);
        Server_Test.assertNotNull((Object)remoteSession);
        RemoteServerProject remoteServerProject = this._server.openProject(PROJECT_NAME, remoteSession);
        Server_Test.assertNotNull((Object)remoteServerProject);
        RemoteSession remoteSession2 = this._server.openSession(USER2, Server_Test.getMachineIpAddress(), PASSWORD2);
        RemoteServerProject remoteServerProject2 = this._server.openProject(PROJECT_NAME, remoteSession2);
        Server_Test.assertEquals((String)"projects", (Object)remoteServerProject, (Object)remoteServerProject2);
        Collection collection = this._server.getCurrentSessions(PROJECT_NAME, remoteSession2);
        Server_Test.assertEqualsSet(Server_Test.makeList(remoteSession, remoteSession2), collection);
        remoteServerProject2.close(remoteSession2);
        collection = this._server.getCurrentSessions(PROJECT_NAME, remoteSession);
        Server_Test.assertEqualsSet(Server_Test.makeList(remoteSession), collection);
        remoteServerProject.close(remoteSession);
        this._server.closeSession(remoteSession);
        this._server.closeSession(remoteSession2);
    }

    public void testGetProject() {
        if (!serverRunning) {
            return;
        }
        Project project = RemoteProjectManager.getInstance().getProject(HOST, USER1, PASSWORD1, PROJECT_NAME, true);
        Server_Test.assertNotNull((Object)project);
        KnowledgeBase knowledgeBase = project.getKnowledgeBase();
        Cls cls = knowledgeBase.getCls("Editor");
        Server_Test.assertNotNull((Object)cls);
        project.dispose();
    }
}

