/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.plugin;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.plugin.AbstractExportPlugin;
import edu.stanford.smi.protege.plugin.BackendExportPlugin;
import java.util.ArrayList;
import java.util.Collection;

public abstract class AbstractBackendExportPlugin
extends AbstractExportPlugin
implements BackendExportPlugin {
    private String newProjectPath;

    protected AbstractBackendExportPlugin(String string) {
        super(string);
    }

    public boolean canExportToNewFormat(Project project) {
        return true;
    }

    public void setNewProjectPath(String string) {
        this.newProjectPath = string;
    }

    protected abstract void initializeSources(Project var1, Collection var2);

    protected abstract void overwriteDomainInformation(Project var1, Collection var2);

    public Project exportProjectToNewFormat(Project project) {
        ArrayList arrayList = new ArrayList();
        if (this.isCompatibleProject(project)) {
            this.saveAndPreserveCustomizations(project, arrayList);
        } else {
            this.saveAndDiscardCustomizations(project, arrayList);
        }
        Project project2 = Project.loadProjectFromFile(this.newProjectPath, arrayList);
        this.handleErrors(arrayList);
        return project2;
    }

    protected boolean isCompatibleProject(Project project) {
        String string = project.getKnowledgeBaseFactory().getClass().getName();
        return string.indexOf("OWL") == -1;
    }

    private void saveAndPreserveCustomizations(Project project, Collection collection) {
        project.setProjectFilePath(this.newProjectPath);
        this.initializeSources(project, collection);
        project.save(collection);
    }

    protected void saveAndDiscardCustomizations(Project project, Collection collection) {
        Project project2 = Project.createNewProject(null, collection);
        project2.setProjectFilePath(this.newProjectPath);
        project2.save(collection);
        this.overwriteDomainInformation(project, collection);
    }
}

