/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore.undo;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.undo.SimpleCommand;
import java.util.ArrayList;
import java.util.Collection;

class DeleteClsCommand
extends SimpleCommand {
    private Cls cls;
    private FrameID id;
    private String name;
    private Collection directTypes;
    private Collection directSuperclasses;

    DeleteClsCommand(FrameStore frameStore, Cls cls) {
        super(frameStore);
        this.cls = cls;
        this.name = cls.getName();
        this.id = cls.getFrameID();
        this.directTypes = new ArrayList(cls.getDirectTypes());
        this.directSuperclasses = new ArrayList(cls.getDirectSuperclasses());
        this.setDescription("Delete class " + DeleteClsCommand.getText(cls));
    }

    public Object doIt() {
        this.getDelegate().deleteCls(this.cls);
        this.cls.markDeleted(true);
        return null;
    }

    public void undoIt() {
        this.getDelegate().createCls(this.id, this.name, this.directTypes, this.directSuperclasses, false);
        this.cls.markDeleted(false);
    }
}

