/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.ClosureUtils;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.model.framestore.Sft;
import edu.stanford.smi.protege.model.query.Query;
import edu.stanford.smi.protege.util.CacheMap;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.StringUtilities;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClosureCachingBasicFrameStore
implements NarrowFrameStore {
    private static Logger log = Log.getLogger(ClosureCachingBasicFrameStore.class);
    private NarrowFrameStore _delegate;
    private final Sft _lookupSft = new Sft();
    private CacheMap _sftToFrameToClosureMap = new CacheMap();

    public ClosureCachingBasicFrameStore(NarrowFrameStore narrowFrameStore) {
        if (log.isLoggable(Level.FINEST)) {
            log.fine("Constructing NarrowFrameStore " + this + " with delegate " + narrowFrameStore);
        }
        this._delegate = narrowFrameStore;
    }

    public String getName() {
        return StringUtilities.getClassName(this);
    }

    public void setName(String string) {
        throw new UnsupportedOperationException();
    }

    public NarrowFrameStore getDelegate() {
        return this._delegate;
    }

    public Frame getFrame(FrameID frameID) {
        return this._delegate.getFrame(frameID);
    }

    public FrameID generateFrameID() {
        return this._delegate.generateFrameID();
    }

    public List getValues(Frame frame, Slot slot, Facet facet, boolean bl) {
        return this._delegate.getValues(frame, slot, facet, bl);
    }

    public int getValuesCount(Frame frame, Slot slot, Facet facet, boolean bl) {
        return this._delegate.getValuesCount(frame, slot, facet, bl);
    }

    public void setValues(Frame frame, Slot slot, Facet facet, boolean bl, Collection collection) {
        this._delegate.setValues(frame, slot, facet, bl, collection);
        this.updateClosureCache(slot, facet, bl);
    }

    public void addValues(Frame frame, Slot slot, Facet facet, boolean bl, Collection collection) {
        this._delegate.addValues(frame, slot, facet, bl, collection);
        this.updateClosureCache(slot, facet, bl);
    }

    public void removeValue(Frame frame, Slot slot, Facet facet, boolean bl, Object object) {
        this._delegate.removeValue(frame, slot, facet, bl, object);
        this.updateClosureCache(slot, facet, bl);
    }

    public void moveValue(Frame frame, Slot slot, Facet facet, boolean bl, int n, int n2) {
        this._delegate.moveValue(frame, slot, facet, bl, n, n2);
    }

    public Set getFrames(Slot slot, Facet facet, boolean bl, Object object) {
        return this._delegate.getFrames(slot, facet, bl, object);
    }

    public Set getFramesWithAnyValue(Slot slot, Facet facet, boolean bl) {
        return this._delegate.getFramesWithAnyValue(slot, facet, bl);
    }

    public int getFrameCount() {
        return this._delegate.getFrameCount();
    }

    public int getClsCount() {
        return this._delegate.getClsCount();
    }

    public int getSlotCount() {
        return this._delegate.getSlotCount();
    }

    public int getFacetCount() {
        return this._delegate.getFacetCount();
    }

    public int getSimpleInstanceCount() {
        return this._delegate.getSimpleInstanceCount();
    }

    public Set getFrames() {
        return this._delegate.getFrames();
    }

    public Set getMatchingFrames(Slot slot, Facet facet, boolean bl, String string, int n) {
        return this._delegate.getMatchingFrames(slot, facet, bl, string, n);
    }

    public Set getReferences(Object object) {
        return this._delegate.getReferences(object);
    }

    public Set getMatchingReferences(String string, int n) {
        return this._delegate.getMatchingReferences(string, n);
    }

    public void deleteFrame(Frame frame) {
        this._delegate.deleteFrame(frame);
        this.deleteFrameFromCache(frame);
    }

    public Set executeQuery(Query query) {
        return this._delegate.executeQuery(query);
    }

    public void close() {
        this._delegate.close();
        this._delegate = null;
    }

    public Set getClosure(Frame frame, Slot slot, Facet facet, boolean bl) {
        Set set = this.lookup(frame, slot, facet, bl);
        if (set == null) {
            set = ClosureUtils.calculateClosure(this, frame, slot, facet, bl);
            this.insert(frame, slot, facet, bl, set);
        }
        return set;
    }

    private Map lookup(Slot slot, Facet facet, boolean bl) {
        this._lookupSft.set(slot, facet, bl);
        return (Map)this._sftToFrameToClosureMap.get(this._lookupSft);
    }

    private Set lookup(Frame frame, Slot slot, Facet facet, boolean bl) {
        Set set = null;
        Map map = this.lookup(slot, facet, bl);
        if (map != null) {
            set = (Set)map.get(frame);
        }
        return set;
    }

    private void insert(Frame frame, Slot slot, Facet facet, boolean bl, Set set) {
        HashMap<Frame, Set> hashMap = this.lookup(slot, facet, bl);
        if (hashMap == null) {
            hashMap = new HashMap<Frame, Set>();
            this._sftToFrameToClosureMap.put(new Sft(slot, facet, bl), hashMap);
        }
        hashMap.put(frame, set);
    }

    private void updateClosureCache(Slot slot, Facet facet, boolean bl) {
        this._lookupSft.set(slot, facet, bl);
        this._sftToFrameToClosureMap.remove(this._lookupSft);
    }

    private void deleteFrameFromCache(Frame frame) {
        this.removeFrameFromSft(frame);
        for (Sft sft : this._sftToFrameToClosureMap.getKeys()) {
            Map map = (Map)this._sftToFrameToClosureMap.get(sft);
            if (map == null) continue;
            map.remove(frame);
            ClosureCachingBasicFrameStore.removeFrameAsValueFromMap(frame, map);
        }
    }

    private static void removeFrameAsValueFromMap(Frame frame, Map map) {
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            Set set = (Set)iterator.next();
            if (!set.contains(frame)) continue;
            iterator.remove();
        }
    }

    private void removeFrameFromSft(Frame frame) {
        if (frame instanceof Slot || frame instanceof Facet) {
            boolean bl = frame instanceof Slot;
            for (Sft sft : this._sftToFrameToClosureMap.getKeys()) {
                if (bl) {
                    if (!ClosureCachingBasicFrameStore.equals(frame, sft.getSlot())) continue;
                    this._sftToFrameToClosureMap.remove(sft);
                    continue;
                }
                if (!ClosureCachingBasicFrameStore.equals(frame, sft.getFacet())) continue;
                this._sftToFrameToClosureMap.remove(sft);
            }
        }
    }

    public boolean beginTransaction(String string) {
        return this._delegate.beginTransaction(string);
    }

    public boolean commitTransaction() {
        return this._delegate.commitTransaction();
    }

    public boolean rollbackTransaction() {
        return this._delegate.rollbackTransaction();
    }

    private void clearCache() {
        this._sftToFrameToClosureMap.clear();
    }

    public void replaceFrame(Frame frame) {
        this.clearCache();
        this._delegate.replaceFrame(frame);
    }

    public static boolean equals(Object object, Object object2) {
        return SystemUtilities.equals(object, object2);
    }
}

