/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.CollectionUtilities;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class ValueType
implements Comparable {
    private static int _nValues = 0;
    private static Map _values = CollectionUtilities.createSmallMap();
    private String _string;
    private int _intValue;
    private Class _javaType;
    public static final ValueType ANY = new ValueType("Any", Object.class);
    public static final ValueType BOOLEAN = new ValueType("Boolean", Boolean.class);
    public static final ValueType CLS = new ValueType("Class", Cls.class);
    public static final ValueType FLOAT = new ValueType("Float", Float.class);
    public static final ValueType INSTANCE = new ValueType("Instance", Instance.class);
    public static final ValueType INTEGER = new ValueType("Integer", Integer.class);
    public static final ValueType STRING = new ValueType("String", String.class);
    public static final ValueType SYMBOL = new ValueType("Symbol", String.class);

    private ValueType(String string, Class clazz) {
        _values.put(string, this);
        this._string = string;
        this._javaType = clazz;
        this._intValue = _nValues++;
    }

    public int getIntValue() {
        return this._intValue;
    }

    public Class getJavaType() {
        return this._javaType;
    }

    public static Collection getValues() {
        return Collections.unmodifiableCollection(_values.values());
    }

    public String toString() {
        return this._string;
    }

    public static ValueType valueOf(String string) {
        ValueType valueType = (ValueType)_values.get(string);
        Assert.assertNotNull("type", valueType);
        return valueType;
    }

    public int compareTo(Object object) {
        return this._string.compareTo(object.toString());
    }
}

