/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.action;

import edu.stanford.smi.protege.action.ProjectRoot;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.resource.Text;
import edu.stanford.smi.protege.ui.ProjectManager;
import edu.stanford.smi.protege.util.AddAction;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.DefaultRenderer;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.LazyTreeModel;
import edu.stanford.smi.protege.util.LazyTreeNode;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.RemoveAction;
import edu.stanford.smi.protege.util.SelectableContainer;
import edu.stanford.smi.protege.util.SelectableTree;
import edu.stanford.smi.protege.util.StandardAction;
import edu.stanford.smi.protege.util.Tree;
import edu.stanford.smi.protege.util.URIUtilities;
import edu.stanford.smi.protege.util.Validatable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.net.URI;
import java.util.Collection;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JScrollPane;
import javax.swing.tree.TreePath;

class ManageIncludedProjectsPanel
extends SelectableContainer
implements Validatable {
    private SelectableTree tree;
    private StandardAction addProjectAction;
    private StandardAction removeProjectAction;
    private StandardAction activateProjectAction;
    private URI activeProject;
    private Tree uriTree;
    private Tree originalUriTree;
    private Project project;

    ManageIncludedProjectsPanel(Project project) {
        this.setLayout(new BorderLayout());
        this.project = project;
        this.activeProject = project.getActiveRootURI();
        this.uriTree = project.getProjectTree();
        this.originalUriTree = (Tree)this.uriTree.clone();
        this.tree = ComponentFactory.createSelectableTree(null);
        this.tree.setLargeModel(true);
        this.generateTreeModel();
        this.tree.setCellRenderer(new ProjectRenderer());
        this.setSelectable(this.tree);
        LabeledComponent labeledComponent = new LabeledComponent("Project Tree", new JScrollPane(this.tree));
        labeledComponent.addHeaderButton(this.createAddIncludedProjectAction());
        labeledComponent.addHeaderButton(this.createRemoveIncludedProjectAction());
        labeledComponent.addHeaderButton(this.createActivateIncludedProjectAction());
        this.add(labeledComponent);
        this.setPreferredSize(new Dimension(400, 400));
        this.updateButtons();
    }

    private void generateTreeModel() {
        this.tree.setModel(new LazyTreeModel(new ProjectRoot(this.uriTree)));
        this.tree.setSelectionRow(0);
        ComponentUtilities.fullSelectionExpand(this.tree, 100);
    }

    private Action createAddIncludedProjectAction() {
        this.addProjectAction = new AddAction(ResourceKey.PROJECT_ADD){

            public void onAdd() {
                String string = Text.getProgramName() + " Project Files";
                JFileChooser jFileChooser = ComponentFactory.createFileChooser("Select Project", string, "pprj");
                int n = jFileChooser.showOpenDialog(ManageIncludedProjectsPanel.this);
                switch (n) {
                    case -1: {
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 0: {
                        URI uRI = jFileChooser.getSelectedFile().toURI();
                        ManageIncludedProjectsPanel.this.uriTree.addChild(ManageIncludedProjectsPanel.this.uriTree.getRoot(), uRI);
                        ManageIncludedProjectsPanel.this.generateTreeModel();
                        break;
                    }
                    default: {
                        Assert.fail("bad result: " + n);
                    }
                }
            }
        };
        return this.addProjectAction;
    }

    private Action createRemoveIncludedProjectAction() {
        this.removeProjectAction = new RemoveAction(ResourceKey.PROJECT_REMOVE, null){

            public void onRemove(Collection collection) {
                for (URI uRI : ManageIncludedProjectsPanel.this.tree.getSelection()) {
                    ManageIncludedProjectsPanel.this.uriTree.removeChild(ManageIncludedProjectsPanel.this.uriTree.getRoot(), uRI);
                }
                ManageIncludedProjectsPanel.this.generateTreeModel();
            }
        };
        return this.removeProjectAction;
    }

    private Action createActivateIncludedProjectAction() {
        this.activateProjectAction = new StandardAction("Activate Selected Project", Icons.getSelectProjectIcon()){

            public void actionPerformed(ActionEvent actionEvent) {
                URI uRI = (URI)CollectionUtilities.getFirstItem(ManageIncludedProjectsPanel.this.getSelection());
                if (uRI != null) {
                    ManageIncludedProjectsPanel.this.activeProject = uRI;
                    ManageIncludedProjectsPanel.this.tree.repaint();
                }
            }
        };
        return this.activateProjectAction;
    }

    public void onSelectionChange() {
        super.onSelectionChange();
        this.updateButtons();
    }

    private void updateButtons() {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath == null) {
            this.addProjectAction.setEnabled(false);
            this.removeProjectAction.setEnabled(false);
            this.activateProjectAction.setEnabled(false);
        } else {
            LazyTreeNode lazyTreeNode = (LazyTreeNode)treePath.getLastPathComponent();
            this.addProjectAction.setEnabled(treePath.getPathCount() == 2);
            this.removeProjectAction.setEnabled(treePath.getPathCount() == 3);
            this.activateProjectAction.setEnabled(lazyTreeNode.getUserObject() != this.activeProject);
        }
    }

    public void saveContents() {
        Set set;
        Set set2 = this.uriTree.getChildren(this.uriTree.getRoot());
        if (!CollectionUtilities.equalsSet(set2, set = this.originalUriTree.getChildren(this.originalUriTree.getRoot()))) {
            ProjectManager.getProjectManager().changeIncludedProjectURIsRequest(set2);
        } else if (this.activeProject != this.project.getActiveRootURI()) {
            ProjectManager.getProjectManager().setActiveProjectURI(this.activeProject);
        }
    }

    public boolean validateContents() {
        boolean bl = this.confirmActiveProjectChanged();
        if (bl) {
            // empty if block
        }
        return bl;
    }

    private boolean confirmActiveProjectChanged() {
        boolean bl = true;
        URI uRI = this.project.getActiveRootURI();
        if (!this.uriTree.getRoot().equals(this.activeProject) && !uRI.equals(this.activeProject)) {
            String string = "Changing the active project will cause projects higher and at the same level in the tree to be hidden.";
            int n = ModalDialog.showMessageDialog((Component)this, string = string + "\n\n Is this what you want to do?", 12);
            bl = n == 2;
        }
        return bl;
    }

    private boolean isActive(URI uRI) {
        return this.activeProject != null && this.activeProject.equals(uRI);
    }

    private boolean isLoaded(URI uRI) {
        return this.originalUriTree.isReachable(uRI);
    }

    private boolean isHidden(URI uRI) {
        return !this.isActive(uRI) && !this.uriTree.getDescendents(this.activeProject).contains(uRI);
    }

    class ProjectRenderer
    extends DefaultRenderer {
        ProjectRenderer() {
        }

        public void load(Object object) {
            URI uRI = (URI)object;
            this.setMainText(URIUtilities.getBaseName(uRI));
            boolean bl = !ManageIncludedProjectsPanel.this.isActive(uRI);
            boolean bl2 = ManageIncludedProjectsPanel.this.isHidden(uRI);
            this.setMainIcon(Icons.getProjectIcon(bl, bl2));
            if (!ManageIncludedProjectsPanel.this.isLoaded(uRI)) {
                this.appendText("    (not loaded)");
            }
        }
    }
}

