/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.Hashtable;

public class GraphPaperLayout
implements LayoutManager2 {
    int hgap;
    int vgap;
    Dimension gridSize;
    Hashtable<Component, Rectangle> compTable;

    public GraphPaperLayout() {
        this(new Dimension(1, 1));
    }

    public GraphPaperLayout(Dimension gridSize) {
        this(gridSize, 0, 0);
    }

    public GraphPaperLayout(Dimension gridSize, int hgap, int vgap) {
        if (gridSize.width <= 0 || gridSize.height <= 0) {
            throw new IllegalArgumentException("dimensions must be greater than zero");
        }
        this.gridSize = new Dimension(gridSize);
        this.hgap = hgap;
        this.vgap = vgap;
        this.compTable = new Hashtable();
    }

    public Dimension getGridSize() {
        return new Dimension(this.gridSize);
    }

    public void setGridSize(Dimension d) {
        this.setGridSize(d.width, d.height);
    }

    public void setGridSize(int width, int height) {
        this.gridSize = new Dimension(width, height);
    }

    public void setConstraints(Component comp, Rectangle constraints) {
        this.compTable.put(comp, new Rectangle(constraints));
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
        this.compTable.remove(comp);
    }

    public Dimension preferredLayoutSize(Container parent) {
        return this.getLayoutSize(parent, true);
    }

    public Dimension minimumLayoutSize(Container parent) {
        return this.getLayoutSize(parent, false);
    }

    protected Dimension getLayoutSize(Container parent, boolean isPreferred) {
        Dimension largestSize = this.getLargestCellSize(parent, isPreferred);
        Insets insets = parent.getInsets();
        largestSize.width = largestSize.width * this.gridSize.width + this.hgap * (this.gridSize.width + 1) + insets.left + insets.right;
        largestSize.height = largestSize.height * this.gridSize.height + this.vgap * (this.gridSize.height + 1) + insets.top + insets.bottom;
        return largestSize;
    }

    protected Dimension getLargestCellSize(Container parent, boolean isPreferred) {
        int ncomponents = parent.getComponentCount();
        Dimension maxCellSize = new Dimension(0, 0);
        int i = 0;
        while (i < ncomponents) {
            Component c = parent.getComponent(i);
            Rectangle rect = this.compTable.get(c);
            if (c != null && rect != null) {
                Dimension componentSize = isPreferred ? c.getPreferredSize() : c.getMinimumSize();
                maxCellSize.width = Math.max(maxCellSize.width, componentSize.width / rect.width);
                maxCellSize.height = Math.max(maxCellSize.height, componentSize.height / rect.height);
            }
            ++i;
        }
        return maxCellSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            int ncomponents = parent.getComponentCount();
            if (ncomponents == 0) {
                return;
            }
            Dimension size = parent.getSize();
            int totalW = size.width - (insets.left + insets.right);
            int totalH = size.height - (insets.top + insets.bottom);
            int totalCellW = totalW / this.gridSize.width;
            int totalCellH = totalH / this.gridSize.height;
            int cellW = (totalW - (this.gridSize.width + 1) * this.hgap) / this.gridSize.width;
            int cellH = (totalH - (this.gridSize.height + 1) * this.vgap) / this.gridSize.height;
            int i = 0;
            while (i < ncomponents) {
                Component c = parent.getComponent(i);
                Rectangle rect = this.compTable.get(c);
                if (rect != null) {
                    int x = insets.left + totalCellW * rect.x + this.hgap;
                    int y = insets.top + totalCellH * rect.y + this.vgap;
                    int w = cellW * rect.width - this.hgap;
                    int h = cellH * rect.height - this.vgap;
                    c.setBounds(x, y, w, h);
                }
                ++i;
            }
        }
    }

    public void addLayoutComponent(Component comp, Object constraints) {
        if (constraints instanceof Rectangle) {
            Rectangle rect = (Rectangle)constraints;
            if (rect.width <= 0 || rect.height <= 0) {
                throw new IllegalArgumentException("cannot add to layout: rectangle must have positive width and height");
            }
            if (rect.x < 0 || rect.y < 0) {
                throw new IllegalArgumentException("cannot add to layout: rectangle x and y must be >= 0");
            }
            this.setConstraints(comp, rect);
        } else if (constraints != null) {
            throw new IllegalArgumentException("cannot add to layout: constraint must be a Rectangle");
        }
    }

    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    public void invalidateLayout(Container target) {
    }
}

