/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.simulation.montecarlo.controller;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.xml.bind.JAXBException;
import unbbayes.io.BaseIO;
import unbbayes.io.NetIO;
import unbbayes.io.XMLBIFIO;
import unbbayes.io.exception.LoadException;
import unbbayes.prs.bn.ProbabilisticNetwork;
import unbbayes.simulation.montecarlo.gui.MCParametersPane;
import unbbayes.simulation.montecarlo.sampling.MonteCarloSampling;

public class MCController {
    private MCParametersPane tp;
    private BaseIO io;
    ProbabilisticNetwork redeProbabilistica;
    ActionListener okListener = new ActionListener(){

        public void actionPerformed(ActionEvent ae) {
            int n = MCController.this.validaNatural(MCController.this.tp.getNumeroCasos());
            if (n >= 0) {
                new MonteCarloSampling(MCController.this.redeProbabilistica, n);
                MCController.this.tp.dispose();
            } else {
                JOptionPane.showMessageDialog(null, "O numero de casos deve ser um natural", "ERROR", 0);
            }
        }
    };

    public MCController(File file) {
        String fileName = file.getName();
        this.io = fileName.endsWith(".net") ? new NetIO() : new XMLBIFIO();
        try {
            this.redeProbabilistica = this.io.load(file);
            this.tp = new MCParametersPane();
            this.adicionarListeners();
        }
        catch (LoadException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }

    public void adicionarListeners() {
        this.tp.adicionaOKListener(this.okListener);
    }

    private int validaNatural(String n) {
        try {
            int numero = Integer.parseInt(n);
            if (numero >= 0) {
                return numero;
            }
            return -1;
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }
}

