/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.simulation.likelihoodweighting.sampling;

import java.util.ArrayList;
import java.util.List;
import unbbayes.prs.Node;
import unbbayes.prs.bn.ProbabilisticNetwork;
import unbbayes.prs.bn.ProbabilisticNode;
import unbbayes.simulation.montecarlo.sampling.MonteCarloSampling;

public class LikelihoodWeightingSampling
extends MonteCarloSampling {
    protected List<Node> evidenceNodeList;
    protected float[] probabilityEvidenceGivenParentList;

    public float[] getProbabilityEvidenceGivenParentList() {
        return this.probabilityEvidenceGivenParentList;
    }

    public LikelihoodWeightingSampling(ProbabilisticNetwork pn, int nTrials) {
        super(pn, nTrials);
        this.probabilityEvidenceGivenParentList = new float[nTrials];
        int i = 0;
        while (i < this.probabilityEvidenceGivenParentList.length) {
            this.probabilityEvidenceGivenParentList[i] = 1.0f;
            ++i;
        }
    }

    protected void simulate(byte[][] sampledStatesMatrix, int nTrial) {
        ArrayList<Integer> parentsIndexes = new ArrayList();
        int[] sampledStates = new int[this.samplingNodeOrderQueue.size()];
        int i = 0;
        while (i < this.samplingNodeOrderQueue.size()) {
            ProbabilisticNode node = (ProbabilisticNode)this.samplingNodeOrderQueue.get(i);
            parentsIndexes = this.getParentsIndexesInQueue(node);
            double[] pmf = this.getProbabilityMassFunction(sampledStates, parentsIndexes, node);
            if (node.hasEvidence()) {
                sampledStates[i] = node.getEvidence();
                int n = nTrial;
                this.probabilityEvidenceGivenParentList[n] = (float)((double)this.probabilityEvidenceGivenParentList[n] * pmf[sampledStates[i]]);
            } else {
                sampledStates[i] = this.getState(pmf);
            }
            sampledStatesMatrix[nTrial][i] = (byte)sampledStates[i];
            ++i;
        }
    }
}

