/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.oobn.compiler.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import unbbayes.gui.oobn.node.OOBNNodeGraphicalWrapper;
import unbbayes.prs.Edge;
import unbbayes.prs.Network;
import unbbayes.prs.Node;
import unbbayes.prs.bn.PotentialTable;
import unbbayes.prs.bn.ProbabilisticNode;
import unbbayes.prs.msbn.SingleAgentMSBN;
import unbbayes.prs.msbn.SubNetwork;
import unbbayes.prs.oobn.IOOBNClass;
import unbbayes.prs.oobn.IOOBNNode;
import unbbayes.prs.oobn.IObjectOrientedBayesianNetwork;
import unbbayes.prs.oobn.compiler.IOOBNCompiler;
import unbbayes.prs.oobn.compiler.impl.DisconnectedNetworkToMultipleSubnetworkConverterImpl;
import unbbayes.prs.oobn.impl.DefaultOOBNNode;
import unbbayes.util.Debug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OOBNToSingleAgentMSBNCompiler
implements IOOBNCompiler {
    protected OOBNToSingleAgentMSBNCompiler() {
    }

    public static OOBNToSingleAgentMSBNCompiler newInstance() {
        return new OOBNToSingleAgentMSBNCompiler();
    }

    @Override
    public Network compile(IObjectOrientedBayesianNetwork oobn, IOOBNClass mainClass) {
        SingleAgentMSBN msbn = new SingleAgentMSBN(mainClass.getClassName());
        DefaultOOBNNode mainInstance = DefaultOOBNNode.newInstance();
        mainInstance.setParentClass(mainClass);
        mainInstance.setName(mainClass.getClassName());
        mainInstance.setType(8);
        Collection<Network> generatedNetworks = this.generateNetworksRecursively(mainInstance, "", new HashMap<String, ProbabilisticNode>());
        DisconnectedNetworkToMultipleSubnetworkConverterImpl fragmenter = DisconnectedNetworkToMultipleSubnetworkConverterImpl.newInstance();
        try {
            for (Network newNetwork : generatedNetworks) {
                for (SubNetwork subnetwork : fragmenter.generateSubnetworks(newNetwork)) {
                    msbn.addNetwork(subnetwork);
                }
            }
        }
        catch (Exception e) {
            String message = "Could not convert " + oobn.getTitle() + " using " + mainClass.getNetwork().getName() + " as main class";
            throw new RuntimeException(message, e);
        }
        return msbn;
    }

    protected Collection<Network> generateNetworksRecursively(IOOBNNode thisInstance, String prefix, Map<String, ProbabilisticNode> inputInstanceToParentCloneMap) {
        ArrayList<Network> ret = new ArrayList<Network>();
        ArrayList<IOOBNNode> usedInstances = new ArrayList<IOOBNNode>();
        HashMap<String, ProbabilisticNode> newInputInstanceToParentCloneMap = new HashMap<String, ProbabilisticNode>();
        HashMap<String, ProbabilisticNode> originalNameToCloneMap = new HashMap<String, ProbabilisticNode>();
        SubNetwork newNetwork = null;
        if (thisInstance.getName() != null && !thisInstance.getName().isEmpty()) {
            newNetwork = new SubNetwork(thisInstance.getName());
        } else {
            try {
                newNetwork = new SubNetwork(String.valueOf(prefix) + thisInstance.getParentClass().getClassName());
            }
            catch (Exception e) {
                newNetwork = new SubNetwork("Main");
            }
        }
        for (IOOBNNode node : thisInstance.getParentClass().getAllNodes()) {
            if (node.getType() == 12) continue;
            if (node.getType() == 8) {
                usedInstances.add(node);
                continue;
            }
            ProbabilisticNode probabilisticNode = (ProbabilisticNode)((ProbabilisticNode)thisInstance.getParentClass().getNetwork().getNode(node.getName())).clone();
            if (originalNameToCloneMap.put(node.getName(), probabilisticNode) != null) {
                Debug.println(this.getClass(), "There were more than one mapping from " + node.getName() + " to " + probabilisticNode.getName());
            }
            if (node.getType() == 4) {
                ProbabilisticNode parentClone = inputInstanceToParentCloneMap.get(String.valueOf(prefix) + node.getName());
                if (parentClone != null) {
                    probabilisticNode.setName(parentClone.getName());
                    float linearValue = 1.0f / (float)probabilisticNode.getStatesSize();
                    PotentialTable cpt = probabilisticNode.getPotentialTable();
                    int i = 0;
                    while (i < cpt.tableSize()) {
                        cpt.setValue(i, linearValue);
                        ++i;
                    }
                } else {
                    probabilisticNode.setName(String.valueOf(prefix) + probabilisticNode.getName());
                }
            } else {
                probabilisticNode.setName(String.valueOf(prefix) + probabilisticNode.getName());
                for (IOOBNNode child : node.getOOBNChildren()) {
                    if (child.getType() != 12) continue;
                    newInputInstanceToParentCloneMap.put(String.valueOf(prefix) + child.getName(), probabilisticNode);
                }
            }
            newNetwork.addNode(probabilisticNode);
        }
        for (Edge edge : thisInstance.getParentClass().getNetwork().getEdges()) {
            IOOBNNode originalParent = ((OOBNNodeGraphicalWrapper)edge.getOriginNode()).getWrappedNode();
            IOOBNNode originalChild = ((OOBNNodeGraphicalWrapper)edge.getDestinationNode()).getWrappedNode();
            ProbabilisticNode cloneParent = (ProbabilisticNode)originalNameToCloneMap.get(originalParent.getName());
            ProbabilisticNode cloneChild = (ProbabilisticNode)originalNameToCloneMap.get(originalChild.getName());
            if (cloneParent == null || cloneChild == null) continue;
            Edge newEdge = new Edge(cloneParent, cloneChild);
            newNetwork.getEdges().add(newEdge);
        }
        for (Node cloneNode : newNetwork.getNodes()) {
            Node nodeToAdd;
            ArrayList<Node> originalParents = new ArrayList<Node>(cloneNode.getParents());
            ArrayList<Node> originalChildren = new ArrayList<Node>(cloneNode.getChildren());
            cloneNode.clearAdjacents();
            cloneNode.getParents().clear();
            cloneNode.getChildren().clear();
            PotentialTable cpt = null;
            if (cloneNode instanceof ProbabilisticNode) {
                cpt = ((ProbabilisticNode)cloneNode).getPotentialTable();
                cpt.setVariableAt(0, cloneNode);
            }
            for (Node parent : originalParents) {
                nodeToAdd = (Node)originalNameToCloneMap.get(parent.getName());
                if (nodeToAdd == null) continue;
                cloneNode.getParents().add(nodeToAdd);
                if (cpt == null) continue;
                cpt.setVariableAt(cpt.indexOfVariable(parent), nodeToAdd);
            }
            for (Node child : originalChildren) {
                nodeToAdd = (Node)originalNameToCloneMap.get(child.getName());
                if (nodeToAdd == null) continue;
                cloneNode.getChildren().add((Node)originalNameToCloneMap.get(child.getName()));
            }
            cloneNode.makeAdjacents();
        }
        ret.add(newNetwork);
        for (IOOBNNode instance : usedInstances) {
            ret.addAll(this.generateNetworksRecursively(instance, String.valueOf(prefix) + instance.getName() + "_", newInputInstanceToParentCloneMap));
        }
        return ret;
    }
}

