/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.oobn.compiler.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import unbbayes.prs.Edge;
import unbbayes.prs.Network;
import unbbayes.prs.Node;
import unbbayes.prs.msbn.SubNetwork;
import unbbayes.prs.oobn.compiler.IDisconnectedNetworkToMultipleSubnetworkConverter;
import unbbayes.util.Debug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisconnectedNetworkToMultipleSubnetworkConverterImpl
implements IDisconnectedNetworkToMultipleSubnetworkConverter {
    protected DisconnectedNetworkToMultipleSubnetworkConverterImpl() {
    }

    public static DisconnectedNetworkToMultipleSubnetworkConverterImpl newInstance() {
        return new DisconnectedNetworkToMultipleSubnetworkConverterImpl();
    }

    private void visitRecursively(Node currentNode, SubNetwork networkToAddInto, Network referenceNetwork) {
        Edge edge;
        for (Node parent : currentNode.getParents()) {
            edge = referenceNetwork.getEdge(parent, currentNode);
            if (edge != null && networkToAddInto.getEdges().contains(edge)) continue;
            if (edge != null) {
                if (!networkToAddInto.getNodes().contains(parent)) {
                    networkToAddInto.addNode(parent);
                }
                networkToAddInto.getEdges().add(edge);
                this.visitRecursively(parent, networkToAddInto, referenceNetwork);
                continue;
            }
            throw new NullPointerException(String.valueOf(parent.getName()) + "->" + currentNode.getName());
        }
        for (Node child : currentNode.getChildren()) {
            edge = referenceNetwork.getEdge(currentNode, child);
            if (edge != null && networkToAddInto.getEdges().contains(edge)) continue;
            if (edge != null) {
                if (!networkToAddInto.getNodes().contains(child)) {
                    networkToAddInto.addNode(child);
                }
                networkToAddInto.getEdges().add(edge);
                this.visitRecursively(child, networkToAddInto, referenceNetwork);
                continue;
            }
            throw new NullPointerException(String.valueOf(currentNode.getName()) + "->" + child.getName());
        }
    }

    @Override
    public Collection<SubNetwork> generateSubnetworks(Network net) {
        HashSet<SubNetwork> ret = new HashSet<SubNetwork>();
        ArrayList<Node> treatedNodes = new ArrayList<Node>();
        try {
            for (Node currentNode : net.getNodes()) {
                if (treatedNodes.contains(currentNode)) continue;
                SubNetwork networkToAddInto = null;
                networkToAddInto = ret.size() <= 0 ? new SubNetwork(net.getName()) : new SubNetwork(String.valueOf(net.getName()) + "_" + ret.size());
                networkToAddInto.addNode(currentNode);
                this.visitRecursively(currentNode, networkToAddInto, net);
                if (networkToAddInto.getNodes().size() > 1) {
                    ret.add(networkToAddInto);
                }
                treatedNodes.addAll(networkToAddInto.getNodes());
            }
        }
        catch (Exception e) {
            Debug.println(this.getClass(), "Error fragmenting disconnected network", e);
            return ret;
        }
        return ret;
    }
}

