/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.msbn;

import java.util.ArrayList;
import java.util.List;
import unbbayes.prs.Node;
import unbbayes.prs.bn.Clique;
import unbbayes.prs.bn.JunctionTree;
import unbbayes.prs.bn.PotentialTable;
import unbbayes.prs.bn.Separator;
import unbbayes.prs.msbn.Link;
import unbbayes.prs.msbn.SubNetwork;
import unbbayes.util.SetToolkit;

public class Linkage {
    private SubNetwork n1;
    private SubNetwork n2;
    private ArrayList<Node> nodes;
    private JunctionTree jt;
    private ArrayList<Link> linkList;

    public Linkage(SubNetwork n1, SubNetwork n2) {
        this.n1 = n1;
        this.n2 = n2;
        this.linkList = new ArrayList();
        n1.addAdjacent(n2);
        n2.setParent(n1);
        this.nodes = SetToolkit.intersection(n1.getNodes(), n2.getNodes());
    }

    protected void makeLinkageTree() throws Exception {
        this.linkList.clear();
        this.jt = new JunctionTree();
        Clique root = this.n1.getJunctionTree().getCliques().get(0);
        this.makeCliqueList(root);
        this.remove1stPass();
        this.remove2ndPass();
        this.assignV1();
        int i = this.linkList.size() - 1;
        while (i >= 0) {
            System.out.println("-------");
            System.out.println(this.linkList.get(i));
            System.out.println("-------");
            --i;
        }
        System.out.println();
        this.initTables();
    }

    private void remove1stPass() {
        boolean retirou = true;
        while (retirou) {
            retirou = false;
            int i = this.linkList.size() - 1;
            while (i >= 0) {
                Link link = this.linkList.get(i);
                Clique c = link.getClique();
                if (c.getChildrenSize() == 0) {
                    if (c.getNodes().size() == 0) {
                        this.removeLink(link);
                        retirou = true;
                    } else if (c.getParent() != null && c.getParent().getNodes().containsAll(c.getNodes())) {
                        this.removeLink(link);
                        retirou = true;
                    }
                }
                --i;
            }
        }
    }

    private void remove2ndPass() {
        int i = this.linkList.size() - 1;
        while (i >= 0) {
            Link link = this.linkList.get(i);
            Clique c = link.getClique();
            if (c.getParent() != null && c.getParent().getNodes().containsAll(c.getNodes())) {
                this.removeLink(link);
            } else {
                int j = c.getChildrenSize() - 1;
                while (j >= 0) {
                    Clique c2 = c.getChildAt(j);
                    if (c2.getNodes().containsAll(c.getNodes())) {
                        this.removeLink(link);
                        break;
                    }
                    --j;
                }
            }
            --i;
        }
    }

    private void assignV1() {
        List<Clique> cliquesN2 = this.n2.getJunctionTree().getCliques();
        int i = this.linkList.size() - 1;
        while (i >= 0) {
            Link link = this.linkList.get(i);
            Clique c = link.getClique();
            int j = cliquesN2.size() - 1;
            while (j >= 0) {
                Clique c2 = cliquesN2.get(j);
                if (c2.getNodes().containsAll(c.getNodes())) {
                    link.setHost1(c2);
                    break;
                }
                --j;
            }
            --i;
        }
    }

    private void initTables() throws Exception {
        this.insertSeparators();
        int i = this.linkList.size() - 1;
        while (i >= 0) {
            Link l = this.linkList.get(i);
            Clique c = l.getClique();
            PotentialTable tab = c.getPotentialTable();
            int j = 0;
            while (j < c.getNodes().size()) {
                tab.addVariable(c.getNodes().get(j));
                ++j;
            }
            j = tab.tableSize() - 1;
            while (j >= 0) {
                tab.setValue(j, 1.0f);
                --j;
            }
            --i;
        }
        int k = this.jt.getSeparatorsSize() - 1;
        while (k >= 0) {
            Separator auxSep = this.jt.getSeparatorAt(k);
            PotentialTable tab = auxSep.getPotentialTable();
            int c = 0;
            while (c < auxSep.getNodes().size()) {
                tab.addVariable(auxSep.getNodes().get(c));
                ++c;
            }
            int j = tab.tableSize() - 1;
            while (j >= 0) {
                tab.setValue(j, 1.0f);
                --j;
            }
            --k;
        }
    }

    private void insertSeparators() {
        int i = this.jt.getCliques().size() - 1;
        while (i >= 0) {
            Clique c = this.jt.getCliques().get(i);
            int j = c.getChildrenSize() - 1;
            while (j >= 0) {
                Separator sep = new Separator(c, c.getChildAt(j), false);
                sep.setNodes(SetToolkit.intersection(c.getNodes(), c.getChildAt(j).getNodes()));
                this.jt.addSeparator(sep);
                --j;
            }
            --i;
        }
    }

    private void removeLink(Link l) {
        this.linkList.remove(l);
        Clique c = l.getClique();
        this.jt.getCliques().remove(c);
        if (c.getParent() != null) {
            c.getParent().removeChild(c);
            int i = c.getChildrenSize() - 1;
            while (i >= 0) {
                Clique child = c.getChildAt(i);
                c.getParent().addChild(child);
                child.setParent(c.getParent());
                --i;
            }
        }
    }

    private Clique makeCliqueList(Clique c) {
        Clique cliqueClone = new Clique();
        cliqueClone.getNodes().addAll(SetToolkit.intersection(c.getNodes(), this.nodes));
        Link l = new Link(cliqueClone);
        l.setHost0(c);
        this.linkList.add(l);
        this.jt.getCliques().add(cliqueClone);
        int i = c.getChildrenSize() - 1;
        while (i >= 0) {
            Clique c2 = this.makeCliqueList(c.getChildAt(i));
            c2.setParent(cliqueClone);
            cliqueClone.addChild(c2);
            --i;
        }
        return cliqueClone;
    }

    public SubNetwork getNet1() {
        return this.n1;
    }

    public SubNetwork getNet2() {
        return this.n2;
    }

    protected void absorb(boolean naOrdem) throws Exception {
        Link l;
        int treeSize = this.linkList.size();
        int i = 0;
        while (i < treeSize) {
            l = this.linkList.get(i);
            l.absorbIn(naOrdem);
            ++i;
        }
        this.removeRedundance();
        i = 0;
        while (i < treeSize) {
            l = this.linkList.get(i);
            l.absorbOut(naOrdem);
            ++i;
        }
        SubNetwork net = naOrdem ? this.n1 : this.n2;
        net.getJunctionTree().consistency();
        net.updateMarginais();
    }

    private void removeRedundance() {
        int i = this.jt.getSeparatorsSize() - 1;
        while (i >= 0) {
            Separator sep = this.jt.getSeparatorAt(i);
            PotentialTable oldRedTab = (PotentialTable)sep.getPotentialTable().clone();
            ArrayList<Node> toDie = SetToolkit.clone(sep.getClique2().getNodes());
            toDie.removeAll(sep.getNodes());
            PotentialTable tA = (PotentialTable)sep.getClique2().getPotentialTable().clone();
            int j = toDie.size() - 1;
            while (j >= 0) {
                tA.removeVariable(toDie.get(i));
                --j;
            }
            j = tA.tableSize() - 1;
            while (j >= 0) {
                sep.getPotentialTable().setValue(j, tA.getValue(j));
                --j;
            }
            j = this.linkList.size() - 1;
            while (j >= 0) {
                Link l = this.linkList.get(j);
                if (l.getClique() == sep.getClique2()) {
                    l.removeRedundancy(tA, oldRedTab);
                    break;
                }
                --j;
            }
            --i;
        }
    }
}

