/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.mebn.ssbn;

import java.util.List;
import unbbayes.prs.bn.ProbabilisticNetwork;
import unbbayes.prs.bn.ProbabilisticNode;
import unbbayes.prs.mebn.ssbn.Query;
import unbbayes.prs.mebn.ssbn.SSBNNode;
import unbbayes.prs.mebn.ssbn.SSBNWarning;
import unbbayes.prs.mebn.ssbn.exception.SSBNNodeGeneralException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SituationSpecificBayesianNetwork {
    private final ProbabilisticNetwork probabilisticNetwork;
    private final List<SSBNNode> findingList;
    private final List<Query> queryList;
    private List<SSBNWarning> warningList;
    private State state = State.INITIAL;

    public SituationSpecificBayesianNetwork(ProbabilisticNetwork pn, List<SSBNNode> findingList, List<Query> queryList) {
        this.probabilisticNetwork = pn;
        this.findingList = findingList;
        this.queryList = queryList;
    }

    public void compileAndInitializeSSBN() throws Exception {
        this.compileNetwork();
        System.out.println("Network compiled");
        this.addFindings();
        System.out.println("Findings setted");
        this.propagateFindings();
        System.out.println("Findings propagated");
    }

    public void reinitializeSSBN() throws Exception {
        this.probabilisticNetwork.initialize();
        this.addFindings();
        System.out.println("Findings setted");
        this.propagateFindings();
        System.out.println("Findings propagated");
    }

    private void compileNetwork() throws Exception {
        this.probabilisticNetwork.compile();
        this.state = State.COMPILED;
    }

    private void addFindings() throws SSBNNodeGeneralException {
        for (SSBNNode findingNode : this.findingList) {
            System.out.println("Set finding: " + findingNode + "=" + findingNode.getValue());
            ProbabilisticNode node = findingNode.getProbNode();
            String nameState = findingNode.getValue().getName();
            boolean ok = false;
            int i = 0;
            while (i < node.getStatesSize()) {
                if (node.getStateAt(i).equals(nameState)) {
                    node.addFinding(i);
                    ok = true;
                    break;
                }
                ++i;
            }
            if (ok) continue;
            throw new SSBNNodeGeneralException();
        }
        this.state = State.WITH_FINDINGS;
    }

    private void propagateFindings() throws Exception {
        this.probabilisticNetwork.updateEvidences();
        this.state = State.FINDINGS_PROPAGATED;
    }

    public ProbabilisticNetwork getPn() {
        return this.probabilisticNetwork;
    }

    public List<SSBNNode> getFindingList() {
        return this.findingList;
    }

    public List<Query> getQueryList() {
        return this.queryList;
    }

    public List<SSBNWarning> getWarningList() {
        return this.warningList;
    }

    public void setWarningList(List<SSBNWarning> warningList) {
        this.warningList = warningList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        INITIAL,
        COMPILED,
        WITH_FINDINGS,
        FINDINGS_PROPAGATED,
        USER_ACTION;

    }
}

