/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.mebn.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import unbbayes.prs.mebn.entity.Type;
import unbbayes.prs.mebn.entity.exception.TypeAlreadyExistsException;
import unbbayes.prs.mebn.entity.exception.TypeDoesNotExistException;
import unbbayes.prs.mebn.entity.exception.TypeIsInUseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeContainer {
    private Set<Type> listOfTypes = new TreeSet<Type>();
    public static Type typeBoolean;
    public static Type typeCategoryLabel;
    public static Type typeLabel;

    public TypeContainer() {
        try {
            typeBoolean = new Type("Boolean");
            typeCategoryLabel = new Type("CategoryLabel");
            typeLabel = new Type("TypeLabel");
            this.listOfTypes.add(typeBoolean);
            this.listOfTypes.add(typeCategoryLabel);
            this.listOfTypes.add(typeLabel);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removeType(String oldType) throws TypeDoesNotExistException, TypeIsInUseException {
        for (Type type : this.listOfTypes) {
            if (type.getName() == oldType) {
                type.delete();
                this.listOfTypes.remove(type);
                continue;
            }
            throw new TypeDoesNotExistException();
        }
    }

    public Type createType(String nameType) throws TypeAlreadyExistsException {
        Type newType = new Type(nameType, this);
        this.listOfTypes.add(newType);
        return newType;
    }

    public void removeType(Type type) throws TypeDoesNotExistException {
        if (!this.listOfTypes.contains(type)) {
            throw new TypeDoesNotExistException();
        }
        this.listOfTypes.remove(type);
    }

    public boolean hasType(Type type) {
        return this.listOfTypes.contains(type);
    }

    public static Type getDefaultType() {
        return typeCategoryLabel;
    }

    public Set<Type> getListOfTypes() {
        return this.listOfTypes;
    }

    public List<String> getTypesNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (Type type : this.listOfTypes) {
            list.add(type.getName());
        }
        return list;
    }

    public String getLabelSuffix() {
        return "_label";
    }

    public Type getType(String aType) {
        for (Type type : this.listOfTypes) {
            if (!type.getName().equals(aType)) continue;
            return type;
        }
        return null;
    }
}

