/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.mebn.context;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import unbbayes.prs.mebn.OrdinaryVariable;
import unbbayes.prs.mebn.ResidentNodePointer;
import unbbayes.prs.mebn.context.EnumSubType;
import unbbayes.prs.mebn.context.EnumType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeFormulaTree {
    private String name;
    private String mnemonic;
    private EnumType type;
    private EnumSubType subType;
    private Object nodeVariable;
    private ArrayList<NodeFormulaTree> children;

    public NodeFormulaTree(String _name, EnumType _type, EnumSubType _subType, Object _nodeVariable) {
        this.name = _name;
        this.type = _type;
        this.subType = _subType;
        this.nodeVariable = _nodeVariable;
        this.children = new ArrayList();
    }

    public Set<OrdinaryVariable> getVariableList() {
        HashSet<OrdinaryVariable> set = new HashSet<OrdinaryVariable>();
        block0 : switch (this.type) {
            case OPERAND: {
                switch (this.subType) {
                    case OVARIABLE: {
                        set.add((OrdinaryVariable)this.getNodeVariable());
                        break block0;
                    }
                    case NODE: {
                        ResidentNodePointer node = (ResidentNodePointer)this.getNodeVariable();
                        set.addAll(node.getOrdinaryVariableList());
                    }
                }
            }
        }
        for (NodeFormulaTree child : this.getChildren()) {
            set.addAll(child.getVariableList());
        }
        return set;
    }

    public Set<OrdinaryVariable> getExemplarList() {
        return null;
    }

    public boolean isFormulaValida() {
        return true;
    }

    public void addChild(NodeFormulaTree child) {
        this.children.add(child);
    }

    public void removeChild(NodeFormulaTree child) {
        this.children.remove(child);
    }

    public void removeAllChildren() {
        this.children.clear();
    }

    public List<NodeFormulaTree> getChildren() {
        return this.children;
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public EnumType getTypeNode() {
        return this.type;
    }

    public void setTypeNode(EnumType _type) {
        this.type = _type;
    }

    public EnumSubType getSubTypeNode() {
        return this.subType;
    }

    public void setSubTypeNode(EnumSubType _subType) {
        this.subType = _subType;
    }

    public Object getNodeVariable() {
        return this.nodeVariable;
    }

    public void setNodeVariable(Object nodeVariable) {
        this.nodeVariable = nodeVariable;
    }

    public String getMnemonic() {
        return this.mnemonic;
    }

    public void setMnemonic(String mnemonic) {
        this.mnemonic = mnemonic;
    }

    public String getFormulaViewText() {
        switch (this.type) {
            case OPERAND: {
                switch (this.subType) {
                    case NODE: {
                        ResidentNodePointer pointer = (ResidentNodePointer)this.nodeVariable;
                        String returnName = String.valueOf(this.name) + "(";
                        int numberAguments = pointer.getNumberArguments();
                        int i = 0;
                        while (i < numberAguments - 1) {
                            if (pointer.getArgument(i) != null) {
                                returnName = String.valueOf(returnName) + pointer.getArgument(i).getName();
                            }
                            returnName = String.valueOf(returnName) + ",";
                            ++i;
                        }
                        if (numberAguments > 0 && pointer.getArgument(numberAguments - 1) != null) {
                            returnName = String.valueOf(returnName) + pointer.getArgument(numberAguments - 1).getName();
                        }
                        return String.valueOf(returnName) + ")";
                    }
                }
                return this.name;
            }
            case SIMPLE_OPERATOR: {
                if (this.children.size() == 2) {
                    return "( " + this.children.get(0).getFormulaViewText() + " " + this.mnemonic + " " + this.children.get(1).getFormulaViewText() + " )";
                }
                if (this.children.size() == 1) {
                    return "( " + this.mnemonic + " " + this.children.get(0).getFormulaViewText() + " )";
                }
                return " ";
            }
            case QUANTIFIER_OPERATOR: {
                String formula = "";
                formula = String.valueOf(formula) + "( " + this.mnemonic;
                formula = String.valueOf(formula) + "( ";
                NodeFormulaTree exemplarList = this.children.get(0);
                int exemplarListSize = exemplarList.getChildren().size();
                int i = 0;
                while (i < exemplarListSize) {
                    formula = String.valueOf(formula) + exemplarList.getChildren().get(i).getName();
                    if (i < exemplarListSize - 1) {
                        formula = String.valueOf(formula) + ",";
                    }
                    ++i;
                }
                formula = String.valueOf(formula) + " )";
                formula = String.valueOf(formula) + this.children.get(1).getFormulaViewText();
                formula = String.valueOf(formula) + ")";
                return formula;
            }
        }
        return " ";
    }
}

