/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.mebn;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import unbbayes.draw.DrawTwoBaseRectangle;
import unbbayes.prs.mebn.BuiltInRV;
import unbbayes.prs.mebn.MFrag;
import unbbayes.prs.mebn.MultiEntityNode;
import unbbayes.prs.mebn.OrdinaryVariable;
import unbbayes.prs.mebn.ResidentNode;
import unbbayes.prs.mebn.ResidentNodePointer;
import unbbayes.prs.mebn.entity.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputNode
extends MultiEntityNode {
    private static final long serialVersionUID = 1L;
    private MFrag mFrag;
    private List<ResidentNode> residentNodeChildList;
    private ResidentNodePointer residentNodePointer;
    private BuiltInRV inputInstanceOfRV;
    private ResidentNode inputInstanceOfNode;
    private DrawTwoBaseRectangle drawInputNode;
    private static Color color = new Color(220, 220, 220);

    @Deprecated
    public InputNode() {
    }

    public InputNode(String name, MFrag mFrag) {
        this.setName(name);
        this.setLabel(" ");
        this.mFrag = mFrag;
        this.residentNodeChildList = new ArrayList<ResidentNode>();
        InputNode.size.x = 100.0;
        InputNode.size.y = 20.0;
        this.drawInputNode = new DrawTwoBaseRectangle(this.position, size);
        this.drawElement.add(this.drawInputNode);
    }

    @Override
    public void setSelected(boolean b) {
        this.drawInputNode.setSelected(b);
        super.setSelected(b);
    }

    public static Color getColor() {
        return color;
    }

    public static void setColor(int c) {
        color = new Color(c);
    }

    @Override
    public void paint(Graphics2D graphics) {
        this.drawInputNode.setFillColor(InputNode.getColor());
        super.paint(graphics);
    }

    public void updateLabel() {
        Object inputInstanceOf = this.getInputInstanceOf();
        if (inputInstanceOf != null) {
            if (inputInstanceOf instanceof ResidentNode) {
                ResidentNodePointer pointer = this.getResidentNodePointer();
                String newLabel = "";
                newLabel = String.valueOf(newLabel) + pointer.getResidentNode().getName();
                newLabel = String.valueOf(newLabel) + "(";
                for (OrdinaryVariable ov : pointer.getOrdinaryVariableList()) {
                    newLabel = ov != null ? String.valueOf(newLabel) + ov.getName() : String.valueOf(newLabel) + " ";
                    newLabel = String.valueOf(newLabel) + ",";
                }
                if (pointer.getOrdinaryVariableList().size() > 0) {
                    newLabel = newLabel.substring(0, newLabel.length() - 1);
                }
                newLabel = String.valueOf(newLabel) + ")";
                this.setLabel(newLabel);
            } else {
                this.setLabel(((BuiltInRV)inputInstanceOf).getName());
            }
        } else {
            this.setLabel(" ");
        }
    }

    public void updateResidentNodePointer() {
        if (this.residentNodePointer != null) {
            this.residentNodePointer = new ResidentNodePointer(this.residentNodePointer.getResidentNode(), this);
        }
    }

    public void setInputInstanceOf(BuiltInRV rv) {
        this.inputInstanceOfNode = null;
        this.inputInstanceOfRV = rv;
        rv.addInputInstance(this);
        this.updateLabel();
        this.residentNodePointer = null;
    }

    public void setInputInstanceOf(ResidentNode node) {
        if (this.inputInstanceOfNode != null) {
            if (this.inputInstanceOfNode == node) {
                return;
            }
            this.inputInstanceOfNode.removeInputInstanceFromList(this);
        }
        this.inputInstanceOfRV = null;
        this.inputInstanceOfNode = node;
        this.residentNodePointer = new ResidentNodePointer(node, this);
        node.addInputInstanceFromList(this);
        this.updateLabel();
    }

    public void setInputInstanceOf() {
        this.inputInstanceOfRV = null;
        this.inputInstanceOfNode = null;
        this.updateLabel();
        this.residentNodePointer = null;
    }

    public Object getInputInstanceOf() {
        if (this.inputInstanceOfNode != null) {
            return this.inputInstanceOfNode;
        }
        return this.inputInstanceOfRV;
    }

    public void removeResidentNodeChild(ResidentNode node) {
        this.residentNodeChildList.remove(node);
        node.removeInputNodeFatherList(this);
    }

    public void addResidentNodeChild(ResidentNode resident) {
        this.residentNodeChildList.add(resident);
        resident.addInputNodeFather(this);
    }

    public List<ResidentNode> getResidentNodeChildList() {
        return this.residentNodeChildList;
    }

    public Vector<OrdinaryVariable> getOrdinaryVariableList() {
        return this.residentNodePointer.getOrdinaryVariableList();
    }

    public OrdinaryVariable getOrdinaryVariableByIndex(int index) {
        if (this.residentNodePointer.getNumberArguments() < index || index < 0) {
            return null;
        }
        return this.residentNodePointer.getArgument(index);
    }

    public OrdinaryVariable getOrdinaryVariableByName(String name) {
        for (OrdinaryVariable ordinaryVariable : this.residentNodePointer.getOrdinaryVariableList()) {
            if (!ordinaryVariable.getName().equals(name)) continue;
            return ordinaryVariable;
        }
        return null;
    }

    public Vector<Type> getTypesOfOrdinaryVariableList() {
        return this.residentNodePointer.getTypesOfOrdinaryVariableList();
    }

    public ResidentNodePointer getResidentNodePointer() {
        return this.residentNodePointer;
    }

    @Override
    public MFrag getMFrag() {
        return this.mFrag;
    }

    public void delete() {
        while (!this.residentNodeChildList.isEmpty()) {
            ResidentNode resident = this.residentNodeChildList.get(0);
            this.removeResidentNodeChild(resident);
            this.mFrag.removeEdgeByNodes(this, resident);
        }
        this.mFrag.removeInputNode(this);
    }

    @Override
    public String toString() {
        if (this.residentNodePointer != null) {
            return this.residentNodePointer.getResidentNode().toString();
        }
        return " ";
    }
}

