/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.id;

import java.io.Serializable;
import unbbayes.prs.Node;
import unbbayes.prs.bn.PotentialTable;
import unbbayes.prs.id.DecisionNode;

public class UtilityTable
extends PotentialTable
implements Serializable {
    private static final long serialVersionUID = 0L;

    public PotentialTable newInstance() {
        return new UtilityTable();
    }

    public void removeVariable(Node variavel) {
        this.calcularFatores();
        int index = this.variaveis.indexOf(variavel);
        if (variavel.getType() == 0) {
            this.sum(index);
        } else {
            DecisionNode decision = (DecisionNode)variavel;
            if (decision.hasEvidence()) {
                this.finding(this.variaveis.size() - 1, index, new int[this.variaveis.size()], decision.getEvidence());
            } else {
                this.argMax(this.variaveis.size() - 1, index, new int[this.variaveis.size()]);
            }
        }
        this.variableModified();
        this.variaveis.remove(index);
    }

    public void removeVariable(Node variable, boolean normalize) {
        this.removeVariable(variable);
    }

    protected void argMax(int control, int index, int[] coord) {
        if (control == -1) {
            float value;
            int linearCoordToKill = this.getLinearCoord(coord);
            int linearCoordDestination = linearCoordToKill - coord[index] * this.fatores[index];
            this.dados.data[linearCoordDestination] = value = Math.max(this.dados.data[linearCoordDestination], this.dados.data[linearCoordToKill]);
            this.dados.remove(linearCoordToKill);
            return;
        }
        int fim = index == control ? 1 : 0;
        Node node = (Node)this.variaveis.get(control);
        int i = node.getStatesSize() - 1;
        while (i >= fim) {
            coord[control] = i--;
            this.argMax(control - 1, index, coord);
        }
    }
}

