/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.id;

import java.awt.Color;
import java.awt.Graphics2D;
import java.io.Serializable;
import unbbayes.draw.DrawRectangle;
import unbbayes.prs.bn.Clique;
import unbbayes.prs.bn.PotentialTable;
import unbbayes.prs.bn.TreeVariable;
import unbbayes.util.SetToolkit;

public class DecisionNode
extends TreeVariable
implements Serializable {
    private static final long serialVersionUID = -4746720812779139329L;
    private static Color color = Color.orange;
    private DrawRectangle drawRectangle;

    public DecisionNode() {
        this.drawRectangle = new DrawRectangle(this.position, size);
        this.drawElement.add(this.drawRectangle);
    }

    public Object clone() {
        DecisionNode cloned = new DecisionNode();
        DecisionNode.setColor(DecisionNode.getColor().getRGB());
        cloned.setDescription(this.getDescription());
        cloned.setName(this.getName());
        cloned.setPosition(this.getPosition().getX(), this.getPosition().getY());
        cloned.setParents(SetToolkit.clone(this.parents));
        cloned.setChildren(SetToolkit.clone(this.getChildren()));
        cloned.setStates(SetToolkit.clone(this.states));
        cloned.setAdjacents(SetToolkit.clone(this.getAdjacents()));
        cloned.setSelected(this.isSelected());
        cloned.setExplanationDescription(this.getExplanationDescription());
        cloned.setPhrasesMap(this.getPhrasesMap());
        cloned.setInformationType(this.getInformationType());
        float[] marginais = new float[this.marginalList.length];
        System.arraycopy(this.marginalList, 0, marginais, 0, marginais.length);
        cloned.marginalList = marginais;
        return cloned;
    }

    public int getType() {
        return 2;
    }

    public static Color getColor() {
        return color;
    }

    public static void setColor(int rgb) {
        color = new Color(rgb);
    }

    public void setSelected(boolean b) {
        this.drawRectangle.setSelected(b);
        super.setSelected(b);
    }

    public void paint(Graphics2D graphics) {
        this.drawRectangle.setFillColor(DecisionNode.getColor());
        super.paint(graphics);
    }

    protected void marginal() {
        this.marginalList = new float[this.getStatesSize()];
        PotentialTable auxTab = (PotentialTable)((Clique)this.cliqueAssociado).getUtilityTable().clone();
        auxTab.directOpTab(this.cliqueAssociado.getPotentialTable(), 0);
        int index = auxTab.indexOfVariable(this);
        int i = 0;
        while (i < this.cliqueAssociado.getPotentialTable().variableCount()) {
            if (i != index) {
                auxTab.removeVariable(this.cliqueAssociado.getPotentialTable().getVariableAt(i));
            }
            ++i;
        }
        if (this.hasEvidence()) {
            this.marginalList[this.getEvidence()] = auxTab.getValue(this.getEvidence());
        } else {
            int tableSize = auxTab.tableSize();
            int i2 = 0;
            while (i2 < tableSize) {
                this.marginalList[i2] = auxTab.getValue(i2);
                ++i2;
            }
        }
    }
}

