/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.hybridbn;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBException;
import unbbayes.io.XMLBIFIO;
import unbbayes.io.exception.LoadException;
import unbbayes.prs.Node;
import unbbayes.prs.bn.ProbabilisticNetwork;
import unbbayes.prs.bn.ProbabilisticNode;
import unbbayes.prs.bn.TreeVariable;
import unbbayes.prs.hybridbn.CNNormalDistribution;
import unbbayes.prs.hybridbn.ContinuousNode;
import unbbayes.util.SortUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GaussianMixture {
    protected ProbabilisticNetwork pn;
    protected ProbabilisticNetwork clonedPN;
    protected List<Node> nodeOrderQueue;
    private List<Node> discreteNodeList;
    private List<Node> continuousNodeList;

    public List<Node> getNodeOrderQueue() {
        return this.nodeOrderQueue;
    }

    public GaussianMixture(ProbabilisticNetwork pn) {
        this.pn = pn;
        this.clonedPN = this.clonePN(pn);
        this.discreteNodeList = new ArrayList<Node>();
        this.continuousNodeList = new ArrayList<Node>();
        for (Node node : pn.getNodes()) {
            if (node.getType() == 5) {
                this.continuousNodeList.add(node);
                continue;
            }
            this.discreteNodeList.add(node);
        }
        this.init();
    }

    protected void init() {
        this.nodeOrderQueue = new ArrayList<Node>();
        this.createOrderQueue();
    }

    protected void createOrderQueue() {
        boolean[] nodeAddedList = new boolean[this.continuousNodeList.size()];
        this.initOrderQueue(nodeAddedList);
        int i = 0;
        while (i < this.nodeOrderQueue.size()) {
            Node node = this.nodeOrderQueue.get(i);
            this.addToOrderQueue(node.getChildren(), nodeAddedList);
            ++i;
        }
    }

    protected void initOrderQueue(boolean[] nodeAddedList) {
        int i = 0;
        while (i < this.continuousNodeList.size()) {
            Node node = this.continuousNodeList.get(i);
            boolean hasContinuousParent = false;
            for (Node parentNode : node.getParents()) {
                if (parentNode.getType() != 5) continue;
                hasContinuousParent = true;
                break;
            }
            if (!hasContinuousParent) {
                nodeAddedList[i] = true;
                this.nodeOrderQueue.add(node);
            }
            ++i;
        }
    }

    protected void addToOrderQueue(ArrayList<Node> children, boolean[] nodeAddedList) {
        int i = 0;
        while (i < children.size()) {
            Node n1 = children.get(i);
            int j = 0;
            while (j < this.continuousNodeList.size()) {
                Node n2 = this.continuousNodeList.get(j);
                if (n1.getName().equals(n2.getName()) && !nodeAddedList[j]) {
                    this.nodeOrderQueue.add(n1);
                    nodeAddedList[j] = true;
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    public void run() throws Exception {
        int i = 0;
        while (i < this.nodeOrderQueue.size()) {
            Node node = this.nodeOrderQueue.get(i);
            ArrayList<Node> discreteParentList = new ArrayList<Node>();
            ArrayList<Node> continuousParentList = new ArrayList<Node>();
            for (Node parentNode : this.clonedPN.getNode(node.getName()).getParents()) {
                if (parentNode.getType() == 0) {
                    discreteParentList.add(parentNode);
                    continue;
                }
                if (parentNode.getType() != 5) continue;
                continuousParentList.add(parentNode);
            }
            SortUtil.sortNodeListByName(discreteParentList);
            SortUtil.sortNodeListByName(continuousParentList);
            HashMap<String, Boolean> nodeVisitedBeforeMap = new HashMap<String, Boolean>();
            for (Node discreteNode : this.pn.getNodes()) {
                if (discreteNode.getType() != 0) continue;
                nodeVisitedBeforeMap.put(discreteNode.getName(), false);
            }
            int j = 0;
            while (j < discreteParentList.size()) {
                boolean nodeVisitedBefore = (Boolean)nodeVisitedBeforeMap.get(((Node)discreteParentList.get(j)).getName());
                if (!nodeVisitedBefore) {
                    ArrayList<Node> nodeInNetworkList = new ArrayList<Node>();
                    this.addAdjacentNodes(this.clonedPN.getNode(((Node)discreteParentList.get(j)).getName()), nodeInNetworkList);
                    ArrayList<Node> nodeToRemoveList = new ArrayList<Node>();
                    for (Node nodeToRemove : this.clonedPN.getNodes()) {
                        if (nodeInNetworkList.contains(nodeToRemove)) continue;
                        nodeToRemoveList.add(nodeToRemove);
                    }
                    for (Node nodeToRemove : nodeToRemoveList) {
                        this.clonedPN.removeNode(nodeToRemove);
                    }
                    this.clonedPN.compile();
                    for (Node nodeToGetMarginal : this.clonedPN.getNodes()) {
                        TreeVariable variableToGetMarginal = (TreeVariable)nodeToGetMarginal;
                        TreeVariable variable = (TreeVariable)this.pn.getNode(nodeToGetMarginal.getName());
                        float[] values = new float[variable.getStatesSize()];
                        int stateIndex = 0;
                        while (stateIndex < variable.getStatesSize()) {
                            values[stateIndex] = variableToGetMarginal.getMarginalAt(stateIndex);
                            ++stateIndex;
                        }
                        variable.initMarginalList();
                        variable.addLikeliHood(values);
                        nodeVisitedBeforeMap.put(nodeToGetMarginal.getName(), true);
                    }
                    this.clonedPN = this.clonePN(this.pn);
                }
                ++j;
            }
            CNNormalDistribution cDistribution = ((ContinuousNode)node).getCnNormalDistribution();
            double[] partialMeanList = new double[cDistribution.functionSize()];
            double[] partialVarianceList = new double[cDistribution.functionSize()];
            double[] probabilityList = new double[cDistribution.functionSize()];
            double weightedMean = 0.0;
            int ndfIndex = 0;
            while (ndfIndex < cDistribution.functionSize()) {
                partialMeanList[ndfIndex] = cDistribution.getMean(ndfIndex);
                partialVarianceList[ndfIndex] = cDistribution.getVariance(ndfIndex);
                int parentIndex = 0;
                while (parentIndex < cDistribution.getContinuousParentList().size()) {
                    TreeVariable variable = (TreeVariable)cDistribution.getContinuousParentList().get(parentIndex);
                    double meanWithoutConstant = variable.getMarginalAt(0);
                    double varianceWithoutConstant = variable.getMarginalAt(1);
                    int n = ndfIndex;
                    partialMeanList[n] = partialMeanList[n] + cDistribution.getConstantAt(parentIndex, ndfIndex) * meanWithoutConstant;
                    int n2 = ndfIndex;
                    partialVarianceList[n2] = partialVarianceList[n2] + Math.pow(cDistribution.getConstantAt(parentIndex, ndfIndex), 2.0) * varianceWithoutConstant;
                    ++parentIndex;
                }
                int[] parentsStatesConfiguration = cDistribution.getMultidimensionalCoord(ndfIndex);
                probabilityList[ndfIndex] = 1.0;
                int parentIndex2 = 0;
                while (parentIndex2 < parentsStatesConfiguration.length) {
                    int n = ndfIndex;
                    probabilityList[n] = probabilityList[n] * (double)((TreeVariable)this.pn.getNode(((Node)discreteParentList.get(parentIndex2)).getName())).getMarginalAt(parentsStatesConfiguration[parentIndex2]);
                    ++parentIndex2;
                }
                weightedMean += probabilityList[ndfIndex] * partialMeanList[ndfIndex];
                ++ndfIndex;
            }
            double weightedVariance = 0.0;
            int ndfIndex2 = 0;
            while (ndfIndex2 < cDistribution.functionSize()) {
                weightedVariance += probabilityList[ndfIndex2] * (partialVarianceList[ndfIndex2] + Math.pow(partialMeanList[ndfIndex2], 2.0) - Math.pow(weightedMean, 2.0));
                ++ndfIndex2;
            }
            float[] values = new float[node.getStatesSize()];
            values[0] = (float)weightedMean;
            values[1] = (float)weightedVariance;
            ((TreeVariable)node).initMarginalList();
            ((TreeVariable)node).addLikeliHood(values);
            ++i;
        }
    }

    protected void addAdjacentNodes(Node node, List<Node> nodeInNetwork) {
        nodeInNetwork.add(node);
        for (Node child : node.getChildren()) {
            if (!(child instanceof ProbabilisticNode) || nodeInNetwork.contains(child)) continue;
            this.addAdjacentNodes(child, nodeInNetwork);
        }
        for (Node parent : node.getParents()) {
            if (!(parent instanceof ProbabilisticNode) || nodeInNetwork.contains(parent)) continue;
            this.addAdjacentNodes(parent, nodeInNetwork);
        }
    }

    protected List<Integer> getParentsIndexesInQueue(ProbabilisticNode node) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        ArrayList<Node> parents = node.getParents();
        int i = 0;
        while (i < parents.size()) {
            Node parentNode = parents.get(i);
            indexes.add(this.getIndexInQueue(parentNode));
            ++i;
        }
        return indexes;
    }

    protected Integer getIndexInQueue(Node node) {
        int i = 0;
        while (i < this.nodeOrderQueue.size()) {
            if (node.getName().equals(this.nodeOrderQueue.get(i).getName())) {
                return i;
            }
            ++i;
        }
        return null;
    }

    protected ProbabilisticNetwork clonePN(ProbabilisticNetwork network) {
        ProbabilisticNetwork clone = null;
        XMLBIFIO io = new XMLBIFIO();
        try {
            File file = new File("clone.xml");
            io.save(file, network);
            clone = io.load(file);
            file.delete();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        catch (LoadException e) {
            e.printStackTrace();
        }
        return clone;
    }
}

