/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.bn;

import java.io.Serializable;
import java.util.ResourceBundle;
import unbbayes.prs.Node;
import unbbayes.prs.bn.PotentialTable;
import unbbayes.prs.id.DecisionNode;

public class ProbabilisticTable
extends PotentialTable
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.prs.bn.resources.BnResources");

    public void removeVariable(Node variavel) {
        this.calcularFatores();
        int index = this.variaveis.indexOf(variavel);
        if (variavel.getType() == 2) {
            DecisionNode decision = (DecisionNode)variavel;
            int statesSize = variavel.getStatesSize();
            if (decision.hasEvidence()) {
                this.finding(this.variaveis.size() - 1, index, new int[this.variaveis.size()], decision.getEvidence());
            } else {
                this.sum(index);
                int i = this.dados.size - 1;
                while (i >= 0) {
                    this.dados.data[i] = this.dados.data[i] / (float)statesSize;
                    --i;
                }
            }
        } else {
            this.sum(index);
        }
        this.variableModified();
        this.variaveis.remove(index);
    }

    public void removeVariable(Node variable, boolean normalize) {
        this.calcularFatores();
        int index = this.variaveis.indexOf(variable);
        if (variable.getType() == 2) {
            DecisionNode decision = (DecisionNode)variable;
            int statesSize = variable.getStatesSize();
            if (decision.hasEvidence()) {
                this.finding(this.variaveis.size() - 1, index, new int[this.variaveis.size()], decision.getEvidence());
            } else {
                this.sum(index);
                int i = this.dados.size - 1;
                while (i >= 0) {
                    this.dados.data[i] = this.dados.data[i] / (float)statesSize;
                    --i;
                }
            }
        } else {
            this.sum(index);
            if (normalize) {
                int statesSize = variable.getStatesSize();
                int i = this.dados.size - 1;
                while (i >= 0) {
                    this.dados.data[i] = this.dados.data[i] / (float)statesSize;
                    --i;
                }
            }
        }
        this.variableModified();
        this.variaveis.remove(index);
    }

    public void verifyConsistency() throws Exception {
        Node auxNo = (Node)this.variaveis.get(0);
        int noLin = auxNo.getStatesSize();
        if (noLin == 0) {
            return;
        }
        int noCol = 1;
        int sizeVariaveis = this.variaveis.size();
        int k = 1;
        while (k < sizeVariaveis) {
            auxNo = (Node)this.variaveis.get(k);
            noCol *= auxNo.getStatesSize();
            ++k;
        }
        int j = 0;
        while (j < noCol) {
            float soma = 0.0f;
            int i = 0;
            while (i < noLin) {
                soma += this.dados.data[j * noLin + i] * 100.0f;
                ++i;
            }
            if (Math.abs((double)soma - 100.0) > 0.01) {
                throw new Exception(String.valueOf(resource.getString("variableTableName")) + this.variaveis.get(0) + resource.getString("inconsistencyName") + soma + "%\n");
            }
            ++j;
        }
    }

    public PotentialTable newInstance() {
        return new ProbabilisticTable();
    }
}

