/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.bn;

import java.awt.Color;
import java.awt.Graphics2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.ResourceBundle;
import unbbayes.draw.DrawEllipse;
import unbbayes.prs.Node;
import unbbayes.prs.bn.ITabledVariable;
import unbbayes.prs.bn.PotentialTable;
import unbbayes.prs.bn.ProbabilisticTable;
import unbbayes.prs.bn.TreeVariable;
import unbbayes.util.SetToolkit;

public class ProbabilisticNode
extends TreeVariable
implements ITabledVariable,
Serializable {
    private static final long serialVersionUID = -8362313890037632119L;
    private ProbabilisticTable tabelaPot = new ProbabilisticTable();
    private static Color descriptionColor = Color.yellow;
    private static Color explanationColor = Color.green;
    private DrawEllipse drawEllipse = new DrawEllipse(this.position, size);
    private static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.prs.bn.resources.BnResources");

    public ProbabilisticNode() {
        this.drawElement.add(this.drawEllipse);
    }

    public int getType() {
        return 0;
    }

    public ProbabilisticNode clone(double raio) {
        ProbabilisticNode no = new ProbabilisticNode();
        int i = 0;
        while (i < this.getStatesSize()) {
            no.appendState(this.getStateAt(i));
            ++i;
        }
        ProbabilisticNode.setDescriptionColor(ProbabilisticNode.getDescriptionColor().getRGB());
        ProbabilisticNode.setExplanationColor(ProbabilisticNode.getExplanationColor().getRGB());
        no.setPosition(this.getPosition().getX() + 1.3 * raio, this.getPosition().getY() + 1.3 * raio);
        no.setName(String.valueOf(resource.getString("copyName")) + this.getName());
        no.setDescription(String.valueOf(resource.getString("copyName")) + this.getDescription());
        no.tabelaPot = (ProbabilisticTable)this.tabelaPot.clone();
        return no;
    }

    public Object clone() {
        ProbabilisticNode cloned = new ProbabilisticNode();
        cloned.tabelaPot = (ProbabilisticTable)this.tabelaPot.clone();
        ProbabilisticNode.setDescriptionColor(ProbabilisticNode.getDescriptionColor().getRGB());
        ProbabilisticNode.setExplanationColor(ProbabilisticNode.getExplanationColor().getRGB());
        cloned.setDescription(this.getDescription());
        cloned.setName(this.getName());
        cloned.setPosition(this.getPosition().getX(), this.getPosition().getY());
        cloned.setParents(SetToolkit.clone(this.parents));
        cloned.setChildren(SetToolkit.clone(this.getChildren()));
        cloned.setStates(SetToolkit.clone(this.states));
        cloned.setAdjacents(SetToolkit.clone(this.getAdjacents()));
        cloned.setSelected(this.isSelected());
        cloned.setExplanationDescription(this.getExplanationDescription());
        cloned.setPhrasesMap(this.getPhrasesMap());
        cloned.setInformationType(this.getInformationType());
        float[] marginais = new float[this.marginalList.length];
        System.arraycopy(this.marginalList, 0, marginais, 0, marginais.length);
        cloned.marginalList = marginais;
        return cloned;
    }

    public PotentialTable getPotentialTable() {
        return this.tabelaPot;
    }

    protected void marginal() {
        this.initMarginalList();
        PotentialTable auxTab = (PotentialTable)this.cliqueAssociado.getPotentialTable().clone();
        int index = auxTab.indexOfVariable(this);
        int size = this.cliqueAssociado.getPotentialTable().variableCount();
        int i = 0;
        while (i < size) {
            if (i != index) {
                auxTab.removeVariable(this.cliqueAssociado.getPotentialTable().getVariableAt(i));
            }
            ++i;
        }
        int tableSize = auxTab.tableSize();
        int i2 = 0;
        while (i2 < tableSize) {
            this.marginalList[i2] = auxTab.getValue(i2);
            ++i2;
        }
    }

    public void appendState(String state) {
        this.updateState(state, true);
    }

    public void removeLastState() {
        if (this.states.size() > 1) {
            this.updateState(null, false);
        }
    }

    private void updateState(String state, boolean isInsertion) {
        int k;
        ArrayList auxList;
        int l;
        PotentialTable auxTab;
        int d = this.getStatesSize();
        if (d > 0) {
            while (d <= this.tabelaPot.tableSize()) {
                if (isInsertion) {
                    this.tabelaPot.addValueAt(d++, 0.0f);
                } else {
                    this.tabelaPot.removeValueAt(d);
                }
                d += this.getStatesSize();
            }
        }
        ArrayList[] clones = new ArrayList[this.getChildren().size()];
        int[] indexes = new int[this.getChildren().size()];
        int i = 0;
        while (i < this.getChildren().size()) {
            if (this.getChildren().get(i).getType() != 2 && this.getChildren().get(i).getType() != 5) {
                auxTab = ((ITabledVariable)((Object)this.getChildren().get(i))).getPotentialTable();
                clones[i] = auxTab.cloneVariables();
                indexes[i] = auxTab.indexOfVariable(this);
            }
            ++i;
        }
        i = 0;
        while (i < this.getChildren().size()) {
            if (this.getChildren().get(i).getType() != 2 && this.getChildren().get(i).getType() != 5) {
                auxTab = ((ITabledVariable)((Object)this.getChildren().get(i))).getPotentialTable();
                l = indexes[i];
                auxList = clones[i];
                k = auxList.size() - 1;
                while (k >= l) {
                    auxTab.removeVariable((Node)auxList.get(k));
                    --k;
                }
            }
            ++i;
        }
        if (isInsertion) {
            super.appendState(state);
        } else {
            super.removeLastState();
        }
        i = 0;
        while (i < this.getChildren().size()) {
            if (this.getChildren().get(i).getType() != 2 && this.getChildren().get(i).getType() != 5) {
                auxTab = ((ITabledVariable)((Object)this.getChildren().get(i))).getPotentialTable();
                l = indexes[i];
                auxList = clones[i];
                k = l;
                while (k < auxList.size()) {
                    auxTab.addVariable((Node)auxList.get(k));
                    ++k;
                }
            }
            ++i;
        }
    }

    public static Color getDescriptionColor() {
        return descriptionColor;
    }

    public static void setDescriptionColor(int c) {
        descriptionColor = new Color(c);
    }

    public static void setExplanationColor(int c) {
        explanationColor = new Color(c);
    }

    public static Color getExplanationColor() {
        return explanationColor;
    }

    public void setSelected(boolean b) {
        this.drawEllipse.setSelected(b);
        super.setSelected(b);
    }

    public void paint(Graphics2D graphics) {
        if (this.getInformationType() == 3) {
            this.drawEllipse.setFillColor(ProbabilisticNode.getDescriptionColor());
        } else if (this.getInformationType() == 4) {
            this.drawEllipse.setFillColor(ProbabilisticNode.getExplanationColor());
        }
        super.paint(graphics);
    }
}

