/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.bn;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.ResourceBundle;
import unbbayes.prs.Node;
import unbbayes.util.FloatCollection;
import unbbayes.util.SetToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PotentialTable
implements Cloneable,
Serializable {
    public static final int PRODUCT_OPERATOR = 0;
    public static final int DIVISION_OPERATOR = 1;
    public static final int PLUS_OPERATOR = 2;
    public static final int MINUS_OPERATOR = 3;
    private boolean modified = true;
    private static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.prs.bn.resources.BnResources");
    protected ArrayList<Node> variaveis;
    protected FloatCollection dados = new FloatCollection();
    protected FloatCollection dataCopy = new FloatCollection();
    protected int[] fatores;

    public PotentialTable() {
        this.variaveis = new ArrayList();
    }

    public void copyData() {
        int dataSize = this.dados.size;
        int i = 0;
        while (i < dataSize) {
            this.dataCopy.add(this.dados.data[i]);
            ++i;
        }
    }

    public void restoreData() {
        int dataSize = this.dados.size;
        int i = 0;
        while (i < dataSize) {
            this.dados.data[i] = this.dataCopy.data[i];
            ++i;
        }
    }

    public void variableModified() {
        this.modified = true;
    }

    public ArrayList<Node> cloneVariables() {
        return SetToolkit.clone(this.variaveis);
    }

    public final int indexOfVariable(Node node) {
        return this.variaveis.indexOf(node);
    }

    public final int variableCount() {
        return this.variaveis.size();
    }

    public void setVariableAt(int index, Node node) {
        this.variableModified();
        this.variaveis.set(index, node);
    }

    public final Node getVariableAt(int index) {
        return this.variaveis.get(index);
    }

    public final int getVariableIndex(Node variable) {
        int i = 0;
        while (i < this.variaveis.size()) {
            if (this.variaveis.get(i) == variable) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void addValueAt(int index, float value) {
        this.dados.add(index, value);
    }

    public final void removeValueAt(int index) {
        this.dados.remove(index);
    }

    public int tableSize() {
        return this.dados.size;
    }

    public Object clone() {
        PotentialTable auxTab = this.newInstance();
        auxTab.variaveis = SetToolkit.clone(this.variaveis);
        int sizeDados = this.dados.size;
        int c = 0;
        while (c < sizeDados) {
            auxTab.dados.add(this.dados.data[c]);
            ++c;
        }
        return auxTab;
    }

    public void setValue(int[] coordenadas, float valor) {
        this.dados.data[this.getLinearCoord((int[])coordenadas)] = valor;
    }

    public final void setValue(int index, float valor) {
        this.dados.data[index] = valor;
    }

    public final float getValue(int index) {
        return this.dados.data[index];
    }

    public final float getValue(int[] coordenadas) {
        return this.dados.data[this.getLinearCoord(coordenadas)];
    }

    /*
     * Unable to fully structure code
     */
    public void addVariable(Node variavel) {
        block3: {
            this.variableModified();
            noEstados = variavel.getStatesSize();
            noCelBasica = this.dados.size;
            if (this.variaveis.size() != 0) ** GOTO lbl19
            i = 0;
            while (i < noEstados) {
                this.dados.add(0.0f);
                ++i;
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                --noEstados;
                i = 0;
                while (i < noCelBasica) {
                    this.dados.add(this.dados.data[i]);
                    ++i;
                }
lbl19:
                // 2 sources

                ** while (noEstados > 1)
            }
        }
        this.variaveis.add(variavel);
    }

    public void moveVariableWithoutMoveData(int initialPosition, int destinationPosition) {
        Node nodeToMove = this.variaveis.remove(initialPosition);
        this.variaveis.add(destinationPosition, nodeToMove);
    }

    public int getVariablesSize() {
        return this.variaveis.size();
    }

    public abstract void removeVariable(Node var1);

    public abstract void removeVariable(Node var1, boolean var2);

    public abstract PotentialTable newInstance();

    protected void sum(int index) {
        boolean[] marked = new boolean[this.dados.size];
        this.sumAux(this.variaveis.size() - 1, index, 0, 0, marked);
        int j = 0;
        int i = 0;
        while (i < this.dados.size) {
            if (!marked[i]) {
                this.dados.data[j++] = this.dados.data[i];
            }
            ++i;
        }
        this.dados.size = j;
    }

    private void sumAux(int control, int index, int coord, int base, boolean[] marked) {
        if (control == -1) {
            float value;
            int linearCoordDestination = coord - base;
            this.dados.data[linearCoordDestination] = value = this.dados.data[linearCoordDestination] + this.dados.data[coord];
            marked[coord] = true;
            return;
        }
        Node node = this.variaveis.get(control);
        if (control == index) {
            int i = node.getStatesSize() - 1;
            while (i >= 1) {
                this.sumAux(control - 1, index, coord + i * this.fatores[control], i * this.fatores[index], marked);
                --i;
            }
        } else {
            int i = node.getStatesSize() - 1;
            while (i >= 0) {
                this.sumAux(control - 1, index, coord + i * this.fatores[control], base, marked);
                --i;
            }
        }
    }

    protected void finding(int control, int index, int[] coord, int state) {
        if (control == -1) {
            int linearCoordToKill = this.getLinearCoord(coord);
            if (coord[index] == state) {
                float value;
                int linearCoordDestination = linearCoordToKill - coord[index] * this.fatores[index];
                this.dados.data[linearCoordDestination] = value = this.dados.data[linearCoordToKill];
            }
            this.dados.remove(linearCoordToKill);
            return;
        }
        int fim = index == control ? 1 : 0;
        Node node = this.variaveis.get(control);
        int i = node.getStatesSize() - 1;
        while (i >= fim) {
            coord[control] = i--;
            this.finding(control - 1, index, coord, state);
        }
    }

    public final int getLinearCoord(int[] coord) {
        this.calcularFatores();
        int coordLinear = 0;
        int sizeVariaveis = this.variaveis.size();
        int v = 0;
        while (v < sizeVariaveis) {
            coordLinear += coord[v] * this.fatores[v];
            ++v;
        }
        return coordLinear;
    }

    protected void calcularFatores() {
        if (!this.modified) {
            return;
        }
        this.modified = false;
        int sizeVariaveis = this.variaveis.size();
        if (this.fatores == null || this.fatores.length < sizeVariaveis) {
            this.fatores = new int[sizeVariaveis];
        }
        this.fatores[0] = 1;
        int i = 1;
        while (i < sizeVariaveis) {
            Node auxNo = this.variaveis.get(i - 1);
            this.fatores[i] = this.fatores[i - 1] * auxNo.getStatesSize();
            ++i;
        }
    }

    public final int[] voltaCoord(int index) {
        this.calcularFatores();
        int sizeVariaveis = this.variaveis.size();
        int[] coord = new int[sizeVariaveis];
        int i = sizeVariaveis - 1;
        while (index != 0) {
            int fatorI = this.fatores[i];
            coord[i--] = index / fatorI;
            index %= fatorI;
        }
        return coord;
    }

    public final void directOpTab(PotentialTable tab, int operator) {
        if (this.tableSize() != tab.tableSize()) {
            throw new RuntimeException(String.valueOf(resource.getString("TableSizeException")) + ": " + this.tableSize() + " " + tab.tableSize());
        }
        switch (operator) {
            case 0: {
                int k = this.tableSize() - 1;
                while (k >= 0) {
                    int n = k;
                    this.dados.data[n] = this.dados.data[n] * tab.dados.data[k];
                    --k;
                }
                break;
            }
            case 1: {
                int k = this.tableSize() - 1;
                while (k >= 0) {
                    if (tab.dados.data[k] != 0.0f) {
                        int n = k;
                        this.dados.data[n] = this.dados.data[n] / tab.dados.data[k];
                    } else {
                        this.dados.data[k] = 0.0f;
                    }
                    --k;
                }
                break;
            }
            case 3: {
                int k = this.tableSize() - 1;
                while (k >= 0) {
                    int n = k;
                    this.dados.data[n] = this.dados.data[n] - tab.dados.data[k];
                    --k;
                }
                break;
            }
        }
    }

    public final void opTab(PotentialTable tab, int operator) {
        int[] index = new int[this.variaveis.size()];
        int c = this.variaveis.size() - 1;
        while (c >= 0) {
            index[c] = tab.variaveis.indexOf(this.variaveis.get(c));
            --c;
        }
        this.calcularFatores();
        tab.calcularFatores();
        switch (operator) {
            case 0: {
                this.fastOpTabProd(0, 0, 0, index, tab);
                break;
            }
            case 2: {
                this.fastOpTabPlus(0, 0, 0, index, tab);
                break;
            }
            case 1: {
                this.fastOpTabDiv(0, 0, 0, index, tab);
            }
        }
    }

    private void fastOpTabPlus(int c, int linearA, int linearB, int[] index, PotentialTable tab) {
        if (c >= this.variaveis.size()) {
            int n = linearA;
            this.dados.data[n] = this.dados.data[n] + tab.dados.data[linearB];
            return;
        }
        if (index[c] == -1) {
            int i = this.variaveis.get(c).getStatesSize() - 1;
            while (i >= 0) {
                this.fastOpTabPlus(c + 1, linearA + i * this.fatores[c], linearB, index, tab);
                --i;
            }
        } else {
            int i = this.variaveis.get(c).getStatesSize() - 1;
            while (i >= 0) {
                this.fastOpTabPlus(c + 1, linearA + i * this.fatores[c], linearB + i * tab.fatores[index[c]], index, tab);
                --i;
            }
        }
    }

    private void fastOpTabProd(int c, int linearA, int linearB, int[] index, PotentialTable tab) {
        if (c >= this.variaveis.size()) {
            int n = linearA;
            this.dados.data[n] = this.dados.data[n] * tab.dados.data[linearB];
            return;
        }
        if (index[c] == -1) {
            int i = this.variaveis.get(c).getStatesSize() - 1;
            while (i >= 0) {
                this.fastOpTabProd(c + 1, linearA + i * this.fatores[c], linearB, index, tab);
                --i;
            }
        } else {
            int i = this.variaveis.get(c).getStatesSize() - 1;
            while (i >= 0) {
                this.fastOpTabProd(c + 1, linearA + i * this.fatores[c], linearB + i * tab.fatores[index[c]], index, tab);
                --i;
            }
        }
    }

    private void fastOpTabDiv(int c, int linearA, int linearB, int[] index, PotentialTable tab) {
        if (c >= this.variaveis.size()) {
            int n = linearA;
            this.dados.data[n] = this.dados.data[n] / tab.dados.data[linearB];
            return;
        }
        if (index[c] == -1) {
            int i = this.variaveis.get(c).getStatesSize() - 1;
            while (i >= 0) {
                this.fastOpTabDiv(c + 1, linearA + i * this.fatores[c], linearB, index, tab);
                --i;
            }
        } else {
            int i = this.variaveis.get(c).getStatesSize() - 1;
            while (i >= 0) {
                this.fastOpTabDiv(c + 1, linearA + i * this.fatores[c], linearB + i * tab.fatores[index[c]], index, tab);
                --i;
            }
        }
    }
}

