/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.bn;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import unbbayes.prs.Node;
import unbbayes.prs.bn.ITabledVariable;
import unbbayes.prs.bn.PotentialTable;
import unbbayes.prs.bn.ProbabilisticTable;
import unbbayes.prs.id.DecisionNode;
import unbbayes.prs.id.UtilityTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Clique
implements ITabledVariable,
Serializable {
    private static final long serialVersionUID = 0L;
    private static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.prs.bn.resources.BnResources");
    private int index;
    private Clique parent;
    private List<Clique> children = new ArrayList<Clique>();
    private PotentialTable potentialTable;
    private PotentialTable utilityTable;
    private ArrayList<Node> nos = new ArrayList();
    private ArrayList<Node> nosAssociados = new ArrayList();
    private ArrayList<Node> associatedUtilNodes = new ArrayList();

    public Clique() {
        this.potentialTable = new ProbabilisticTable();
        this.utilityTable = new UtilityTable();
    }

    public float normalize() throws Exception {
        boolean[] fixo = new boolean[this.nos.size()];
        ArrayList<Node> decisoes = new ArrayList<Node>();
        int i = 0;
        while (i < this.nos.size()) {
            if (this.nos.get(i).getType() == 2) {
                decisoes.add(this.nos.get(i));
                fixo[i] = true;
            }
            ++i;
        }
        if (decisoes.size() == 0) {
            return this.normalizeBN();
        }
        int[] index = new int[decisoes.size()];
        int i2 = 0;
        while (i2 < index.length) {
            index[i2] = this.nos.indexOf(decisoes.get(i2));
            ++i2;
        }
        this.normalizeID(0, decisoes, fixo, index, new int[this.nos.size()]);
        return 0.0f;
    }

    private float normalizeBN() throws Exception {
        float n = 0.0f;
        int sizeDados = this.potentialTable.tableSize();
        int c = 0;
        while (c < sizeDados) {
            n += this.potentialTable.getValue(c);
            ++c;
        }
        if (Math.abs((double)n - 1.0) > 0.001) {
            c = 0;
            while (c < sizeDados) {
                float valor = this.potentialTable.getValue(c);
                if ((double)n == 0.0) {
                    throw new Exception(resource.getString("InconsistencyUnderflowException"));
                }
                this.potentialTable.setValue(c, valor /= n);
                ++c;
            }
        }
        return n;
    }

    private void normalizeID(int control, ArrayList<Node> decisoes, boolean[] fixo, int[] index, int[] coord) throws Exception {
        if (control == decisoes.size()) {
            float soma = this.sum(0, fixo, coord);
            if ((double)soma == 0.0) {
                int k = 0;
                while (k < decisoes.size()) {
                    System.out.println(decisoes.get(k) + " - " + decisoes.get(k).getStateAt(coord[index[k]]));
                    ++k;
                }
                return;
            }
            this.div(0, fixo, coord, soma);
            return;
        }
        DecisionNode node = (DecisionNode)decisoes.get(control);
        if (node.hasEvidence()) {
            coord[index[control]] = node.getEvidence();
            this.normalizeID(control + 1, decisoes, fixo, index, coord);
            return;
        }
        int i = 0;
        while (i < node.getStatesSize()) {
            coord[index[control]] = i++;
            this.normalizeID(control + 1, decisoes, fixo, index, coord);
        }
    }

    private float sum(int control, boolean[] fixo, int[] coord) {
        if (control == this.nos.size()) {
            return this.potentialTable.getValue(coord);
        }
        if (fixo[control]) {
            return this.sum(control + 1, fixo, coord);
        }
        Node node = this.nos.get(control);
        float retorno = 0.0f;
        int i = 0;
        while (i < node.getStatesSize()) {
            coord[control] = i++;
            retorno += this.sum(control + 1, fixo, coord);
        }
        return retorno;
    }

    private void div(int control, boolean[] fixo, int[] coord, float soma) {
        if (control == this.nos.size()) {
            int cLinear = this.potentialTable.getLinearCoord(coord);
            this.potentialTable.setValue(cLinear, this.potentialTable.getValue(cLinear) / soma);
            return;
        }
        if (fixo[control]) {
            this.div(control + 1, fixo, coord, soma);
            return;
        }
        Node node = this.nos.get(control);
        int i = 0;
        while (i < node.getStatesSize()) {
            coord[control] = i++;
            this.div(control + 1, fixo, coord, soma);
        }
    }

    public void setParent(Clique pai) {
        this.parent = pai;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int indice) {
        this.index = indice;
    }

    public int getChildrenSize() {
        return this.children.size();
    }

    public void addChild(Clique child) {
        this.children.add(child);
    }

    public void removeChild(Clique c) {
        this.children.remove(c);
    }

    public Clique getChildAt(int index) {
        return this.children.get(index);
    }

    public ArrayList<Node> getNodes() {
        return this.nos;
    }

    public ArrayList<Node> getAssociatedProbabilisticNodes() {
        return this.nosAssociados;
    }

    public ArrayList<Node> getAssociatedUtilityNodes() {
        return this.associatedUtilNodes;
    }

    @Override
    public PotentialTable getPotentialTable() {
        return this.potentialTable;
    }

    public PotentialTable getUtilityTable() {
        return this.utilityTable;
    }

    public Clique getParent() {
        return this.parent;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int j = this.nos.size() - 1;
        while (j >= 0) {
            sb.append(this.nos.get(j) + " ");
            --j;
        }
        return sb.toString();
    }
}

